/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.RequestExecutor;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.v30.ProtocolChannel;
import com.impossibl.postgres.protocol.v30.ProtocolHandler;
import com.impossibl.postgres.protocol.v30.ServerRequest;
import java.io.IOException;
import java.util.Collections;

public class SynchronizeRequest
implements ServerRequest {
    private RequestExecutor.SynchronizedHandler handler;

    SynchronizeRequest(RequestExecutor.SynchronizedHandler handler) {
        this.handler = handler;
    }

    @Override
    public ProtocolHandler createHandler() {
        return new SyncedHandler();
    }

    @Override
    public void execute(ProtocolChannel channel) throws IOException {
        channel.writeSync().flush();
    }

    class SyncedHandler
    implements ProtocolHandler.ReadyForQuery {
        SyncedHandler() {
        }

        public String toString() {
            return "Synchronize";
        }

        @Override
        public ProtocolHandler.Action readyForQuery(TransactionStatus txnStatus) throws IOException {
            SynchronizeRequest.this.handler.handleReady(txnStatus);
            return ProtocolHandler.Action.Complete;
        }

        @Override
        public void exception(Throwable cause) throws IOException {
            SynchronizeRequest.this.handler.handleError(cause, Collections.emptyList());
        }
    }
}

