/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system;

import com.impossibl.postgres.datetime.DateTimeFormat;
import com.impossibl.postgres.datetime.ISODateFormat;
import com.impossibl.postgres.datetime.ISOIntervalFormat;
import com.impossibl.postgres.datetime.ISOTimeFormat;
import com.impossibl.postgres.datetime.ISOTimestampFormat;
import com.impossibl.postgres.datetime.IntervalFormat;
import com.impossibl.postgres.datetime.PostgresIntervalFormat;
import com.impossibl.postgres.protocol.FieldFormat;
import com.impossibl.postgres.protocol.FieldFormatRef;
import com.impossibl.postgres.protocol.RequestExecutor;
import com.impossibl.postgres.protocol.RequestExecutorHandlers;
import com.impossibl.postgres.protocol.ResultBatch;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.RowData;
import com.impossibl.postgres.protocol.ServerConnection;
import com.impossibl.postgres.protocol.ServerConnectionFactory;
import com.impossibl.postgres.system.AbstractContext;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.DateStyle;
import com.impossibl.postgres.system.Empty;
import com.impossibl.postgres.system.IntervalStyle;
import com.impossibl.postgres.system.ServerConnectionInfo;
import com.impossibl.postgres.system.ServerInfo;
import com.impossibl.postgres.system.Setting;
import com.impossibl.postgres.system.Settings;
import com.impossibl.postgres.system.SystemSettings;
import com.impossibl.postgres.system.Version;
import com.impossibl.postgres.system.tables.PGTypeTable;
import com.impossibl.postgres.types.ArrayType;
import com.impossibl.postgres.types.BaseType;
import com.impossibl.postgres.types.CompositeType;
import com.impossibl.postgres.types.DomainType;
import com.impossibl.postgres.types.EnumerationType;
import com.impossibl.postgres.types.PsuedoType;
import com.impossibl.postgres.types.QualifiedName;
import com.impossibl.postgres.types.RangeType;
import com.impossibl.postgres.types.Registry;
import com.impossibl.postgres.types.SharedRegistry;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.ByteBufs;
import com.impossibl.postgres.utils.Locales;
import com.impossibl.postgres.utils.Timer;
import com.impossibl.postgres.utils.guava.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelFuture;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class BasicContext
extends AbstractContext {
    private static final long INTERNAL_QUERY_TIMEOUT = TimeUnit.SECONDS.toMillis(60L);
    private static final Logger logger = Logger.getLogger(BasicContext.class.getName());
    protected Registry registry;
    protected Map<String, Class<?>> typeMap = new HashMap();
    protected Charset charset;
    protected Settings settings;
    private TimeZone timeZone;
    private ZoneId timeZoneId;
    private DateTimeFormat clientDateFormat;
    private DateTimeFormat serverDateFormat;
    private DateTimeFormat clientTimeFormat;
    private DateTimeFormat serverTimeFormat;
    private DateTimeFormat clientTimestampFormat;
    private DateTimeFormat serverTimestampFormat;
    private IntervalFormat clientIntervalFormat;
    private IntervalFormat serverIntervalFormat;
    private NumberFormat clientIntegerFormatter;
    private NumberFormat clientDecimalFormatter;
    private NumberFormat clientCurrencyFormatter;
    private NumberFormat serverCurrencyFormatter;
    private ServerConnection serverConnection;
    private ServerConnectionListener serverConnectionListener;
    private Map<String, QueryDescription> utilQueries;

    public BasicContext(SocketAddress address, Settings settings) throws IOException {
        this.settings = settings;
        this.charset = StandardCharsets.UTF_8;
        this.timeZone = TimeZone.getTimeZone("UTC");
        this.serverDateFormat = this.clientDateFormat = new ISODateFormat();
        this.serverTimeFormat = this.clientTimeFormat = new ISOTimeFormat();
        this.serverTimestampFormat = this.clientTimestampFormat = new ISOTimestampFormat();
        this.serverIntervalFormat = this.clientIntervalFormat = new ISOIntervalFormat();
        this.serverConnectionListener = new ServerConnectionListener();
        this.serverConnection = ServerConnectionFactory.getDefault().connect(this, address, this.serverConnectionListener);
        this.utilQueries = new HashMap<String, QueryDescription>();
    }

    protected ChannelFuture shutdown() {
        return this.serverConnection.shutdown();
    }

    protected void connectionClosed() {
        this.shutdown().awaitUninterruptibly();
    }

    protected void connectionNotificationReceived(int processId, String channelName, String payload) {
    }

    @Override
    public ByteBufAllocator getAllocator() {
        return this.serverConnection.getAllocator();
    }

    protected ServerConnection getServerConnection() {
        return this.serverConnection;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public RequestExecutor getRequestExecutor() {
        return this.serverConnection.getRequestExecutor();
    }

    @Override
    public <T> T getSetting(Setting<T> setting) {
        T value = this.settings.getStored(setting);
        if (value != null) {
            return value;
        }
        return super.getSetting(setting);
    }

    @Override
    public Map<String, Class<?>> getCustomTypeMap() {
        return this.typeMap;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public ZoneId getTimeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public ServerInfo getServerInfo() {
        return this.serverConnection.getServerInfo();
    }

    @Override
    public ServerConnection.KeyData getKeyData() {
        return this.serverConnection.getKeyData();
    }

    @Override
    public DateTimeFormat getServerDateFormat() {
        return this.serverDateFormat;
    }

    @Override
    public DateTimeFormat getClientDateFormat() {
        return this.clientDateFormat;
    }

    @Override
    public DateTimeFormat getServerTimeFormat() {
        return this.serverTimeFormat;
    }

    @Override
    public DateTimeFormat getClientTimeFormat() {
        return this.clientTimeFormat;
    }

    @Override
    public IntervalFormat getServerIntervalFormat() {
        return this.serverIntervalFormat;
    }

    @Override
    public IntervalFormat getClientIntervalFormat() {
        return this.clientIntervalFormat;
    }

    @Override
    public DateTimeFormat getServerTimestampFormat() {
        return this.serverTimestampFormat;
    }

    @Override
    public DateTimeFormat getClientTimestampFormat() {
        return this.clientTimestampFormat;
    }

    @Override
    public NumberFormat getClientIntegerFormatter() {
        return this.clientIntegerFormatter;
    }

    @Override
    public NumberFormat getClientDecimalFormatter() {
        return this.clientDecimalFormatter;
    }

    @Override
    public NumberFormat getServerCurrencyFormatter() {
        return this.serverCurrencyFormatter;
    }

    @Override
    public NumberFormat getClientCurrencyFormatter() {
        return this.clientCurrencyFormatter;
    }

    protected void init(SharedRegistry.Factory sharedRegistryFactory) throws IOException {
        String database = this.getSetting(SystemSettings.DATABASE_NAME, this.getSetting(SystemSettings.SESSION_USER));
        ServerConnectionInfo serverConnectionInfo = new ServerConnectionInfo(this.serverConnection.getServerInfo(), this.serverConnection.getRemoteAddress(), database);
        this.registry = new Registry(sharedRegistryFactory.get(serverConnectionInfo), new RegistryTypeLoader());
        this.clientIntegerFormatter = NumberFormat.getIntegerInstance(Locale.getDefault());
        this.clientIntegerFormatter.setGroupingUsed(false);
        this.clientIntegerFormatter.setParseIntegerOnly(true);
        this.clientDecimalFormatter = DecimalFormat.getNumberInstance(Locale.getDefault());
        this.clientDecimalFormatter.setGroupingUsed(false);
        ((DecimalFormat)this.clientDecimalFormatter).setParseBigDecimal(true);
        this.serverCurrencyFormatter = DecimalFormat.getCurrencyInstance(Locale.ROOT);
        this.serverCurrencyFormatter.setGroupingUsed(false);
        ((DecimalFormat)this.serverCurrencyFormatter).setParseBigDecimal(true);
        this.clientCurrencyFormatter = DecimalFormat.getCurrencyInstance(Locale.getDefault());
        this.clientCurrencyFormatter.setGroupingUsed(false);
        ((DecimalFormat)this.clientCurrencyFormatter).setParseBigDecimal(true);
        this.loadTypes();
        this.prepareRefreshTypeQueries();
        this.loadServerLocales();
    }

    private void loadServerLocales() throws IOException {
        try (ResultBatch resultBatch = this.queryBatch("SELECT name, setting FROM pg_settings WHERE name IN ('lc_monetary')", INTERNAL_QUERY_TIMEOUT);){
            for (RowData rowData : resultBatch.borrowRows().borrowAll()) {
                String name;
                String localeSpec = rowData.getField(1, resultBatch.getFields()[1], this, String.class, null).toString();
                Locale locale = Locales.parseLocale(localeSpec);
                if (locale == null) {
                    logger.log(Level.WARNING, "Locale {} could not be mapped to a Java locale, using the default (aka POSIX) locale", localeSpec);
                    locale = Locale.ROOT;
                }
                if (!"lc_monetary".equals(name = rowData.getField(0, resultBatch.getFields()[1], this, String.class, null).toString())) continue;
                this.serverCurrencyFormatter = NumberFormat.getCurrencyInstance(locale);
                this.serverCurrencyFormatter.setGroupingUsed(false);
                ((DecimalFormat)this.serverCurrencyFormatter).setParseBigDecimal(true);
            }
        }
    }

    private void loadTypes() throws IOException {
        SharedRegistry.Seeder seeder = registry -> {
            logger.config("Seeding registry");
            Timer timer = new Timer();
            String typeSQL = PGTypeTable.INSTANCE.getSQL(this.serverConnection.getServerInfo().getVersion());
            List pgTypes = PGTypeTable.INSTANCE.query(this, typeSQL + " WHERE typrelid = 0", INTERNAL_QUERY_TIMEOUT, new Object[0]);
            Set baseTypeRows = pgTypes.stream().filter(PGTypeTable.Row::isBase).collect(Collectors.toSet());
            Set baseTypeOids = baseTypeRows.stream().map(PGTypeTable.Row::getOid).collect(Collectors.toSet());
            Set baseReferencingRows = pgTypes.stream().filter(row -> baseTypeOids.contains(row.getReferencingTypeOid())).collect(Collectors.toSet());
            ArrayList<Type> baseTypes = new ArrayList<Type>();
            for (Object row2 : baseTypeRows) {
                if (((PGTypeTable.Row)row2).isArray()) continue;
                Type type = this.loadRaw((PGTypeTable.Row)row2);
                baseTypes.add(type);
            }
            registry.addTypes(baseTypes);
            ArrayList<Type> baseReferencingTypes = new ArrayList<Type>();
            for (PGTypeTable.Row baseReferencingRow : baseReferencingRows) {
                Type type = this.loadRaw(baseReferencingRow);
                baseReferencingTypes.add(type);
            }
            registry.addTypes(baseReferencingTypes);
            ArrayList<Type> psuedoTypes = new ArrayList<Type>();
            for (PGTypeTable.Row pgType : pgTypes) {
                if (!pgType.isPsuedo() || registry.hasTypeDefined(pgType.getOid())) continue;
                Type type = this.loadRaw(pgType);
                psuedoTypes.add(type);
            }
            registry.addTypes(psuedoTypes);
            logger.fine("Seed time: " + timer.getLap() + "ms");
        };
        if (!this.registry.getShared().seed(seeder)) {
            logger.config("Using pre-seeded registry");
        }
    }

    private void prepareRefreshTypeQueries() throws IOException {
        Version serverVersion = this.serverConnection.getServerInfo().getVersion();
        this.prepareUtilQuery("refresh-type", PGTypeTable.INSTANCE.getSQL(serverVersion) + " WHERE t.oid = $1", new String[0]);
        this.prepareUtilQuery("refresh-named-type", PGTypeTable.INSTANCE.getSQL(serverVersion) + " WHERE t.oid = $1::text::regtype", new String[0]);
        this.prepareUtilQuery("refresh-reltype", PGTypeTable.INSTANCE.getSQL(serverVersion) + " WHERE t.typrelid = $1", "int4");
    }

    private Type loadType(int typeId) throws IOException {
        List pgTypes = PGTypeTable.INSTANCE.query(this, "@refresh-type", INTERNAL_QUERY_TIMEOUT, typeId);
        if (pgTypes.isEmpty()) {
            return null;
        }
        PGTypeTable.Row pgType = (PGTypeTable.Row)pgTypes.get(0);
        return this.loadRaw(pgType);
    }

    private Type loadType(String typeName) throws IOException {
        List pgTypes = PGTypeTable.INSTANCE.query(this, "@refresh-named-type", INTERNAL_QUERY_TIMEOUT, typeName);
        if (pgTypes.isEmpty()) {
            return null;
        }
        PGTypeTable.Row pgType = (PGTypeTable.Row)pgTypes.get(0);
        return this.loadRaw(pgType);
    }

    private CompositeType loadRelationType(int relationId) throws IOException {
        List pgTypes = PGTypeTable.INSTANCE.query(this, "@refresh-reltype", INTERNAL_QUERY_TIMEOUT, relationId);
        if (pgTypes.isEmpty()) {
            return null;
        }
        PGTypeTable.Row pgType = (PGTypeTable.Row)pgTypes.get(0);
        if (pgType.getRelationId() == 0) {
            return null;
        }
        return (CompositeType)this.loadRaw(pgType);
    }

    private Type loadRaw(PGTypeTable.Row pgType) throws IOException {
        Type type;
        if (pgType.getElementTypeId() != 0 && pgType.getCategory().equals("A")) {
            type = new ArrayType();
        } else {
            switch (pgType.getDiscriminator().charAt(0)) {
                case 'b': {
                    type = new BaseType();
                    break;
                }
                case 'c': {
                    type = new CompositeType();
                    break;
                }
                case 'd': {
                    type = new DomainType();
                    break;
                }
                case 'e': {
                    type = new EnumerationType();
                    break;
                }
                case 'p': {
                    type = new PsuedoType();
                    break;
                }
                case 'r': {
                    type = new RangeType();
                    break;
                }
                default: {
                    logger.warning("unknown discriminator (aka 'typtype') found in pg_type table");
                    return null;
                }
            }
        }
        type.load(pgType, this.registry);
        return type;
    }

    public boolean isUtilQueryPrepared(String name) {
        return this.utilQueries.containsKey(name);
    }

    public void prepareUtilQuery(String name, String sql, String ... parameterTypeNames) throws IOException {
        Type[] parameterTypes = new Type[parameterTypeNames.length];
        for (int parameterIdx = 0; parameterIdx < parameterTypes.length; ++parameterIdx) {
            parameterTypes[parameterIdx] = this.registry.loadBaseType(parameterTypeNames[parameterIdx]);
        }
        this.prepareUtilQuery(name, sql, parameterTypes);
    }

    private void prepareUtilQuery(String name, String sql, Type[] parameterTypes) throws IOException {
        RequestExecutorHandlers.PrepareResult handler = new RequestExecutorHandlers.PrepareResult();
        this.serverConnection.getRequestExecutor().prepare(name, sql, parameterTypes, handler);
        handler.await(INTERNAL_QUERY_TIMEOUT, TimeUnit.MILLISECONDS);
        QueryDescription desc = new QueryDescription(name, sql, handler.getDescribedParameterTypes(this), handler.getDescribedResultFields());
        this.utilQueries.put(name, desc);
    }

    private QueryDescription prepareQuery(String queryTxt) throws IOException {
        if (queryTxt.charAt(0) == '@') {
            QueryDescription util = this.utilQueries.get(queryTxt.substring(1));
            if (util == null) {
                throw new IOException("invalid utility query");
            }
            return util;
        }
        RequestExecutorHandlers.PrepareResult handler = new RequestExecutorHandlers.PrepareResult();
        this.serverConnection.getRequestExecutor().prepare(null, queryTxt, Empty.EMPTY_TYPES, handler);
        handler.await(INTERNAL_QUERY_TIMEOUT, TimeUnit.MILLISECONDS);
        return new QueryDescription(null, queryTxt, handler.getDescribedParameterTypes(this), handler.getDescribedResultFields());
    }

    public void query(String queryTxt, long timeout) throws IOException {
        if (queryTxt.charAt(0) == '@') {
            QueryDescription pq = this.prepareQuery(queryTxt);
            this.queryBatchPrepared(pq.name, Empty.EMPTY_FORMATS, Empty.EMPTY_BUFFERS, pq.resultFields, timeout).close();
        } else {
            RequestExecutorHandlers.QueryResult handler = new RequestExecutorHandlers.QueryResult();
            this.serverConnection.getRequestExecutor().query(queryTxt, handler);
            handler.await(timeout, TimeUnit.MILLISECONDS);
            handler.getBatch().close();
        }
    }

    protected String queryString(String queryTxt, long timeout) throws IOException {
        try (ResultBatch resultBatch = this.queryBatch(queryTxt, timeout);){
            Object field = resultBatch.borrowRows().borrow(0).getField(0, resultBatch.getFields()[0], this, String.class, null);
            String val = field == null ? null : field.toString();
            String string = Strings.nullToEmpty(val);
            return string;
        }
    }

    protected ResultBatch queryBatch(String queryTxt, long timeout) throws IOException {
        if (queryTxt.charAt(0) == '@') {
            QueryDescription pq = this.prepareQuery(queryTxt);
            return this.queryBatchPrepared(pq.name, Empty.EMPTY_FORMATS, Empty.EMPTY_BUFFERS, pq.resultFields, timeout);
        }
        RequestExecutorHandlers.QueryResult handler = new RequestExecutorHandlers.QueryResult();
        this.serverConnection.getRequestExecutor().query(queryTxt, handler);
        handler.await(timeout, TimeUnit.MILLISECONDS);
        return handler.getBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultBatch queryBatchPrepared(String queryTxt, Object[] paramValues, long timeout) throws IOException {
        QueryDescription pq = this.prepareQuery(queryTxt);
        FieldFormatRef[] paramFormats = Empty.EMPTY_FORMATS;
        ByteBuf[] paramBuffers = Empty.EMPTY_BUFFERS;
        try {
            if (paramValues.length != 0) {
                paramFormats = new FieldFormat[paramValues.length];
                paramBuffers = new ByteBuf[paramValues.length];
                block7: for (int paramIdx = 0; paramIdx < paramValues.length; ++paramIdx) {
                    Type paramType = pq.parameterTypes[paramIdx];
                    Object paramValue = paramValues[paramIdx];
                    if (paramValue == null) continue;
                    FieldFormat paramFormat = paramType.getParameterFormat();
                    paramFormats[paramIdx] = paramFormat;
                    switch (paramFormat) {
                        case Text: {
                            Comparable<StringBuilder> out = new StringBuilder();
                            paramType.getTextCodec().getEncoder().encode(this, paramType, paramValue, null, (StringBuilder)out);
                            paramBuffers[paramIdx] = ByteBufUtil.writeUtf8(this.getAllocator(), (CharSequence)((Object)out));
                            continue block7;
                        }
                        case Binary: {
                            Comparable<StringBuilder> out = this.getAllocator().buffer();
                            paramType.getBinaryCodec().getEncoder().encode(this, paramType, paramValue, null, (StringBuilder)out);
                            paramBuffers[paramIdx] = out;
                        }
                    }
                }
            }
            ResultBatch resultBatch = this.queryBatchPrepared(pq.name, paramFormats, paramBuffers, pq.resultFields, timeout);
            return resultBatch;
        }
        finally {
            ByteBufs.releaseAll(paramBuffers);
        }
    }

    protected ResultBatch queryBatchPrepared(String queryTxt, FieldFormatRef[] paramFormats, ByteBuf[] paramBuffers, long timeout) throws IOException {
        QueryDescription pq = this.prepareQuery(queryTxt);
        return this.queryBatchPrepared(pq.name, paramFormats, paramBuffers, pq.resultFields, timeout);
    }

    private ResultBatch queryBatchPrepared(String statementName, FieldFormatRef[] paramFormats, ByteBuf[] paramBuffers, ResultField[] resultFields, long timeout) throws IOException {
        RequestExecutorHandlers.ExecuteResult handler = new RequestExecutorHandlers.ExecuteResult(resultFields);
        this.serverConnection.getRequestExecutor().execute(null, statementName, paramFormats, paramBuffers, resultFields, 0, handler);
        handler.await(timeout, TimeUnit.MILLISECONDS);
        return handler.getBatch();
    }

    private void updateSystemParameter(String name, String value) {
        logger.config("system parameter: " + name + "=" + value);
        switch (name) {
            case "DateStyle": {
                String[] parsedDateStyle = DateStyle.parse(value);
                if (parsedDateStyle == null) {
                    logger.warning("Invalid DateStyle encountered");
                    break;
                }
                this.serverDateFormat = DateStyle.getDateFormat(parsedDateStyle);
                if (this.serverDateFormat == null) {
                    logger.warning("Unknown Date format, reverting to default");
                    this.serverDateFormat = new ISODateFormat();
                }
                this.serverTimeFormat = DateStyle.getTimeFormat(parsedDateStyle);
                if (this.serverTimeFormat == null) {
                    logger.warning("Unknown Time format, reverting to default");
                    this.serverTimeFormat = new ISOTimeFormat();
                }
                this.serverTimestampFormat = DateStyle.getTimestampFormat(parsedDateStyle);
                if (this.serverTimestampFormat != null) break;
                logger.warning("Unknown Timestamp format, reverting to default");
                this.serverTimestampFormat = new ISOTimestampFormat();
                break;
            }
            case "IntervalStyle": {
                try {
                    IntervalStyle intervalStyle = IntervalStyle.valueOf(value.toUpperCase());
                    switch (intervalStyle) {
                        case ISO_8601: {
                            this.serverIntervalFormat = new ISOIntervalFormat();
                            break;
                        }
                        case POSTGRES: 
                        case POSTGRES_VERBOSE: {
                            this.serverIntervalFormat = new PostgresIntervalFormat();
                            break;
                        }
                        case SQL_STANDARD: {
                            logger.warning("Unsupported IntervalStyle, reverting to default");
                            this.serverIntervalFormat = new PostgresIntervalFormat();
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.warning("Unrecognized IntervalStyle encountered");
                }
                break;
            }
            case "TimeZone": {
                value = value.contains("+") ? value.replace('+', '-') : value.replace('-', '+');
                this.timeZone = TimeZone.getTimeZone(value);
                this.timeZoneId = this.timeZone.toZoneId();
                break;
            }
            case "client_encoding": {
                this.charset = Charset.forName(value);
                break;
            }
            case "standard_conforming_strings": {
                this.settings.set(SystemSettings.STANDARD_CONFORMING_STRINGS, value.equals("on"));
                break;
            }
            case "session_authorization": {
                this.settings.set(SystemSettings.SESSION_USER, value);
                break;
            }
            case "application_name": {
                this.settings.set(SystemSettings.APPLICATION_NAME, value);
                break;
            }
        }
    }

    @Override
    public Context unwrap() {
        return this;
    }

    private class ServerConnectionListener
    implements ServerConnection.Listener {
        private ServerConnectionListener() {
        }

        @Override
        public void parameterStatusChanged(String name, String value) {
            BasicContext.this.updateSystemParameter(name, value);
        }

        @Override
        public void notificationReceived(int processId, String channelName, String payload) {
            BasicContext.this.connectionNotificationReceived(processId, channelName, payload);
        }

        @Override
        public InputStream openStandardInput() {
            return System.in;
        }

        @Override
        public OutputStream openStandardOutput() {
            return System.out;
        }

        @Override
        public void closed() {
            BasicContext.this.connectionClosed();
        }
    }

    private class RegistryTypeLoader
    implements Registry.TypeLoader {
        private RegistryTypeLoader() {
        }

        @Override
        public Type load(int oid) throws IOException {
            return BasicContext.this.loadType(oid);
        }

        @Override
        public CompositeType loadRelation(int relationOid) throws IOException {
            return BasicContext.this.loadRelationType(relationOid);
        }

        @Override
        public Type load(QualifiedName name) throws IOException {
            return BasicContext.this.loadType(name.toString());
        }

        @Override
        public Type load(String name) throws IOException {
            return BasicContext.this.loadType(name);
        }
    }

    private static class QueryDescription {
        String name;
        String sql;
        Type[] parameterTypes;
        ResultField[] resultFields;

        QueryDescription(String name, String sql, Type[] parameterTypes, ResultField[] resultFields) {
            this.name = name;
            this.sql = sql;
            this.parameterTypes = parameterTypes;
            this.resultFields = resultFields;
        }
    }
}

