/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.procs.AutoConvertingBinaryDecoder;
import com.impossibl.postgres.system.procs.AutoConvertingBinaryEncoder;
import com.impossibl.postgres.system.procs.AutoConvertingDecoder;
import com.impossibl.postgres.system.procs.AutoConvertingEncoder;
import com.impossibl.postgres.system.procs.AutoConvertingTextDecoder;
import com.impossibl.postgres.system.procs.AutoConvertingTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;

public class UInt4s
extends SimpleProcProvider {
    public UInt4s() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "xid", "cid", "regproc", "regtype", "regclass", "regoper", "regnamespace", "regrole");
    }

    static class TxtEncoder
    extends AutoConvertingTextEncoder<Integer> {
        TxtEncoder() {
            super(new EncodingConverter());
        }

        @Override
        public Class<Integer> getDefaultClass() {
            return Integer.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Integer value, Object sourceContext, StringBuilder buffer) throws IOException {
            buffer.append(Integer.toUnsignedString(value));
        }
    }

    static class TxtDecoder
    extends AutoConvertingTextDecoder<Integer> {
        TxtDecoder() {
            super(new DecodingConverter());
        }

        @Override
        public Class<Integer> getDefaultClass() {
            return Integer.class;
        }

        @Override
        protected Integer decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            return Integer.parseUnsignedInt(buffer.toString());
        }
    }

    static class BinEncoder
    extends AutoConvertingBinaryEncoder<Integer> {
        BinEncoder() {
            super((Integer)4, new EncodingConverter());
        }

        @Override
        public Class<Integer> getDefaultClass() {
            return Integer.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Integer value, Object sourceContext, ByteBuf buffer) throws IOException {
            buffer.writeInt(value);
        }
    }

    static class BinDecoder
    extends AutoConvertingBinaryDecoder<Integer> {
        BinDecoder() {
            super((Integer)4, new DecodingConverter());
        }

        @Override
        public Class<Integer> getDefaultClass() {
            return Integer.class;
        }

        @Override
        protected Integer decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            return buffer.readInt();
        }
    }

    static class DecodingConverter
    implements AutoConvertingDecoder.Converter<Integer> {
        DecodingConverter() {
        }

        @Override
        public Object convert(Context context, Integer decoded, Class<?> targetClass, Object targetContext) throws ConversionException {
            if (targetClass == String.class) {
                return Integer.toUnsignedString(decoded);
            }
            if (targetClass == BigDecimal.class) {
                long longVal = Integer.toUnsignedLong(decoded);
                return BigDecimal.valueOf(longVal);
            }
            if (targetClass == BigInteger.class) {
                long longVal = Integer.toUnsignedLong(decoded);
                return BigInteger.valueOf(longVal);
            }
            if (targetClass == Boolean.class || targetClass == Boolean.TYPE) {
                return decoded.byteValue() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            if (targetClass == Byte.class || targetClass == Byte.TYPE) {
                long longVal = Integer.toUnsignedLong(decoded);
                if (longVal < -128L || longVal > 127L) {
                    throw new ArithmeticException("Value out of byte range");
                }
                return (byte)longVal;
            }
            if (targetClass == Short.class || targetClass == Short.TYPE) {
                long longVal = Integer.toUnsignedLong(decoded);
                if (longVal < -32768L || longVal > 32767L) {
                    throw new ArithmeticException("Value out of short range");
                }
                return (short)longVal;
            }
            if (targetClass == Integer.class || targetClass == Integer.TYPE) {
                long longVal = Integer.toUnsignedLong(decoded);
                if (longVal < Integer.MIN_VALUE || longVal > Integer.MAX_VALUE) {
                    throw new ArithmeticException("Value out of int range");
                }
                return (int)longVal;
            }
            if (targetClass == Long.class || targetClass == Long.TYPE) {
                return Integer.toUnsignedLong(decoded);
            }
            return null;
        }
    }

    static class EncodingConverter
    implements AutoConvertingEncoder.Converter<Integer> {
        EncodingConverter() {
        }

        @Override
        public Integer convert(Context context, Object source, Object sourceContext) throws ConversionException {
            if (source instanceof String) {
                try {
                    return Integer.parseUnsignedInt((String)source);
                }
                catch (NumberFormatException e) {
                    throw new ConversionException("Invalid unsigned integer", e);
                }
            }
            if (source instanceof Boolean) {
                boolean boolVal = (Boolean)source;
                return boolVal ? 1 : 0;
            }
            if (source instanceof Number) {
                Number numberVal = (Number)source;
                return (int)numberVal.longValue();
            }
            return null;
        }
    }
}

