/*
 * Decompiled with CFR 0.152.
 */
package org.rnorth.ducttape.timeouts;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.rnorth.ducttape.Preconditions;
import org.rnorth.ducttape.TimeoutException;

public class Timeouts {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool(new ThreadFactory(){
        final AtomicInteger threadCounter = new AtomicInteger(0);

        @Override
        public Thread newThread(@NotNull Runnable r) {
            Thread thread = new Thread(r, "ducttape-" + this.threadCounter.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    });

    public static <T> T getWithTimeout(int timeout, TimeUnit timeUnit, @NotNull Callable<T> lambda) {
        Preconditions.check("timeout must be greater than zero", timeout > 0);
        Future<T> future = EXECUTOR_SERVICE.submit(lambda);
        return Timeouts.callFuture(timeout, timeUnit, future);
    }

    public static void doWithTimeout(int timeout, @NotNull TimeUnit timeUnit, @NotNull Runnable lambda) {
        Preconditions.check("timeout must be greater than zero", timeout > 0);
        Future<?> future = EXECUTOR_SERVICE.submit(lambda);
        Timeouts.callFuture(timeout, timeUnit, future);
    }

    private static <T> T callFuture(int timeout, @NotNull TimeUnit timeUnit, @NotNull Future<T> future) {
        try {
            return future.get(timeout, timeUnit);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (InterruptedException | java.util.concurrent.TimeoutException e) {
            throw new TimeoutException(e);
        }
    }
}

