/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class PostgreSQLContainer<SELF extends PostgreSQLContainer<SELF>>
extends JdbcDatabaseContainer<SELF> {
    public static final String NAME = "postgresql";
    public static final String IMAGE = "postgres";
    public static final String DEFAULT_TAG = "9.6.12";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse("postgres");
    public static final Integer POSTGRESQL_PORT = 5432;
    static final String DEFAULT_USER = "test";
    static final String DEFAULT_PASSWORD = "test";
    private String databaseName = "test";
    private String username = "test";
    private String password = "test";
    private static final String FSYNC_OFF_OPTION = "fsync=off";
    private static final String QUERY_PARAM_SEPARATOR = "&";

    @Deprecated
    public PostgreSQLContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    public PostgreSQLContainer(String dockerImageName) {
        this(DockerImageName.parse(dockerImageName));
    }

    public PostgreSQLContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(DEFAULT_IMAGE_NAME);
        this.waitStrategy = new LogMessageWaitStrategy().withRegEx(".*database system is ready to accept connections.*\\s").withTimes(2).withStartupTimeout(Duration.of(60L, ChronoUnit.SECONDS));
        this.setCommand(IMAGE, "-c", FSYNC_OFF_OPTION);
        this.addExposedPort(POSTGRESQL_PORT);
    }

    @Override
    @NotNull
    protected Set<Integer> getLivenessCheckPorts() {
        return Collections.singleton(this.getMappedPort(POSTGRESQL_PORT));
    }

    @Override
    protected void configure() {
        this.withUrlParam("loggerLevel", "OFF");
        this.addEnv("POSTGRES_DB", this.databaseName);
        this.addEnv("POSTGRES_USER", this.username);
        this.addEnv("POSTGRES_PASSWORD", this.password);
    }

    @Override
    public String getDriverClassName() {
        return "org.postgresql.Driver";
    }

    @Override
    public String getJdbcUrl() {
        String additionalUrlParams = this.constructUrlParameters("?", QUERY_PARAM_SEPARATOR);
        return "jdbc:postgresql://" + this.getContainerIpAddress() + ":" + this.getMappedPort(POSTGRESQL_PORT) + "/" + this.databaseName + additionalUrlParams;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getTestQueryString() {
        return "SELECT 1";
    }

    @Override
    public SELF withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return (SELF)((PostgreSQLContainer)this.self());
    }

    @Override
    public SELF withUsername(String username) {
        this.username = username;
        return (SELF)((PostgreSQLContainer)this.self());
    }

    @Override
    public SELF withPassword(String password) {
        this.password = password;
        return (SELF)((PostgreSQLContainer)this.self());
    }

    @Override
    protected void waitUntilContainerStarted() {
        this.getWaitStrategy().waitUntilReady(this);
    }
}

