/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.okhttp;

import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.github.dockerjava.okhttp.HijackingInterceptor;
import org.testcontainers.shaded.com.github.dockerjava.okhttp.NamedPipeSocketFactory;
import org.testcontainers.shaded.com.github.dockerjava.okhttp.UnixSocketFactory;
import org.testcontainers.shaded.okhttp3.Call;
import org.testcontainers.shaded.okhttp3.ConnectionPool;
import org.testcontainers.shaded.okhttp3.Dns;
import org.testcontainers.shaded.okhttp3.HttpUrl;
import org.testcontainers.shaded.okhttp3.MediaType;
import org.testcontainers.shaded.okhttp3.OkHttpClient;
import org.testcontainers.shaded.okhttp3.Request;
import org.testcontainers.shaded.okhttp3.RequestBody;
import org.testcontainers.shaded.okhttp3.Response;
import org.testcontainers.shaded.okhttp3.ResponseBody;
import org.testcontainers.shaded.okio.BufferedSink;
import org.testcontainers.shaded.okio.Okio;

public final class OkDockerHttpClient
implements DockerHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(OkDockerHttpClient.class);
    private static final String SOCKET_SUFFIX = ".socket";
    final OkHttpClient client;
    final OkHttpClient streamingClient;
    private final HttpUrl baseUrl;

    private OkDockerHttpClient(URI dockerHost, SSLConfig sslConfig, Integer readTimeout, Integer connectTimeout, Boolean retryOnConnectionFailure) {
        HttpUrl.Builder baseUrlBuilder;
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().addNetworkInterceptor(new HijackingInterceptor()).readTimeout(0L, TimeUnit.MILLISECONDS).retryOnConnectionFailure(true);
        if (readTimeout != null) {
            clientBuilder.readTimeout(readTimeout.intValue(), TimeUnit.MILLISECONDS);
        }
        if (connectTimeout != null) {
            clientBuilder.connectTimeout(connectTimeout.intValue(), TimeUnit.MILLISECONDS);
        }
        if (retryOnConnectionFailure != null) {
            clientBuilder.retryOnConnectionFailure(retryOnConnectionFailure);
        }
        switch (dockerHost.getScheme()) {
            case "unix": 
            case "npipe": {
                String socketPath = dockerHost.getPath();
                if ("unix".equals(dockerHost.getScheme())) {
                    clientBuilder.socketFactory(new UnixSocketFactory(socketPath));
                } else {
                    clientBuilder.socketFactory(new NamedPipeSocketFactory(socketPath));
                }
                clientBuilder.connectionPool(new ConnectionPool(0, 1L, TimeUnit.SECONDS)).dns(hostname -> {
                    if (hostname.endsWith(SOCKET_SUFFIX)) {
                        return Collections.singletonList(InetAddress.getByAddress(hostname, new byte[]{0, 0, 0, 0}));
                    }
                    return Dns.SYSTEM.lookup(hostname);
                });
                break;
            }
        }
        boolean isSSL = false;
        if (sslConfig != null) {
            try {
                SSLContext sslContext = sslConfig.getSSLContext();
                if (sslContext != null) {
                    isSSL = true;
                    clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), new TrustAllX509TrustManager());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.client = clientBuilder.build();
        this.streamingClient = this.client.newBuilder().build();
        switch (dockerHost.getScheme()) {
            case "unix": 
            case "npipe": {
                baseUrlBuilder = new HttpUrl.Builder().scheme("http").host("docker.socket");
                break;
            }
            case "tcp": {
                baseUrlBuilder = new HttpUrl.Builder().scheme(isSSL ? "https" : "http").host(dockerHost.getHost()).port(dockerHost.getPort());
                break;
            }
            default: {
                baseUrlBuilder = HttpUrl.get(dockerHost.toString()).newBuilder();
            }
        }
        this.baseUrl = baseUrlBuilder.build();
    }

    private RequestBody toRequestBody(DockerHttpClient.Request request) {
        byte[] bodyBytes = request.bodyBytes();
        if (bodyBytes != null) {
            return RequestBody.create(null, bodyBytes);
        }
        final InputStream body = request.body();
        if (body != null) {
            return new RequestBody(){

                @Override
                public MediaType contentType() {
                    return null;
                }

                @Override
                public void writeTo(BufferedSink sink) throws IOException {
                    sink.writeAll(Okio.source(body));
                }
            };
        }
        switch (request.method()) {
            case "POST": {
                return RequestBody.create(null, "");
            }
        }
        return null;
    }

    @Override
    public DockerHttpClient.Response execute(DockerHttpClient.Request request) {
        String url = this.baseUrl.toString();
        if (url.endsWith("/") && request.path().startsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        Request.Builder requestBuilder = new Request.Builder().url(url + request.path()).tag(DockerHttpClient.Request.class, request).method(request.method(), this.toRequestBody(request));
        request.headers().forEach(requestBuilder::header);
        OkHttpClient clientToUse = request.hijackedInput() == null ? this.client : this.streamingClient;
        Call call = clientToUse.newCall(requestBuilder.build());
        try {
            return new OkResponse(call);
        }
        catch (IOException e) {
            call.cancel();
            throw new UncheckedIOException("Error while executing " + request, e);
        }
    }

    @Override
    public void close() throws IOException {
        for (OkHttpClient clientToClose : new OkHttpClient[]{this.client, this.streamingClient}) {
            clientToClose.dispatcher().cancelAll();
            clientToClose.dispatcher().executorService().shutdown();
            clientToClose.connectionPool().evictAll();
        }
    }

    static class TrustAllX509TrustManager
    implements X509TrustManager {
        TrustAllX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    static class OkResponse
    implements DockerHttpClient.Response {
        static final ThreadLocal<Boolean> CLOSING = ThreadLocal.withInitial(() -> false);
        private final Call call;
        private final Response response;

        OkResponse(Call call) throws IOException {
            this.call = call;
            this.response = call.execute();
        }

        @Override
        public int getStatusCode() {
            return this.response.code();
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            return this.response.headers().toMultimap();
        }

        @Override
        public InputStream getBody() {
            ResponseBody body = this.response.body();
            if (body == null) {
                return null;
            }
            return body.source().inputStream();
        }

        @Override
        public void close() {
            boolean previous = CLOSING.get();
            CLOSING.set(true);
            try {
                this.call.cancel();
                this.response.close();
            }
            catch (AssertionError | Exception e) {
                LOGGER.debug("Failed to close the response", (Throwable)e);
            }
            finally {
                CLOSING.set(previous);
            }
        }
    }

    public static final class Builder {
        private URI dockerHost = null;
        private SSLConfig sslConfig = null;
        private Integer readTimeout = null;
        private Integer connectTimeout = null;
        private Boolean retryOnConnectionFailure = null;

        public Builder dockerHost(URI value) {
            this.dockerHost = Objects.requireNonNull(value, "dockerHost");
            return this;
        }

        public Builder sslConfig(SSLConfig value) {
            this.sslConfig = value;
            return this;
        }

        public Builder readTimeout(Integer value) {
            this.readTimeout = value;
            return this;
        }

        public Builder connectTimeout(Integer value) {
            this.connectTimeout = value;
            return this;
        }

        Builder retryOnConnectionFailure(Boolean value) {
            this.retryOnConnectionFailure = value;
            return this;
        }

        public OkDockerHttpClient build() {
            Objects.requireNonNull(this.dockerHost, "dockerHost");
            return new OkDockerHttpClient(this.dockerHost, this.sslConfig, this.readTimeout, this.connectTimeout, this.retryOnConnectionFailure);
        }
    }
}

