/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol;

import com.impossibl.postgres.protocol.RowData;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.util.ArrayList;
import java.util.List;

public class RowDataSet
extends AbstractReferenceCounted {
    private List<RowData> rows;

    public RowDataSet() {
        this(0);
    }

    public RowDataSet(int capacity) {
        this.rows = new ArrayList<RowData>(capacity);
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public int size() {
        return this.rows.size();
    }

    public RowData borrow(int index) {
        return this.rows.get(index);
    }

    public void add(RowData row) {
        this.rows.add(row);
    }

    public RowData copy(int index) {
        return ReferenceCountUtil.retain(this.borrow(index));
    }

    public RowData take(int index) {
        return this.rows.remove(index);
    }

    public void remove(int index) {
        ReferenceCountUtil.release(this.rows.remove(index));
    }

    public List<RowData> borrowAll() {
        return this.rows;
    }

    @Override
    protected void deallocate() {
        this.rows.forEach(ReferenceCountUtil::release);
    }

    @Override
    public ReferenceCounted touch(Object hint) {
        this.rows.forEach(rowData -> ReferenceCountUtil.touch(rowData, hint));
        return this;
    }

    public String toString() {
        if (this.rows.size() == 0) {
            return "Empty";
        }
        return this.rows.size() + " Rows";
    }
}

