/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.procs.NumericBinaryDecoder;
import com.impossibl.postgres.system.procs.NumericBinaryEncoder;
import com.impossibl.postgres.system.procs.NumericTextDecoder;
import com.impossibl.postgres.system.procs.NumericTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.text.ParseException;

public class Int8s
extends SimpleProcProvider {
    public Int8s() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "int8");
    }

    private static Long convertStringInput(Context context, String value) throws ConversionException {
        try {
            return context.getClientIntegerFormatter().parse(value).longValue();
        }
        catch (ParseException e) {
            throw new ConversionException("Invalid Long", e);
        }
    }

    private static String convertStringOutput(Context context, Number number) {
        return context.getClientIntegerFormatter().format(number);
    }

    static class TxtEncoder
    extends NumericTextEncoder<Long> {
        TxtEncoder() {
            super((x$0, x$1) -> Int8s.convertStringInput(x$0, x$1), val -> val != false ? 1L : 0L, Number::longValue);
        }

        @Override
        public Class<Long> getDefaultClass() {
            return Long.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Long value, Object sourceContext, StringBuilder buffer) throws IOException {
            buffer.append(value);
        }
    }

    static class TxtDecoder
    extends NumericTextDecoder<Long> {
        TxtDecoder() {
            super((Context x$0, N x$1) -> Int8s.convertStringOutput(x$0, x$1));
        }

        @Override
        public Class<Long> getDefaultClass() {
            return Long.class;
        }

        @Override
        protected Long decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            return Long.valueOf(buffer.toString());
        }
    }

    static class BinEncoder
    extends NumericBinaryEncoder<Long> {
        BinEncoder() {
            super(8, (x$0, x$1) -> Int8s.convertStringInput(x$0, x$1), val -> val != false ? 1L : 0L, Number::longValue);
        }

        @Override
        public Class<Long> getDefaultClass() {
            return Long.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Long value, Object sourceContext, ByteBuf buffer) throws IOException {
            buffer.writeLong(value);
        }
    }

    static class BinDecoder
    extends NumericBinaryDecoder<Long> {
        BinDecoder() {
            super((Integer)8, (Context x$0, N x$1) -> Int8s.convertStringOutput(x$0, x$1));
        }

        @Override
        public Class<Long> getDefaultClass() {
            return Long.class;
        }

        @Override
        protected Long decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            return buffer.readLong();
        }
    }
}

