/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BaseBinaryDecoder;
import com.impossibl.postgres.system.procs.BaseBinaryEncoder;
import com.impossibl.postgres.system.procs.BaseTextDecoder;
import com.impossibl.postgres.system.procs.BaseTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.GeometryParsers;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class LSegs
extends SimpleProcProvider {
    public LSegs() {
        this("lseg_", new LSegFormatter());
    }

    LSegs(String pgtype, Formatter formatter) {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(formatter), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(formatter), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), pgtype);
    }

    private static class LSegFormatter
    implements Formatter {
        private LSegFormatter() {
        }

        @Override
        public String getLeftDelim() {
            return "[";
        }

        @Override
        public String getRightDelim() {
            return "]";
        }

        @Override
        public double[] parse(CharSequence buffer) {
            return GeometryParsers.INSTANCE.parseLSeg(buffer);
        }
    }

    static interface Formatter {
        public String getLeftDelim();

        public String getRightDelim();

        public double[] parse(CharSequence var1);
    }

    static class TxtEncoder
    extends BaseTextEncoder {
        private Formatter formatter;

        TxtEncoder(Formatter f) {
            this.formatter = f;
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, StringBuilder buffer) throws IOException {
            double[] lseg = (double[])value;
            if (lseg.length != 4) {
                throw new IOException("invalid length");
            }
            buffer.append(this.formatter.getLeftDelim()).append('(').append(lseg[0]).append(',').append(lseg[1]).append("),(").append(lseg[2]).append(',').append(lseg[3]).append(')').append(this.formatter.getRightDelim());
        }
    }

    static class TxtDecoder
    extends BaseTextDecoder {
        private Formatter formatter;

        TxtDecoder(Formatter f) {
            this.formatter = f;
        }

        @Override
        public Class<?> getDefaultClass() {
            return double[].class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException {
            return this.formatter.parse(buffer);
        }
    }

    static class BinEncoder
    extends BaseBinaryEncoder {
        BinEncoder() {
            super(32);
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, ByteBuf buffer) throws IOException {
            double[] box = (double[])value;
            if (box.length != 4) {
                throw new IOException("invalid length");
            }
            buffer.writeDouble(box[0]);
            buffer.writeDouble(box[1]);
            buffer.writeDouble(box[2]);
            buffer.writeDouble(box[3]);
        }
    }

    static class BinDecoder
    extends BaseBinaryDecoder {
        BinDecoder() {
            super(32);
        }

        @Override
        public Class<?> getDefaultClass() {
            return double[].class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            return new double[]{buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble()};
        }
    }
}

