/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.api.data.CidrAddr;
import com.impossibl.postgres.api.data.InetAddr;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.procs.BaseBinaryDecoder;
import com.impossibl.postgres.system.procs.BaseBinaryEncoder;
import com.impossibl.postgres.system.procs.BaseTextDecoder;
import com.impossibl.postgres.system.procs.BaseTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

abstract class Networks
extends SimpleProcProvider {
    private static final short PGSQL_AF_INET = 2;
    private static final short PGSQL_AF_INET6 = 3;

    private static InetAddr convertInput(Type type, Object value) throws ConversionException {
        if (value instanceof InetAddr) {
            return (InetAddr)value;
        }
        if (value instanceof String) {
            return InetAddr.parseInetAddr((String)value, true);
        }
        throw new ConversionException(value.getClass(), type);
    }

    private static Object convertOutput(Type type, InetAddr value, Kind kind, Class<?> targetClass) throws ConversionException {
        if (targetClass == InetAddr.class && kind == Kind.Inet) {
            return value;
        }
        if (targetClass == CidrAddr.class && kind == Kind.Cidr) {
            return value;
        }
        if (targetClass == String.class) {
            return value.toString();
        }
        throw new ConversionException(type, targetClass);
    }

    Networks(String pgtype, NetworkObjectFactory<? extends InetAddr> nof) {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(nof), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(nof), pgtype);
    }

    static enum Kind {
        Inet,
        Cidr;

    }

    static class TxtEncoder
    extends BaseTextEncoder {
        TxtEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, StringBuilder buffer) throws IOException {
            InetAddr inet = Networks.convertInput(type, value);
            buffer.append(inet.toString());
        }
    }

    static class TxtDecoder
    extends BaseTextDecoder {
        private NetworkObjectFactory<? extends InetAddr> nof;

        TxtDecoder(NetworkObjectFactory<? extends InetAddr> nof) {
            this.nof = nof;
        }

        @Override
        public Class<?> getDefaultClass() {
            return this.nof.getObjectType();
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException {
            InetAddr value = this.nof.newNetworkObject(buffer.toString());
            return Networks.convertOutput(type, value, this.nof.getKind(), targetClass);
        }
    }

    static interface NetworkObjectFactory<T extends InetAddr> {
        public T newNetworkObject(byte[] var1, short var2);

        public T newNetworkObject(String var1);

        public Kind getKind();

        public Class<T> getObjectType();
    }

    static class BinEncoder
    extends BaseBinaryEncoder {
        BinEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, ByteBuf buffer) throws IOException {
            InetAddr inet = Networks.convertInput(type, value);
            byte[] addr = inet.getAddress();
            boolean ipV4 = inet.getFamily() == InetAddr.Family.IPv4;
            buffer.writeByte(ipV4 ? 2 : 3);
            buffer.writeByte(inet.getMaskBits());
            buffer.writeByte(type.getName().equals("cidr") ? 0 : 1);
            buffer.writeByte(addr.length);
            buffer.writeBytes(addr);
        }
    }

    static class BinDecoder
    extends BaseBinaryDecoder {
        private NetworkObjectFactory<? extends InetAddr> nof;

        BinDecoder(NetworkObjectFactory<? extends InetAddr> nof) {
            this.nof = nof;
        }

        @Override
        public Class<?> getDefaultClass() {
            return this.nof.getObjectType();
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            int length = buffer.readableBytes();
            if (length != 8 && length != 20) {
                throw new IOException("Invalid length: " + length);
            }
            short family = buffer.readUnsignedByte();
            short mask = buffer.readUnsignedByte();
            buffer.readByte();
            short addrSize = buffer.readUnsignedByte();
            if (family == 2) {
                if (addrSize != 4) {
                    throw new IOException("Invalid inet4 size: " + addrSize);
                }
            } else if (family == 3) {
                if (addrSize != 16) {
                    throw new IOException("Invalid inet6 size: " + addrSize);
                }
            } else {
                throw new IOException("Invalid inet family: " + family);
            }
            byte[] addr = new byte[addrSize];
            buffer.readBytes(addr);
            InetAddr value = this.nof.newNetworkObject(addr, mask);
            return Networks.convertOutput(type, value, this.nof.getKind(), targetClass);
        }
    }
}

