/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.api.data.Range;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BaseBinaryDecoder;
import com.impossibl.postgres.system.procs.BaseBinaryEncoder;
import com.impossibl.postgres.system.procs.BaseTextDecoder;
import com.impossibl.postgres.system.procs.BaseTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.RangeType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.text.ParseException;

public class Ranges
extends SimpleProcProvider {
    public Ranges() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "range_");
    }

    static class TxtEncoder
    extends BaseTextEncoder {
        TxtEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, StringBuilder buffer) throws IOException {
            RangeType rangeType = (RangeType)type;
            Type baseType = rangeType.getBase();
            Range range = (Range)value;
            if (range.isLowerBoundInclusive()) {
                buffer.append('[');
            } else {
                buffer.append('(');
            }
            BaseTextEncoder encoder = (BaseTextEncoder)baseType.getTextCodec().getEncoder();
            if (range.hasLowerBound()) {
                StringBuilder lowerBuffer = new StringBuilder();
                encoder.encodeValue(context, baseType, range.getLowerBound(), sourceContext, lowerBuffer);
                String lower = lowerBuffer.toString();
                if (TxtEncoder.needsQuotes(lower)) {
                    buffer.append('\"').append(lower).append('\"');
                } else {
                    buffer.append(lower);
                }
            }
            buffer.append(',');
            if (range.hasUpperBound()) {
                StringBuilder upperBuffer = new StringBuilder();
                encoder.encodeValue(context, baseType, range.getUpperBound(), sourceContext, upperBuffer);
                String upper = upperBuffer.toString();
                if (TxtEncoder.needsQuotes(upper)) {
                    buffer.append('\"').append(upper).append('\"');
                } else {
                    buffer.append(upper);
                }
            }
            if (range.isUpperBoundInclusive()) {
                buffer.append(']');
            } else {
                buffer.append(')');
            }
        }

        private static boolean needsQuotes(String elemStr) {
            if (elemStr.isEmpty()) {
                return true;
            }
            if (elemStr.equalsIgnoreCase("NULL")) {
                return true;
            }
            for (int c = 0; c < elemStr.length(); ++c) {
                char ch = elemStr.charAt(c);
                if (ch != '\"' && ch != '\\' && ch != '{' && ch != '}' && ch != ' ' && ch != '\t' && ch != '\n' && ch != '\r' && ch != '\f') continue;
                return true;
            }
            return false;
        }
    }

    static class TxtDecoder
    extends BaseTextDecoder {
        TxtDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return Range.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            CharSequence upperTxt;
            RangeType rangeType = (RangeType)type;
            Type baseType = rangeType.getBase();
            boolean lowerInc = false;
            boolean upperInc = false;
            Object lower = null;
            Object upper = null;
            if (buffer.charAt(0) == '[') {
                lowerInc = true;
            }
            if (buffer.charAt(buffer.length() - 1) == ']') {
                upperInc = true;
            }
            Type.Codec.Decoder<CharSequence> decoder = baseType.getTextCodec().getDecoder();
            CharSequence lowerTxt = buffer.subSequence(1, TxtDecoder.findBound(buffer));
            if (lowerTxt.length() != 0) {
                lower = decoder.decode(context, baseType, null, null, lowerTxt, targetClass, targetContext);
            }
            if ((upperTxt = buffer.subSequence(2 + lowerTxt.length(), buffer.length() - 1)).length() != 0) {
                upper = decoder.decode(context, baseType, null, null, upperTxt, targetClass, targetContext);
            }
            return Range.create(lower, lowerInc, upper, upperInc);
        }

        private static int findBound(CharSequence buffer) {
            int stop;
            boolean string = false;
            block4: for (stop = 1; stop < buffer.length(); ++stop) {
                char ch = buffer.charAt(stop);
                switch (ch) {
                    case '\"': {
                        string = !string;
                        continue block4;
                    }
                    case '\\': {
                        ++stop;
                        continue block4;
                    }
                    default: {
                        if (ch != ',' || string) continue block4;
                        return stop;
                    }
                }
            }
            return stop;
        }
    }

    static class BinEncoder
    extends BaseBinaryEncoder {
        BinEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, ByteBuf buffer) throws IOException {
            RangeType rangeType = (RangeType)type;
            Type baseType = rangeType.getBase();
            Range range = (Range)value;
            buffer.writeByte(range.getFlags().getValue());
            Type.Codec.Encoder<ByteBuf> encoder = baseType.getBinaryCodec().getEncoder();
            if (range.getFlags().hasLowerBound()) {
                encoder.encode(context, baseType, range.getLowerBound(), sourceContext, buffer);
            }
            if (range.getFlags().hasUpperBound()) {
                encoder.encode(context, baseType, range.getUpperBound(), sourceContext, buffer);
            }
        }
    }

    static class BinDecoder
    extends BaseBinaryDecoder {
        BinDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return Range.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            RangeType rangeType = (RangeType)type;
            Type baseType = rangeType.getBase();
            Range.Flags flags = new Range.Flags(buffer.readByte());
            Object[] values = new Object[2];
            Type.Codec.Decoder<ByteBuf> decoder = baseType.getBinaryCodec().getDecoder();
            if (flags.hasLowerBound()) {
                values[0] = decoder.decode(context, baseType, null, null, buffer, targetClass, targetContext);
            }
            if (flags.hasUpperBound()) {
                values[1] = decoder.decode(context, baseType, null, null, buffer, targetClass, targetContext);
            }
            return new Range(flags, values);
        }
    }
}

