/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.utils;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.nio.charset.Charset;

public class ByteBufs {
    public static ByteBuf[] allocAll(ByteBufAllocator alloc, int count) {
        ByteBuf[] buffers = new ByteBuf[count];
        for (int c = 0; c < count; ++c) {
            buffers[c] = alloc.buffer();
        }
        return buffers;
    }

    public static ByteBuf[] duplicateAll(ByteBuf[] buffers) {
        buffers = (ByteBuf[])buffers.clone();
        for (int c = 0; c < buffers.length; ++c) {
            buffers[c] = buffers[c].duplicate();
        }
        return buffers;
    }

    public static ByteBuf[] retainedDuplicateAll(ByteBuf[] buffers) {
        buffers = (ByteBuf[])buffers.clone();
        for (int c = 0; c < buffers.length; ++c) {
            if (buffers[c] == null) continue;
            buffers[c] = buffers[c].retainedDuplicate();
        }
        return buffers;
    }

    public static void releaseAll(ByteBuf[] byteBufs) {
        for (int c = 0; c < byteBufs.length; ++c) {
            ReferenceCountUtil.release(byteBufs[c]);
            byteBufs[c] = null;
        }
    }

    public static ByteBuf[] encode(ByteBufAllocator alloc, CharSequence[] textBuffers) {
        ByteBuf[] binaryBuffers = new ByteBuf[textBuffers.length];
        for (int bufferIdx = 0; bufferIdx < textBuffers.length; ++bufferIdx) {
            binaryBuffers[bufferIdx] = ByteBufUtil.writeUtf8(alloc, textBuffers[bufferIdx]);
        }
        return binaryBuffers;
    }

    public static void lengthEncodeBinary(Type.Codec.Encoder<ByteBuf> encoder, Context context, Type type, Object value, Object sourceContext, ByteBuf buffer) throws IOException {
        ByteBufs.lengthEncode(buffer, value, () -> encoder.encode(context, type, value, sourceContext, buffer));
    }

    public static int lengthEncode(ByteBuf buffer, Object value, EncodeFunction encode) throws IOException {
        int lengthOff = buffer.writerIndex();
        buffer.writeInt(-1);
        if (value == null) {
            return lengthOff;
        }
        int dataOff = buffer.writerIndex();
        encode.encode();
        buffer.setInt(lengthOff, buffer.writerIndex() - dataOff);
        return lengthOff;
    }

    public static Object lengthDecodeBinary(Type.Codec.Decoder<ByteBuf> decoder, Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
        return ByteBufs.lengthDecode(buffer, data -> decoder.decode(context, type, typeLength, typeModifier, data, targetClass, targetContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object lengthDecode(ByteBuf buffer, DecodeFunction decode) throws IOException {
        int length = buffer.readInt();
        if (length == -1) {
            return null;
        }
        ByteBuf data = buffer.readRetainedSlice(length);
        try {
            Object object = decode.decode(data);
            return object;
        }
        finally {
            data.release();
        }
    }

    public static String readCString(ByteBuf buffer, Charset charset) {
        int strLen = buffer.bytesBefore((byte)0);
        byte[] bytes = new byte[strLen];
        buffer.readBytes(bytes);
        buffer.skipBytes(1);
        return new String(bytes, 0, bytes.length, charset);
    }

    public static void writeCString(ByteBuf buffer, String val, Charset charset) {
        ByteBufs.writeCString(buffer, val.getBytes(charset));
    }

    public static void writeCString(ByteBuf buffer, byte[] valBytes) {
        buffer.writeBytes(valBytes);
        buffer.writeByte(0);
    }

    public static interface EncodeFunction {
        public void encode() throws IOException;
    }

    public static interface DecodeFunction {
        public Object decode(ByteBuf var1) throws IOException;
    }
}

