/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pgevent;

import com.impossibl.postgres.api.jdbc.PGConnection;
import com.impossibl.postgres.jdbc.PGDriver;
import java.sql.DriverManager;
import javax.sql.DataSource;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.pgevent.PgEventComponent;
import org.apache.camel.component.pgevent.PgEventConstants;
import org.apache.camel.component.pgevent.PgEventConsumer;
import org.apache.camel.component.pgevent.PgEventHelper;
import org.apache.camel.component.pgevent.PgEventProducer;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.15.0", scheme="pgevent", title="PostgresSQL Event", syntax="pgevent:host:port/database/channel", category={Category.DATABASE, Category.SQL}, headersClass=PgEventConstants.class)
public class PgEventEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(PgEventEndpoint.class);
    private static final String FORMAT1 = "^pgevent://([^:]*):(\\d+)/(.+)/(\\w+).*$";
    private static final String FORMAT2 = "^pgevent://([^:]+)/(.+)/(\\w+).*$";
    private static final String FORMAT3 = "^pgevent:///(.+)/(\\w+).*$";
    private static final String FORMAT4 = "^pgevent:(.+)/(\\w+)/(\\w+).*$";
    @UriPath(defaultValue="localhost")
    private String host = "localhost";
    @UriPath(defaultValue="5432")
    private Integer port = 5432;
    @UriPath
    @Metadata(required=true)
    private String database;
    @UriPath
    @Metadata(required=true)
    private String channel;
    @UriParam(defaultValue="postgres", label="security", secret=true)
    private String user = "postgres";
    @UriParam(label="security", secret=true)
    private String pass;
    @UriParam
    private DataSource datasource;
    private final String uri;
    private PGConnection dbConnection;

    public PgEventEndpoint(String uri, PgEventComponent component) {
        super(uri, component);
        this.uri = uri;
        this.parseUri();
    }

    public PgEventEndpoint(String uri, PgEventComponent component, DataSource dataSource) {
        super(uri, component);
        this.uri = uri;
        this.datasource = dataSource;
        this.parseUri();
    }

    public final PGConnection initJdbc() throws Exception {
        PGConnection conn;
        if (this.getDatasource() != null) {
            conn = PgEventHelper.toPGConnection(this.getDatasource().getConnection());
        } else {
            ClassResolver classResolver = this.getCamelContext().getClassResolver();
            classResolver.resolveMandatoryClass(PGDriver.class.getName(), PgEventComponent.class.getClassLoader());
            conn = (PGConnection)DriverManager.getConnection("jdbc:pgsql://" + this.getHost() + ":" + this.getPort() + "/" + this.getDatabase(), this.getUser(), this.getPass());
        }
        return conn;
    }

    protected final void parseUri() throws IllegalArgumentException {
        LOG.debug("URI: {}", (Object)this.uri);
        if (this.uri.matches(FORMAT1)) {
            LOG.trace("FORMAT1");
            String[] parts = this.uri.replaceFirst(FORMAT1, "$1:$2:$3:$4").split(":");
            this.host = parts[0];
            this.port = Integer.parseInt(parts[1]);
            this.database = parts[2];
            this.channel = parts[3];
        } else if (this.uri.matches(FORMAT2)) {
            LOG.trace("FORMAT2");
            String[] parts = this.uri.replaceFirst(FORMAT2, "$1:$2:$3").split(":");
            this.host = parts[0];
            this.port = 5432;
            this.database = parts[1];
            this.channel = parts[2];
        } else if (this.uri.matches(FORMAT3)) {
            LOG.trace("FORMAT3");
            String[] parts = this.uri.replaceFirst(FORMAT3, "$1:$2").split(":");
            this.host = "localhost";
            this.port = 5432;
            this.database = parts[0];
            this.channel = parts[1];
        } else if (this.uri.matches(FORMAT4)) {
            LOG.trace("FORMAT4");
            String[] parts = this.uri.replaceFirst(FORMAT4, "$1:$2").split(":");
            this.database = parts[0];
            this.channel = parts[1];
        } else {
            throw new IllegalArgumentException("The provided URL does not match the acceptable patterns.");
        }
    }

    @Override
    public Producer createProducer() throws Exception {
        this.validateInputs();
        return new PgEventProducer(this);
    }

    private void validateInputs() throws IllegalArgumentException {
        if (this.getChannel() == null || this.getChannel().length() == 0) {
            throw new IllegalArgumentException("A required parameter was not set when creating this Endpoint (channel)");
        }
        if (this.datasource == null && this.user == null) {
            throw new IllegalArgumentException("A required parameter was not set when creating this Endpoint (pgUser or pgDataSource)");
        }
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        this.validateInputs();
        PgEventConsumer consumer = new PgEventConsumer(this, processor);
        this.configureConsumer(consumer);
        return consumer;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }
}

