/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.camel.component.platform.http.HttpEndpointModel;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(value="platform-http")
public class PlatformHttpConsole
extends AbstractDevConsole {
    public PlatformHttpConsole() {
        super("camel", "platform-http", "Platform HTTP", "Embedded HTTP Server");
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        PlatformHttpComponent http = this.getCamelContext().getComponent("platform-http", PlatformHttpComponent.class);
        if (http != null) {
            Object server = "http://0.0.0.0";
            int port = http.getEngine().getServerPort();
            if (port > 0) {
                server = (String)server + ":" + port;
            }
            Set<HttpEndpointModel> models = http.getHttpEndpoints();
            for (HttpEndpointModel model : models) {
                if (model.getVerbs() != null) {
                    sb.append(String.format("    %s%s (%s)\n", server, model.getUri(), model.getVerbs()));
                    continue;
                }
                sb.append(String.format("    %s%s\n", server, model.getUri()));
            }
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        PlatformHttpComponent http = this.getCamelContext().getComponent("platform-http", PlatformHttpComponent.class);
        if (http != null) {
            Object server = "http://0.0.0.0";
            int port = http.getEngine().getServerPort();
            if (port > 0) {
                server = (String)server + ":" + port;
            }
            root.put("server", server);
            Set<HttpEndpointModel> models = http.getHttpEndpoints();
            ArrayList<JsonObject> list = new ArrayList<JsonObject>();
            for (HttpEndpointModel model : models) {
                JsonObject jo = new JsonObject();
                Object uri = model.getUri();
                if (!((String)uri).startsWith("/")) {
                    uri = "/" + (String)uri;
                }
                jo.put("url", (String)server + (String)uri);
                jo.put("path", model.getUri());
                if (model.getVerbs() != null) {
                    jo.put("verbs", model.getVerbs());
                }
                list.add(jo);
            }
            if (!list.isEmpty()) {
                root.put("endpoints", list);
            }
        }
        return root;
    }
}

