/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.access;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.endpoints.access.AccessManagerService;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.access_manager.PNAccessManagerAuditResult;
import com.pubnub.api.models.server.Envelope;
import com.pubnub.api.models.server.access_manager.AccessManagerAuditPayload;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public class Audit
extends Endpoint<Envelope<AccessManagerAuditPayload>, PNAccessManagerAuditResult> {
    private List<String> authKeys = new ArrayList<String>();
    private String channel;
    private String channelGroup;

    public Audit(PubNub pubnub, Retrofit retrofit) {
        super(pubnub, retrofit);
    }

    @Override
    protected List<String> getAffectedChannels() {
        return Collections.singletonList(this.channel);
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return Collections.singletonList(this.channelGroup);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.authKeys.size() == 0) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_AUTH_KEYS_MISSING).build();
        }
        if (this.getPubnub().getConfiguration().getSecretKey() == null || this.getPubnub().getConfiguration().getSecretKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SECRET_KEY_MISSING).build();
        }
        if (this.getPubnub().getConfiguration().getSubscribeKey() == null || this.getPubnub().getConfiguration().getSubscribeKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SUBSCRIBE_KEY_MISSING).build();
        }
        if (this.getPubnub().getConfiguration().getPublishKey() == null || this.getPubnub().getConfiguration().getPublishKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PUBLISH_KEY_MISSING).build();
        }
        if (this.channel == null && this.channelGroup == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNEL_AND_GROUP_MISSING).build();
        }
    }

    @Override
    protected Call<Envelope<AccessManagerAuditPayload>> doWork(Map<String, String> queryParams) throws PubNubException {
        if (this.channel != null) {
            queryParams.put("channel", this.channel);
        }
        if (this.channelGroup != null) {
            queryParams.put("channel-group", this.channelGroup);
        }
        if (this.authKeys.size() > 0) {
            queryParams.put("auth", PubNubUtil.joinString(this.authKeys, ","));
        }
        AccessManagerService service = this.getRetrofit().create(AccessManagerService.class);
        return service.audit(this.getPubnub().getConfiguration().getSubscribeKey(), queryParams);
    }

    @Override
    protected PNAccessManagerAuditResult createResponse(Response<Envelope<AccessManagerAuditPayload>> input) throws PubNubException {
        PNAccessManagerAuditResult.PNAccessManagerAuditResultBuilder pnAccessManagerAuditResult = PNAccessManagerAuditResult.builder();
        if (input.body() == null || input.body().getPayload() == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PARSING_ERROR).build();
        }
        AccessManagerAuditPayload auditPayload = input.body().getPayload();
        pnAccessManagerAuditResult.authKeys(auditPayload.getAuthKeys()).channel(auditPayload.getChannel()).channelGroup(auditPayload.getChannelGroup()).level(auditPayload.getLevel()).subscribeKey(auditPayload.getSubscribeKey());
        return pnAccessManagerAuditResult.build();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNAccessManagerAudit;
    }

    @Override
    protected boolean isAuthRequired() {
        return false;
    }

    public Audit authKeys(List<String> authKeys) {
        this.authKeys = authKeys;
        return this;
    }

    public Audit channel(String channel) {
        this.channel = channel;
        return this;
    }

    public Audit channelGroup(String channelGroup) {
        this.channelGroup = channelGroup;
        return this;
    }
}

