/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.presence;

import com.google.gson.JsonElement;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.endpoints.presence.PresenceService;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.models.consumer.presence.PNGetStateResult;
import com.pubnub.api.models.server.Envelope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public class GetState
extends Endpoint<Envelope<JsonElement>, PNGetStateResult> {
    private List<String> channels = new ArrayList<String>();
    private List<String> channelGroups = new ArrayList<String>();
    private String uuid;

    public GetState(PubNub pubnub, Retrofit retrofit) {
        super(pubnub, retrofit);
    }

    @Override
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return this.channelGroups;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.getPubnub().getConfiguration().getSubscribeKey() == null || this.getPubnub().getConfiguration().getSubscribeKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SUBSCRIBE_KEY_MISSING).build();
        }
        if (this.channels.size() == 0 && this.channelGroups.size() == 0) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNEL_AND_GROUP_MISSING).build();
        }
    }

    @Override
    protected Call<Envelope<JsonElement>> doWork(Map<String, String> params) {
        PresenceService service = this.getRetrofit().create(PresenceService.class);
        if (this.channelGroups.size() > 0) {
            params.put("channel-group", PubNubUtil.joinString(this.channelGroups, ","));
        }
        String channelCSV = this.channels.size() > 0 ? PubNubUtil.joinString(this.channels, ",") : ",";
        String selectedUUID = this.uuid != null ? this.uuid : this.getPubnub().getConfiguration().getUuid();
        return service.getState(this.getPubnub().getConfiguration().getSubscribeKey(), channelCSV, selectedUUID, params);
    }

    @Override
    protected PNGetStateResult createResponse(Response<Envelope<JsonElement>> input) throws PubNubException {
        HashMap<String, JsonElement> stateMappings = new HashMap<String, JsonElement>();
        MapperManager mapper = this.getPubnub().getMapper();
        if (this.channels.size() == 1 && this.channelGroups.size() == 0) {
            stateMappings.put(this.channels.get(0), input.body().getPayload());
        } else {
            Iterator<Map.Entry<String, JsonElement>> it = mapper.getObjectIterator(input.body().getPayload());
            while (it.hasNext()) {
                Map.Entry<String, JsonElement> stateMapping = it.next();
                stateMappings.put(stateMapping.getKey(), stateMapping.getValue());
            }
        }
        return PNGetStateResult.builder().stateByUUID(stateMappings).build();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNGetState;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    public GetState channels(List<String> channels) {
        this.channels = channels;
        return this;
    }

    public GetState channelGroups(List<String> channelGroups) {
        this.channelGroups = channelGroups;
        return this;
    }

    public GetState uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }
}

