/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.presence;

import com.google.gson.JsonElement;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.builder.dto.StateOperation;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.endpoints.presence.PresenceService;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.SubscriptionManager;
import com.pubnub.api.models.consumer.presence.PNSetStateResult;
import com.pubnub.api.models.server.Envelope;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public class SetState
extends Endpoint<Envelope<JsonElement>, PNSetStateResult> {
    private SubscriptionManager subscriptionManager;
    private List<String> channels;
    private List<String> channelGroups;
    private Object state;
    private String uuid;

    public SetState(PubNub pubnub, SubscriptionManager subscriptionManagerInstance, Retrofit retrofit) {
        super(pubnub, retrofit);
        this.subscriptionManager = subscriptionManagerInstance;
        this.channels = new ArrayList<String>();
        this.channelGroups = new ArrayList<String>();
    }

    @Override
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return this.channelGroups;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.state == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_STATE_MISSING).build();
        }
        if (this.getPubnub().getConfiguration().getSubscribeKey() == null || this.getPubnub().getConfiguration().getSubscribeKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SUBSCRIBE_KEY_MISSING).build();
        }
        if (this.channels.size() == 0 && this.channelGroups.size() == 0) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNEL_AND_GROUP_MISSING).build();
        }
    }

    @Override
    protected Call<Envelope<JsonElement>> doWork(Map<String, String> params) throws PubNubException {
        String selectedUUID;
        String string = selectedUUID = this.uuid != null ? this.uuid : this.getPubnub().getConfiguration().getUuid();
        if (selectedUUID.equals(this.getPubnub().getConfiguration().getUuid())) {
            StateOperation stateOperation = StateOperation.builder().state(this.state).channels(this.channels).channelGroups(this.channelGroups).build();
            this.subscriptionManager.adaptStateBuilder(stateOperation);
        }
        PresenceService service = this.getRetrofit().create(PresenceService.class);
        if (this.channelGroups.size() > 0) {
            params.put("channel-group", PubNubUtil.joinString(this.channelGroups, ","));
        }
        String stringifiedState = this.getPubnub().getMapper().toJson(this.state);
        stringifiedState = PubNubUtil.urlEncode(stringifiedState);
        params.put("state", stringifiedState);
        String channelCSV = this.channels.size() > 0 ? PubNubUtil.joinString(this.channels, ",") : ",";
        return service.setState(this.getPubnub().getConfiguration().getSubscribeKey(), channelCSV, selectedUUID, params);
    }

    @Override
    protected PNSetStateResult createResponse(Response<Envelope<JsonElement>> input) throws PubNubException {
        if (input.body() == null || input.body().getPayload() == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PARSING_ERROR).build();
        }
        PNSetStateResult.PNSetStateResultBuilder pnSetStateResult = PNSetStateResult.builder().state(input.body().getPayload());
        return pnSetStateResult.build();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNSetStateOperation;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    public SetState channels(List<String> channels) {
        this.channels = channels;
        return this;
    }

    public SetState channelGroups(List<String> channelGroups) {
        this.channelGroups = channelGroups;
        return this;
    }

    public SetState state(Object state) {
        this.state = state;
        return this;
    }

    public SetState uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }
}

