/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.PubNub;
import com.pubnub.api.callbacks.SubscribeCallback;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import java.util.ArrayList;
import java.util.List;

public class ListenerManager {
    private List<SubscribeCallback> listeners = new ArrayList<SubscribeCallback>();
    private PubNub pubnub;

    public ListenerManager(PubNub pubnubInstance) {
        this.pubnub = pubnubInstance;
    }

    public void addListener(SubscribeCallback listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SubscribeCallback listener) {
        this.listeners.remove(listener);
    }

    public void announce(PNStatus status) {
        for (SubscribeCallback subscribeCallback : this.listeners) {
            subscribeCallback.status(this.pubnub, status);
        }
    }

    public void announce(PNMessageResult message) {
        for (SubscribeCallback subscribeCallback : this.listeners) {
            subscribeCallback.message(this.pubnub, message);
        }
    }

    public void announce(PNPresenceEventResult presence) {
        for (SubscribeCallback subscribeCallback : this.listeners) {
            subscribeCallback.presence(this.pubnub, presence);
        }
    }
}

