/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.PubNub;
import com.pubnub.api.builder.dto.StateOperation;
import com.pubnub.api.builder.dto.SubscribeOperation;
import com.pubnub.api.builder.dto.UnsubscribeOperation;
import com.pubnub.api.callbacks.PNCallback;
import com.pubnub.api.callbacks.ReconnectionCallback;
import com.pubnub.api.callbacks.SubscribeCallback;
import com.pubnub.api.endpoints.presence.Heartbeat;
import com.pubnub.api.endpoints.presence.Leave;
import com.pubnub.api.endpoints.pubsub.Subscribe;
import com.pubnub.api.enums.PNHeartbeatNotificationOptions;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.managers.ListenerManager;
import com.pubnub.api.managers.ReconnectionManager;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.StateManager;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.server.SubscribeEnvelope;
import com.pubnub.api.models.server.SubscribeMessage;
import com.pubnub.api.workers.SubscribeMessageWorker;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionManager {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionManager.class);
    private static final int HEARTBEAT_INTERVAL_MULTIPLIER = 1000;
    private PubNub pubnub;
    private Subscribe subscribeCall;
    private Heartbeat heartbeatCall;
    private LinkedBlockingQueue<SubscribeMessage> messageQueue;
    private Long timetoken;
    private Long storedTimetoken;
    private String region;
    private Timer timer;
    private StateManager subscriptionState;
    private ListenerManager listenerManager;
    private ReconnectionManager reconnectionManager;
    private RetrofitManager retrofitManager;
    private Thread consumerThread;
    private boolean subscriptionStatusAnnounced;

    public SubscriptionManager(PubNub pubnubInstance, RetrofitManager retrofitManagerInstance) {
        this.pubnub = pubnubInstance;
        this.subscriptionStatusAnnounced = false;
        this.messageQueue = new LinkedBlockingQueue();
        this.subscriptionState = new StateManager();
        this.listenerManager = new ListenerManager(this.pubnub);
        this.reconnectionManager = new ReconnectionManager(this.pubnub);
        this.retrofitManager = retrofitManagerInstance;
        this.timetoken = 0L;
        this.storedTimetoken = null;
        this.reconnectionManager.setReconnectionListener(new ReconnectionCallback(){

            @Override
            public void onReconnection() {
                SubscriptionManager.this.reconnect();
                PNStatus pnStatus = PNStatus.builder().error(false).affectedChannels(SubscriptionManager.this.subscriptionState.prepareChannelList(true)).affectedChannelGroups(SubscriptionManager.this.subscriptionState.prepareChannelGroupList(true)).category(PNStatusCategory.PNReconnectedCategory).build();
                SubscriptionManager.this.subscriptionStatusAnnounced = true;
                SubscriptionManager.this.listenerManager.announce(pnStatus);
            }

            @Override
            public void onMaxReconnectionExhaustion() {
                PNStatus pnStatus = PNStatus.builder().error(false).category(PNStatusCategory.PNReconnectionAttemptsExhausted).affectedChannels(SubscriptionManager.this.subscriptionState.prepareChannelList(true)).affectedChannelGroups(SubscriptionManager.this.subscriptionState.prepareChannelGroupList(true)).build();
                SubscriptionManager.this.listenerManager.announce(pnStatus);
                SubscriptionManager.this.disconnect();
            }
        });
        if (this.pubnub.getConfiguration().isStartSubscriberThread()) {
            this.consumerThread = new Thread(new SubscribeMessageWorker(this.pubnub, this.listenerManager, this.messageQueue));
            this.consumerThread.start();
        }
    }

    public void addListener(SubscribeCallback listener) {
        this.listenerManager.addListener(listener);
    }

    public void removeListener(SubscribeCallback listener) {
        this.listenerManager.removeListener(listener);
    }

    public synchronized void reconnect() {
        this.startSubscribeLoop();
        this.registerHeartbeatTimer();
    }

    public synchronized void disconnect() {
        this.stopHeartbeatTimer();
        this.stopSubscribeLoop();
    }

    @Deprecated
    public synchronized void stop() {
        this.disconnect();
        this.consumerThread.interrupt();
    }

    public synchronized void destroy() {
        this.disconnect();
        this.consumerThread.interrupt();
    }

    public synchronized void adaptStateBuilder(StateOperation stateOperation) {
        this.subscriptionState.adaptStateBuilder(stateOperation);
        this.reconnect();
    }

    public synchronized void adaptSubscribeBuilder(SubscribeOperation subscribeOperation) {
        this.subscriptionState.adaptSubscribeBuilder(subscribeOperation);
        this.subscriptionStatusAnnounced = false;
        if (subscribeOperation.getTimetoken() != null) {
            this.timetoken = subscribeOperation.getTimetoken();
        }
        if (this.timetoken != 0L) {
            this.storedTimetoken = this.timetoken;
        }
        this.timetoken = 0L;
        this.reconnect();
    }

    public synchronized void adaptUnsubscribeBuilder(UnsubscribeOperation unsubscribeOperation) {
        this.subscriptionState.adaptUnsubscribeBuilder(unsubscribeOperation);
        this.subscriptionStatusAnnounced = false;
        new Leave(this.pubnub, this.retrofitManager.getTransactionInstance()).channels(unsubscribeOperation.getChannels()).channelGroups(unsubscribeOperation.getChannelGroups()).async(new PNCallback<Boolean>(){

            @Override
            public void onResponse(Boolean result, PNStatus status) {
                SubscriptionManager.this.listenerManager.announce(status);
            }
        });
        if (this.subscriptionState.isEmpty()) {
            this.region = null;
            this.storedTimetoken = null;
            this.timetoken = 0L;
        } else {
            this.storedTimetoken = this.timetoken;
            this.timetoken = 0L;
        }
        this.reconnect();
    }

    private void registerHeartbeatTimer() {
        this.stopHeartbeatTimer();
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                SubscriptionManager.this.performHeartbeatLoop();
            }
        }, 0L, (long)(this.pubnub.getConfiguration().getHeartbeatInterval() * 1000));
    }

    private void stopHeartbeatTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private void startSubscribeLoop() {
        this.stopSubscribeLoop();
        List<String> combinedChannels = this.subscriptionState.prepareChannelList(true);
        List<String> combinedChannelGroups = this.subscriptionState.prepareChannelGroupList(true);
        if (combinedChannels.isEmpty() && combinedChannelGroups.isEmpty()) {
            return;
        }
        this.subscribeCall = new Subscribe(this.pubnub, this.retrofitManager.getSubscriptionInstance()).channels(combinedChannels).channelGroups(combinedChannelGroups).timetoken(this.timetoken).region(this.region).filterExpression(this.pubnub.getConfiguration().getFilterExpression());
        this.subscribeCall.async(new PNCallback<SubscribeEnvelope>(){

            @Override
            public void onResponse(SubscribeEnvelope result, PNStatus status) {
                Integer requestMessageCountThreshold;
                if (status.isError()) {
                    if (status.getCategory() == PNStatusCategory.PNTimeoutCategory) {
                        SubscriptionManager.this.startSubscribeLoop();
                    } else {
                        SubscriptionManager.this.disconnect();
                        SubscriptionManager.this.listenerManager.announce(status);
                        SubscriptionManager.this.reconnectionManager.startPolling();
                    }
                    return;
                }
                if (!SubscriptionManager.this.subscriptionStatusAnnounced) {
                    PNStatus pnStatus = SubscriptionManager.this.createPublicStatus(status).category(PNStatusCategory.PNConnectedCategory).error(false).build();
                    SubscriptionManager.this.subscriptionStatusAnnounced = true;
                    SubscriptionManager.this.listenerManager.announce(pnStatus);
                }
                if ((requestMessageCountThreshold = SubscriptionManager.this.pubnub.getConfiguration().getRequestMessageCountThreshold()) != null && requestMessageCountThreshold.intValue() == result.getMessages().size()) {
                    PNStatus pnStatus = SubscriptionManager.this.createPublicStatus(status).category(PNStatusCategory.PNRequestMessageCountExceededCategory).error(false).build();
                    SubscriptionManager.this.listenerManager.announce(pnStatus);
                }
                if (result.getMessages().size() != 0) {
                    SubscriptionManager.this.messageQueue.addAll(result.getMessages());
                }
                if (SubscriptionManager.this.storedTimetoken != null) {
                    SubscriptionManager.this.timetoken = SubscriptionManager.this.storedTimetoken;
                    SubscriptionManager.this.storedTimetoken = null;
                } else {
                    SubscriptionManager.this.timetoken = result.getMetadata().getTimetoken();
                }
                SubscriptionManager.this.region = result.getMetadata().getRegion();
                SubscriptionManager.this.startSubscribeLoop();
            }
        });
    }

    private void stopSubscribeLoop() {
        if (this.subscribeCall != null) {
            this.subscribeCall.silentCancel();
            this.subscribeCall = null;
        }
    }

    private void performHeartbeatLoop() {
        if (this.heartbeatCall != null) {
            this.heartbeatCall.silentCancel();
            this.heartbeatCall = null;
        }
        List<String> presenceChannels = this.subscriptionState.prepareChannelList(false);
        List<String> presenceChannelGroups = this.subscriptionState.prepareChannelGroupList(false);
        Map<String, Object> stateStorage = this.subscriptionState.createStatePayload();
        if (presenceChannels.isEmpty() && presenceChannelGroups.isEmpty()) {
            return;
        }
        this.heartbeatCall = new Heartbeat(this.pubnub, this.retrofitManager.getTransactionInstance()).channels(presenceChannels).channelGroups(presenceChannelGroups).state(stateStorage);
        this.heartbeatCall.async(new PNCallback<Boolean>(){

            @Override
            public void onResponse(Boolean result, PNStatus status) {
                PNHeartbeatNotificationOptions heartbeatVerbosity = SubscriptionManager.this.pubnub.getConfiguration().getHeartbeatNotificationOptions();
                if (status.isError()) {
                    if (heartbeatVerbosity == PNHeartbeatNotificationOptions.ALL || heartbeatVerbosity == PNHeartbeatNotificationOptions.FAILURES) {
                        SubscriptionManager.this.listenerManager.announce(status);
                    }
                } else if (heartbeatVerbosity == PNHeartbeatNotificationOptions.ALL) {
                    SubscriptionManager.this.listenerManager.announce(status);
                }
            }
        });
    }

    public synchronized List<String> getSubscribedChannels() {
        return this.subscriptionState.prepareChannelList(false);
    }

    public synchronized List<String> getSubscribedChannelGroups() {
        return this.subscriptionState.prepareChannelGroupList(false);
    }

    public synchronized void unsubscribeAll() {
        this.adaptUnsubscribeBuilder(UnsubscribeOperation.builder().channelGroups(this.subscriptionState.prepareChannelGroupList(false)).channels(this.subscriptionState.prepareChannelList(false)).build());
    }

    private PNStatus.PNStatusBuilder createPublicStatus(PNStatus privateStatus) {
        return PNStatus.builder().statusCode(privateStatus.getStatusCode()).authKey(privateStatus.getAuthKey()).operation(privateStatus.getOperation()).affectedChannels(privateStatus.getAffectedChannels()).affectedChannelGroups(privateStatus.getAffectedChannelGroups()).clientRequest(privateStatus.getClientRequest()).origin(privateStatus.getOrigin()).tlsEnabled(privateStatus.isTlsEnabled());
    }
}

