/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar;

import org.apache.camel.CamelContext;
import org.apache.camel.component.pulsar.PulsarComponent;
import org.apache.camel.component.pulsar.PulsarConfiguration;
import org.apache.camel.component.pulsar.PulsarMessageReceiptFactory;
import org.apache.camel.component.pulsar.utils.AutoConfiguration;
import org.apache.camel.component.pulsar.utils.consumers.SubscriptionInitialPosition;
import org.apache.camel.component.pulsar.utils.consumers.SubscriptionType;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.RedeliveryBackoff;
import org.apache.pulsar.client.api.RegexSubscriptionMode;

public class PulsarComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private PulsarConfiguration getOrCreateConfiguration(PulsarComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new PulsarConfiguration());
        }
        return target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        PulsarComponent target = (PulsarComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "ackgrouptimemillis": 
            case "ackGroupTimeMillis": {
                this.getOrCreateConfiguration(target).setAckGroupTimeMillis(PulsarComponentConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "acktimeoutmillis": 
            case "ackTimeoutMillis": {
                this.getOrCreateConfiguration(target).setAckTimeoutMillis(PulsarComponentConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "acktimeoutredeliverybackoff": 
            case "ackTimeoutRedeliveryBackoff": {
                this.getOrCreateConfiguration(target).setAckTimeoutRedeliveryBackoff(PulsarComponentConfigurer.property(camelContext, RedeliveryBackoff.class, value));
                return true;
            }
            case "allowmanualacknowledgement": 
            case "allowManualAcknowledgement": {
                this.getOrCreateConfiguration(target).setAllowManualAcknowledgement(PulsarComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "authenticationclass": 
            case "authenticationClass": {
                this.getOrCreateConfiguration(target).setAuthenticationClass(PulsarComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "authenticationparams": 
            case "authenticationParams": {
                this.getOrCreateConfiguration(target).setAuthenticationParams(PulsarComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "autoconfiguration": 
            case "autoConfiguration": {
                target.setAutoConfiguration(PulsarComponentConfigurer.property(camelContext, AutoConfiguration.class, value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(PulsarComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "batcherbuilder": 
            case "batcherBuilder": {
                this.getOrCreateConfiguration(target).setBatcherBuilder(PulsarComponentConfigurer.property(camelContext, BatcherBuilder.class, value));
                return true;
            }
            case "batchingenabled": 
            case "batchingEnabled": {
                this.getOrCreateConfiguration(target).setBatchingEnabled(PulsarComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "batchingmaxmessages": 
            case "batchingMaxMessages": {
                this.getOrCreateConfiguration(target).setBatchingMaxMessages(PulsarComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "batchingmaxpublishdelaymicros": 
            case "batchingMaxPublishDelayMicros": {
                this.getOrCreateConfiguration(target).setBatchingMaxPublishDelayMicros(PulsarComponentConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "blockifqueuefull": 
            case "blockIfQueueFull": {
                this.getOrCreateConfiguration(target).setBlockIfQueueFull(PulsarComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(PulsarComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "compressiontype": 
            case "compressionType": {
                this.getOrCreateConfiguration(target).setCompressionType(PulsarComponentConfigurer.property(camelContext, CompressionType.class, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(PulsarComponentConfigurer.property(camelContext, PulsarConfiguration.class, value));
                return true;
            }
            case "consumername": 
            case "consumerName": {
                this.getOrCreateConfiguration(target).setConsumerName(PulsarComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "consumernameprefix": 
            case "consumerNamePrefix": {
                this.getOrCreateConfiguration(target).setConsumerNamePrefix(PulsarComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "consumerqueuesize": 
            case "consumerQueueSize": {
                this.getOrCreateConfiguration(target).setConsumerQueueSize(PulsarComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "deadlettertopic": 
            case "deadLetterTopic": {
                this.getOrCreateConfiguration(target).setDeadLetterTopic(PulsarComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "initialsequenceid": 
            case "initialSequenceId": {
                this.getOrCreateConfiguration(target).setInitialSequenceId(PulsarComponentConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(PulsarComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "maxpendingmessages": 
            case "maxPendingMessages": {
                this.getOrCreateConfiguration(target).setMaxPendingMessages(PulsarComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "maxpendingmessagesacrosspartitions": 
            case "maxPendingMessagesAcrossPartitions": {
                this.getOrCreateConfiguration(target).setMaxPendingMessagesAcrossPartitions(PulsarComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "maxredelivercount": 
            case "maxRedeliverCount": {
                this.getOrCreateConfiguration(target).setMaxRedeliverCount(PulsarComponentConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "messagelistener": 
            case "messageListener": {
                this.getOrCreateConfiguration(target).setMessageListener(PulsarComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "messagerouter": 
            case "messageRouter": {
                this.getOrCreateConfiguration(target).setMessageRouter(PulsarComponentConfigurer.property(camelContext, MessageRouter.class, value));
                return true;
            }
            case "messageroutingmode": 
            case "messageRoutingMode": {
                this.getOrCreateConfiguration(target).setMessageRoutingMode(PulsarComponentConfigurer.property(camelContext, MessageRoutingMode.class, value));
                return true;
            }
            case "negativeackredeliverybackoff": 
            case "negativeAckRedeliveryBackoff": {
                this.getOrCreateConfiguration(target).setNegativeAckRedeliveryBackoff(PulsarComponentConfigurer.property(camelContext, RedeliveryBackoff.class, value));
                return true;
            }
            case "negativeackredeliverydelaymicros": 
            case "negativeAckRedeliveryDelayMicros": {
                this.getOrCreateConfiguration(target).setNegativeAckRedeliveryDelayMicros(PulsarComponentConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "numberofconsumerthreads": 
            case "numberOfConsumerThreads": {
                this.getOrCreateConfiguration(target).setNumberOfConsumerThreads(PulsarComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "numberofconsumers": 
            case "numberOfConsumers": {
                this.getOrCreateConfiguration(target).setNumberOfConsumers(PulsarComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "producername": 
            case "producerName": {
                this.getOrCreateConfiguration(target).setProducerName(PulsarComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "pulsarclient": 
            case "pulsarClient": {
                target.setPulsarClient(PulsarComponentConfigurer.property(camelContext, PulsarClient.class, value));
                return true;
            }
            case "pulsarmessagereceiptfactory": 
            case "pulsarMessageReceiptFactory": {
                target.setPulsarMessageReceiptFactory(PulsarComponentConfigurer.property(camelContext, PulsarMessageReceiptFactory.class, value));
                return true;
            }
            case "readcompacted": 
            case "readCompacted": {
                this.getOrCreateConfiguration(target).setReadCompacted(PulsarComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "sendtimeoutms": 
            case "sendTimeoutMs": {
                this.getOrCreateConfiguration(target).setSendTimeoutMs(PulsarComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "serviceurl": 
            case "serviceUrl": {
                this.getOrCreateConfiguration(target).setServiceUrl(PulsarComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "subscriptioninitialposition": 
            case "subscriptionInitialPosition": {
                this.getOrCreateConfiguration(target).setSubscriptionInitialPosition(PulsarComponentConfigurer.property(camelContext, SubscriptionInitialPosition.class, value));
                return true;
            }
            case "subscriptionname": 
            case "subscriptionName": {
                this.getOrCreateConfiguration(target).setSubscriptionName(PulsarComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "subscriptiontopicsmode": 
            case "subscriptionTopicsMode": {
                this.getOrCreateConfiguration(target).setSubscriptionTopicsMode(PulsarComponentConfigurer.property(camelContext, RegexSubscriptionMode.class, value));
                return true;
            }
            case "subscriptiontype": 
            case "subscriptionType": {
                this.getOrCreateConfiguration(target).setSubscriptionType(PulsarComponentConfigurer.property(camelContext, SubscriptionType.class, value));
                return true;
            }
            case "topicspattern": 
            case "topicsPattern": {
                this.getOrCreateConfiguration(target).setTopicsPattern(PulsarComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] getAutowiredNames() {
        return new String[]{"pulsarClient"};
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "ackgrouptimemillis": 
            case "ackGroupTimeMillis": {
                return Long.TYPE;
            }
            case "acktimeoutmillis": 
            case "ackTimeoutMillis": {
                return Long.TYPE;
            }
            case "acktimeoutredeliverybackoff": 
            case "ackTimeoutRedeliveryBackoff": {
                return RedeliveryBackoff.class;
            }
            case "allowmanualacknowledgement": 
            case "allowManualAcknowledgement": {
                return Boolean.TYPE;
            }
            case "authenticationclass": 
            case "authenticationClass": {
                return String.class;
            }
            case "authenticationparams": 
            case "authenticationParams": {
                return String.class;
            }
            case "autoconfiguration": 
            case "autoConfiguration": {
                return AutoConfiguration.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "batcherbuilder": 
            case "batcherBuilder": {
                return BatcherBuilder.class;
            }
            case "batchingenabled": 
            case "batchingEnabled": {
                return Boolean.TYPE;
            }
            case "batchingmaxmessages": 
            case "batchingMaxMessages": {
                return Integer.TYPE;
            }
            case "batchingmaxpublishdelaymicros": 
            case "batchingMaxPublishDelayMicros": {
                return Long.TYPE;
            }
            case "blockifqueuefull": 
            case "blockIfQueueFull": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "compressiontype": 
            case "compressionType": {
                return CompressionType.class;
            }
            case "configuration": {
                return PulsarConfiguration.class;
            }
            case "consumername": 
            case "consumerName": {
                return String.class;
            }
            case "consumernameprefix": 
            case "consumerNamePrefix": {
                return String.class;
            }
            case "consumerqueuesize": 
            case "consumerQueueSize": {
                return Integer.TYPE;
            }
            case "deadlettertopic": 
            case "deadLetterTopic": {
                return String.class;
            }
            case "initialsequenceid": 
            case "initialSequenceId": {
                return Long.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "maxpendingmessages": 
            case "maxPendingMessages": {
                return Integer.TYPE;
            }
            case "maxpendingmessagesacrosspartitions": 
            case "maxPendingMessagesAcrossPartitions": {
                return Integer.TYPE;
            }
            case "maxredelivercount": 
            case "maxRedeliverCount": {
                return Integer.class;
            }
            case "messagelistener": 
            case "messageListener": {
                return Boolean.TYPE;
            }
            case "messagerouter": 
            case "messageRouter": {
                return MessageRouter.class;
            }
            case "messageroutingmode": 
            case "messageRoutingMode": {
                return MessageRoutingMode.class;
            }
            case "negativeackredeliverybackoff": 
            case "negativeAckRedeliveryBackoff": {
                return RedeliveryBackoff.class;
            }
            case "negativeackredeliverydelaymicros": 
            case "negativeAckRedeliveryDelayMicros": {
                return Long.TYPE;
            }
            case "numberofconsumerthreads": 
            case "numberOfConsumerThreads": {
                return Integer.TYPE;
            }
            case "numberofconsumers": 
            case "numberOfConsumers": {
                return Integer.TYPE;
            }
            case "producername": 
            case "producerName": {
                return String.class;
            }
            case "pulsarclient": 
            case "pulsarClient": {
                return PulsarClient.class;
            }
            case "pulsarmessagereceiptfactory": 
            case "pulsarMessageReceiptFactory": {
                return PulsarMessageReceiptFactory.class;
            }
            case "readcompacted": 
            case "readCompacted": {
                return Boolean.TYPE;
            }
            case "sendtimeoutms": 
            case "sendTimeoutMs": {
                return Integer.TYPE;
            }
            case "serviceurl": 
            case "serviceUrl": {
                return String.class;
            }
            case "subscriptioninitialposition": 
            case "subscriptionInitialPosition": {
                return SubscriptionInitialPosition.class;
            }
            case "subscriptionname": 
            case "subscriptionName": {
                return String.class;
            }
            case "subscriptiontopicsmode": 
            case "subscriptionTopicsMode": {
                return RegexSubscriptionMode.class;
            }
            case "subscriptiontype": 
            case "subscriptionType": {
                return SubscriptionType.class;
            }
            case "topicspattern": 
            case "topicsPattern": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        PulsarComponent target = (PulsarComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "ackgrouptimemillis": 
            case "ackGroupTimeMillis": {
                return this.getOrCreateConfiguration(target).getAckGroupTimeMillis();
            }
            case "acktimeoutmillis": 
            case "ackTimeoutMillis": {
                return this.getOrCreateConfiguration(target).getAckTimeoutMillis();
            }
            case "acktimeoutredeliverybackoff": 
            case "ackTimeoutRedeliveryBackoff": {
                return this.getOrCreateConfiguration(target).getAckTimeoutRedeliveryBackoff();
            }
            case "allowmanualacknowledgement": 
            case "allowManualAcknowledgement": {
                return this.getOrCreateConfiguration(target).isAllowManualAcknowledgement();
            }
            case "authenticationclass": 
            case "authenticationClass": {
                return this.getOrCreateConfiguration(target).getAuthenticationClass();
            }
            case "authenticationparams": 
            case "authenticationParams": {
                return this.getOrCreateConfiguration(target).getAuthenticationParams();
            }
            case "autoconfiguration": 
            case "autoConfiguration": {
                return target.getAutoConfiguration();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "batcherbuilder": 
            case "batcherBuilder": {
                return this.getOrCreateConfiguration(target).getBatcherBuilder();
            }
            case "batchingenabled": 
            case "batchingEnabled": {
                return this.getOrCreateConfiguration(target).isBatchingEnabled();
            }
            case "batchingmaxmessages": 
            case "batchingMaxMessages": {
                return this.getOrCreateConfiguration(target).getBatchingMaxMessages();
            }
            case "batchingmaxpublishdelaymicros": 
            case "batchingMaxPublishDelayMicros": {
                return this.getOrCreateConfiguration(target).getBatchingMaxPublishDelayMicros();
            }
            case "blockifqueuefull": 
            case "blockIfQueueFull": {
                return this.getOrCreateConfiguration(target).isBlockIfQueueFull();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "compressiontype": 
            case "compressionType": {
                return this.getOrCreateConfiguration(target).getCompressionType();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "consumername": 
            case "consumerName": {
                return this.getOrCreateConfiguration(target).getConsumerName();
            }
            case "consumernameprefix": 
            case "consumerNamePrefix": {
                return this.getOrCreateConfiguration(target).getConsumerNamePrefix();
            }
            case "consumerqueuesize": 
            case "consumerQueueSize": {
                return this.getOrCreateConfiguration(target).getConsumerQueueSize();
            }
            case "deadlettertopic": 
            case "deadLetterTopic": {
                return this.getOrCreateConfiguration(target).getDeadLetterTopic();
            }
            case "initialsequenceid": 
            case "initialSequenceId": {
                return this.getOrCreateConfiguration(target).getInitialSequenceId();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxpendingmessages": 
            case "maxPendingMessages": {
                return this.getOrCreateConfiguration(target).getMaxPendingMessages();
            }
            case "maxpendingmessagesacrosspartitions": 
            case "maxPendingMessagesAcrossPartitions": {
                return this.getOrCreateConfiguration(target).getMaxPendingMessagesAcrossPartitions();
            }
            case "maxredelivercount": 
            case "maxRedeliverCount": {
                return this.getOrCreateConfiguration(target).getMaxRedeliverCount();
            }
            case "messagelistener": 
            case "messageListener": {
                return this.getOrCreateConfiguration(target).isMessageListener();
            }
            case "messagerouter": 
            case "messageRouter": {
                return this.getOrCreateConfiguration(target).getMessageRouter();
            }
            case "messageroutingmode": 
            case "messageRoutingMode": {
                return this.getOrCreateConfiguration(target).getMessageRoutingMode();
            }
            case "negativeackredeliverybackoff": 
            case "negativeAckRedeliveryBackoff": {
                return this.getOrCreateConfiguration(target).getNegativeAckRedeliveryBackoff();
            }
            case "negativeackredeliverydelaymicros": 
            case "negativeAckRedeliveryDelayMicros": {
                return this.getOrCreateConfiguration(target).getNegativeAckRedeliveryDelayMicros();
            }
            case "numberofconsumerthreads": 
            case "numberOfConsumerThreads": {
                return this.getOrCreateConfiguration(target).getNumberOfConsumerThreads();
            }
            case "numberofconsumers": 
            case "numberOfConsumers": {
                return this.getOrCreateConfiguration(target).getNumberOfConsumers();
            }
            case "producername": 
            case "producerName": {
                return this.getOrCreateConfiguration(target).getProducerName();
            }
            case "pulsarclient": 
            case "pulsarClient": {
                return target.getPulsarClient();
            }
            case "pulsarmessagereceiptfactory": 
            case "pulsarMessageReceiptFactory": {
                return target.getPulsarMessageReceiptFactory();
            }
            case "readcompacted": 
            case "readCompacted": {
                return this.getOrCreateConfiguration(target).isReadCompacted();
            }
            case "sendtimeoutms": 
            case "sendTimeoutMs": {
                return this.getOrCreateConfiguration(target).getSendTimeoutMs();
            }
            case "serviceurl": 
            case "serviceUrl": {
                return this.getOrCreateConfiguration(target).getServiceUrl();
            }
            case "subscriptioninitialposition": 
            case "subscriptionInitialPosition": {
                return this.getOrCreateConfiguration(target).getSubscriptionInitialPosition();
            }
            case "subscriptionname": 
            case "subscriptionName": {
                return this.getOrCreateConfiguration(target).getSubscriptionName();
            }
            case "subscriptiontopicsmode": 
            case "subscriptionTopicsMode": {
                return this.getOrCreateConfiguration(target).getSubscriptionTopicsMode();
            }
            case "subscriptiontype": 
            case "subscriptionType": {
                return this.getOrCreateConfiguration(target).getSubscriptionType();
            }
            case "topicspattern": 
            case "topicsPattern": {
                return this.getOrCreateConfiguration(target).isTopicsPattern();
            }
        }
        return null;
    }
}

