/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarAdminException
extends Exception {
    private static final Logger log = LoggerFactory.getLogger(PulsarAdminException.class);
    private static final int DEFAULT_STATUS_CODE = 500;
    private final String httpError;
    private final int statusCode;

    public PulsarAdminException(Throwable t2, String httpError, int statusCode) {
        super(t2);
        this.httpError = httpError;
        this.statusCode = statusCode;
    }

    public PulsarAdminException(String message, Throwable t2, String httpError, int statusCode) {
        super(message, t2);
        this.httpError = httpError;
        this.statusCode = statusCode;
    }

    public PulsarAdminException(Throwable t2) {
        super(t2);
        this.httpError = null;
        this.statusCode = 500;
    }

    public PulsarAdminException(String message, Throwable t2) {
        super(message, t2);
        this.httpError = null;
        this.statusCode = 500;
    }

    public PulsarAdminException(String message) {
        super(message);
        this.httpError = null;
        this.statusCode = 500;
    }

    public String getHttpError() {
        return this.httpError;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public static class GettingAuthenticationDataException
    extends PulsarAdminException {
        public GettingAuthenticationDataException(Throwable t2) {
            super(t2);
        }

        public GettingAuthenticationDataException(String msg) {
            super(msg);
        }
    }

    public static class ConnectException
    extends PulsarAdminException {
        public ConnectException(Throwable t2) {
            super(t2);
        }

        public ConnectException(String message, Throwable t2) {
            super(message, t2);
        }
    }

    public static class HttpErrorException
    extends PulsarAdminException {
        public HttpErrorException(Exception e) {
            super(e);
        }

        public HttpErrorException(Throwable t2) {
            super(t2);
        }
    }

    public static class ServerSideErrorException
    extends PulsarAdminException {
        public ServerSideErrorException(Throwable t2, String message, String httpError, int statusCode) {
            super(message, t2, httpError, statusCode);
        }

        public ServerSideErrorException(Throwable t2) {
            super("Some error occourred on the server", t2);
        }
    }

    public static class TimeoutException
    extends PulsarAdminException {
        public TimeoutException(Throwable t2) {
            super(t2);
        }
    }

    public static class PreconditionFailedException
    extends PulsarAdminException {
        public PreconditionFailedException(Throwable t2, String httpError, int statusCode) {
            super(httpError, t2, httpError, statusCode);
        }
    }

    public static class ConflictException
    extends PulsarAdminException {
        public ConflictException(Throwable t2, String httpError, int statusCode) {
            super(httpError, t2, httpError, statusCode);
        }
    }

    public static class NotAllowedException
    extends PulsarAdminException {
        public NotAllowedException(Throwable t2, String httpError, int statusCode) {
            super(httpError, t2, httpError, statusCode);
        }
    }

    public static class NotFoundException
    extends PulsarAdminException {
        public NotFoundException(Throwable t2, String httpError, int statusCode) {
            super(httpError, t2, httpError, statusCode);
        }
    }

    public static class NotAuthorizedException
    extends PulsarAdminException {
        public NotAuthorizedException(Throwable t2, String httpError, int statusCode) {
            super(httpError, t2, httpError, statusCode);
        }
    }
}

