/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api.transaction;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class TransactionBufferClientException
extends IOException {
    public TransactionBufferClientException(Throwable t2) {
        super(t2);
    }

    public TransactionBufferClientException(String message) {
        super(message);
    }

    public static TransactionBufferClientException unwrap(Throwable t2) {
        if (t2 instanceof TransactionBufferClientException) {
            return (TransactionBufferClientException)t2;
        }
        if (t2 instanceof RuntimeException) {
            throw (RuntimeException)t2;
        }
        if (t2 instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            return new TransactionBufferClientException(t2);
        }
        if (!(t2 instanceof ExecutionException)) {
            return new TransactionBufferClientException(t2);
        }
        Throwable cause = t2.getCause();
        String msg = cause.getMessage();
        if (cause instanceof RequestTimeoutException) {
            return new RequestTimeoutException(msg);
        }
        return new TransactionBufferClientException(t2);
    }

    public static class ReachMaxPendingOpsException
    extends TransactionBufferClientException {
        public ReachMaxPendingOpsException() {
            super("Transaction buffer op reach max pending numbers.");
        }

        public ReachMaxPendingOpsException(String message) {
            super(message);
        }
    }

    public static class RequestTimeoutException
    extends TransactionBufferClientException {
        public RequestTimeoutException() {
            super("Transaction buffer request timeout.");
        }

        public RequestTimeoutException(String message) {
            super(message);
        }
    }
}

