/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz;

import java.util.Collection;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.component.quartz.QuartzEndpoint;
import org.apache.camel.component.quartz.QuartzMessage;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.TriggerKey;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelJob
implements Job,
InterruptableJob {
    private static final Logger LOG = LoggerFactory.getLogger(CamelJob.class);
    private final AtomicReference<Exchange> current = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        Exchange exchange = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running CamelJob jobExecutionContext={}", (Object)context);
            }
            CamelContext camelContext = this.getCamelContext(context);
            QuartzEndpoint endpoint = this.lookupQuartzEndpoint(camelContext, context);
            exchange = endpoint.createExchange();
            exchange.setIn(new QuartzMessage(exchange, context));
            this.current.set(exchange);
            AsyncProcessor processor = endpoint.getProcessor();
            try {
                if (processor != null) {
                    processor.process(exchange);
                } else {
                    LOG.debug("Cannot execute CamelJob as there are no active consumers.");
                }
            }
            catch (Exception e) {
                exchange.setException(e);
            }
            finally {
                this.current.set(null);
            }
            if (exchange.getException() != null) {
                throw new JobExecutionException(exchange.getException());
            }
        }
        catch (Exception e) {
            if (exchange != null) {
                LOG.error(CamelExchangeException.createExceptionMessage("Error processing exchange", exchange, e));
            } else {
                LOG.error("Failed to execute CamelJob.", (Throwable)e);
            }
            if (e instanceof JobExecutionException) {
                throw (JobExecutionException)e;
            }
            throw new JobExecutionException(e);
        }
    }

    protected CamelContext getCamelContext(JobExecutionContext context) throws JobExecutionException {
        String camelContextName;
        SchedulerContext schedulerContext = this.getSchedulerContext(context);
        CamelContext result = (CamelContext)schedulerContext.get("CamelQuartzCamelContext-" + (camelContextName = context.getMergedJobDataMap().getString("CamelQuartzCamelContextName")));
        if (result == null) {
            throw new JobExecutionException("No CamelContext could be found with name: " + camelContextName);
        }
        return result;
    }

    protected SchedulerContext getSchedulerContext(JobExecutionContext context) throws JobExecutionException {
        try {
            return context.getScheduler().getContext();
        }
        catch (SchedulerException e) {
            throw new JobExecutionException("Failed to obtain scheduler context for job " + context.getJobDetail().getKey());
        }
    }

    protected QuartzEndpoint lookupQuartzEndpoint(CamelContext camelContext, JobExecutionContext quartzContext) throws JobExecutionException {
        QuartzEndpoint result;
        TriggerKey triggerKey = quartzContext.getTrigger().getKey();
        JobDetail jobDetail = quartzContext.getJobDetail();
        JobKey jobKey = jobDetail.getKey();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking up existing QuartzEndpoint with triggerKey={}", (Object)triggerKey);
        }
        for (Route route : camelContext.getRoutes()) {
            Endpoint endpoint = route.getEndpoint();
            if (endpoint instanceof DelegateEndpoint) {
                endpoint = ((DelegateEndpoint)endpoint).getEndpoint();
            }
            if (!(endpoint instanceof QuartzEndpoint)) continue;
            QuartzEndpoint quartzEndpoint = (QuartzEndpoint)endpoint;
            TriggerKey checkTriggerKey = quartzEndpoint.getTriggerKey();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Checking route endpoint={} with checkTriggerKey={}", (Object)quartzEndpoint, (Object)checkTriggerKey);
            }
            if (!triggerKey.equals(checkTriggerKey) && (!jobDetail.requestsRecovery() || !jobKey.getGroup().equals(checkTriggerKey.getGroup()) || !jobKey.getName().equals(checkTriggerKey.getName()))) continue;
            return quartzEndpoint;
        }
        String endpointUri = quartzContext.getMergedJobDataMap().getString("CamelQuartzEndpoint");
        if (camelContext.hasEndpoint(endpointUri) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Getting Endpoint from camelContext.");
            }
            result = camelContext.getEndpoint(endpointUri, QuartzEndpoint.class);
        } else {
            result = this.searchForEndpointMatch(camelContext, endpointUri);
            if (result != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found match for endpoint URI = {} by searching endpoint list.", (Object)endpointUri);
                }
            } else {
                LOG.warn("Cannot find existing QuartzEndpoint with uri: {}. Creating new endpoint instance.", (Object)endpointUri);
                result = camelContext.getEndpoint(endpointUri, QuartzEndpoint.class);
            }
        }
        if (result == null) {
            throw new JobExecutionException("No QuartzEndpoint could be found with endpointUri: " + endpointUri);
        }
        return result;
    }

    protected QuartzEndpoint searchForEndpointMatch(CamelContext camelContext, String endpointUri) {
        Collection<Endpoint> endpoints = camelContext.getEndpoints();
        for (Endpoint endpoint : endpoints) {
            if (!endpointUri.equals(endpoint.getEndpointUri())) continue;
            return (QuartzEndpoint)endpoint;
        }
        return null;
    }

    @Override
    public void interrupt() throws UnableToInterruptJobException {
        Exchange exchange = this.current.get();
        if (exchange != null) {
            LOG.debug("Quartz interrupted job during shutdown on exchange: {}", (Object)exchange);
            exchange.setRouteStop(true);
            exchange.setException(new RejectedExecutionException("Quartz interrupted job during shutdown"));
        }
    }
}

