/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz;

import java.time.Duration;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.quartz.QuartzEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.quartz.Calendar;

public class QuartzEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        QuartzEndpoint target = (QuartzEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autostartscheduler": 
            case "autoStartScheduler": {
                target.setAutoStartScheduler(QuartzEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(QuartzEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "cron": {
                target.setCron(QuartzEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "customcalendar": 
            case "customCalendar": {
                target.setCustomCalendar(QuartzEndpointConfigurer.property(camelContext, Calendar.class, value));
                return true;
            }
            case "deletejob": 
            case "deleteJob": {
                target.setDeleteJob(QuartzEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "durablejob": 
            case "durableJob": {
                target.setDurableJob(QuartzEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(QuartzEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(QuartzEndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "ignoreexpirednextfiretime": 
            case "ignoreExpiredNextFireTime": {
                target.setIgnoreExpiredNextFireTime(QuartzEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "jobparameters": 
            case "jobParameters": {
                target.setJobParameters(QuartzEndpointConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "pausejob": 
            case "pauseJob": {
                target.setPauseJob(QuartzEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "prefixjobnamewithendpointid": 
            case "prefixJobNameWithEndpointId": {
                target.setPrefixJobNameWithEndpointId(QuartzEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "recoverablejob": 
            case "recoverableJob": {
                target.setRecoverableJob(QuartzEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "stateful": {
                target.setStateful(QuartzEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "triggerparameters": 
            case "triggerParameters": {
                target.setTriggerParameters(QuartzEndpointConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "triggerstartdelay": 
            case "triggerStartDelay": {
                target.setTriggerStartDelay(QuartzEndpointConfigurer.property(camelContext, Duration.class, value).toMillis());
                return true;
            }
            case "usingfixedcamelcontextname": 
            case "usingFixedCamelContextName": {
                target.setUsingFixedCamelContextName(QuartzEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autostartscheduler": 
            case "autoStartScheduler": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "cron": {
                return String.class;
            }
            case "customcalendar": 
            case "customCalendar": {
                return Calendar.class;
            }
            case "deletejob": 
            case "deleteJob": {
                return Boolean.TYPE;
            }
            case "durablejob": 
            case "durableJob": {
                return Boolean.TYPE;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "ignoreexpirednextfiretime": 
            case "ignoreExpiredNextFireTime": {
                return Boolean.TYPE;
            }
            case "jobparameters": 
            case "jobParameters": {
                return Map.class;
            }
            case "pausejob": 
            case "pauseJob": {
                return Boolean.TYPE;
            }
            case "prefixjobnamewithendpointid": 
            case "prefixJobNameWithEndpointId": {
                return Boolean.TYPE;
            }
            case "recoverablejob": 
            case "recoverableJob": {
                return Boolean.TYPE;
            }
            case "stateful": {
                return Boolean.TYPE;
            }
            case "triggerparameters": 
            case "triggerParameters": {
                return Map.class;
            }
            case "triggerstartdelay": 
            case "triggerStartDelay": {
                return Long.TYPE;
            }
            case "usingfixedcamelcontextname": 
            case "usingFixedCamelContextName": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        QuartzEndpoint target = (QuartzEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autostartscheduler": 
            case "autoStartScheduler": {
                return target.isAutoStartScheduler();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "cron": {
                return target.getCron();
            }
            case "customcalendar": 
            case "customCalendar": {
                return target.getCustomCalendar();
            }
            case "deletejob": 
            case "deleteJob": {
                return target.isDeleteJob();
            }
            case "durablejob": 
            case "durableJob": {
                return target.isDurableJob();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "ignoreexpirednextfiretime": 
            case "ignoreExpiredNextFireTime": {
                return target.isIgnoreExpiredNextFireTime();
            }
            case "jobparameters": 
            case "jobParameters": {
                return target.getJobParameters();
            }
            case "pausejob": 
            case "pauseJob": {
                return target.isPauseJob();
            }
            case "prefixjobnamewithendpointid": 
            case "prefixJobNameWithEndpointId": {
                return target.isPrefixJobNameWithEndpointId();
            }
            case "recoverablejob": 
            case "recoverableJob": {
                return target.isRecoverableJob();
            }
            case "stateful": {
                return target.isStateful();
            }
            case "triggerparameters": 
            case "triggerParameters": {
                return target.getTriggerParameters();
            }
            case "triggerstartdelay": 
            case "triggerStartDelay": {
                return target.getTriggerStartDelay();
            }
            case "usingfixedcamelcontextname": 
            case "usingFixedCamelContextName": {
                return target.isUsingFixedCamelContextName();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "jobparameters": 
            case "jobParameters": {
                return Object.class;
            }
            case "triggerparameters": 
            case "triggerParameters": {
                return Object.class;
            }
        }
        return null;
    }
}

