/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.routepolicy.quartz2;

import java.util.concurrent.TimeUnit;
import org.apache.camel.Route;
import org.apache.camel.component.quartz2.QuartzComponent;
import org.apache.camel.routepolicy.quartz2.ScheduledRoutePolicy;
import org.apache.camel.routepolicy.quartz2.ScheduledRoutePolicyConstants;
import org.apache.camel.util.ObjectHelper;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class CronScheduledRoutePolicy
extends ScheduledRoutePolicy
implements ScheduledRoutePolicyConstants {
    private String routeStartTime;
    private String routeStopTime;
    private String routeSuspendTime;
    private String routeResumeTime;

    public void onInit(Route route) {
        try {
            this.doOnInit(route);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }

    protected void doOnInit(Route route) throws Exception {
        QuartzComponent quartz = (QuartzComponent)route.getRouteContext().getCamelContext().getComponent("quartz2", QuartzComponent.class);
        this.setScheduler(quartz.getScheduler());
        if (this.getRouteStopGracePeriod() == 0) {
            this.setRouteStopGracePeriod(10000);
        }
        if (this.getTimeUnit() == null) {
            this.setTimeUnit(TimeUnit.MILLISECONDS);
        }
        if (this.getRouteStartTime() == null && this.getRouteStopTime() == null && this.getRouteSuspendTime() == null && this.getRouteResumeTime() == null) {
            throw new IllegalArgumentException("Scheduled Route Policy for route {} has no start/stop/suspend/resume times specified");
        }
        this.registerRouteToScheduledRouteDetails(route);
        if (this.getRouteStartTime() != null) {
            this.scheduleRoute(ScheduledRoutePolicyConstants.Action.START, route);
        }
        if (this.getRouteStopTime() != null) {
            this.scheduleRoute(ScheduledRoutePolicyConstants.Action.STOP, route);
        }
        if (this.getRouteSuspendTime() != null) {
            this.scheduleRoute(ScheduledRoutePolicyConstants.Action.SUSPEND, route);
        }
        if (this.getRouteResumeTime() != null) {
            this.scheduleRoute(ScheduledRoutePolicyConstants.Action.RESUME, route);
        }
    }

    @Override
    protected Trigger createTrigger(ScheduledRoutePolicyConstants.Action action, Route route) throws Exception {
        CronTrigger trigger = null;
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            trigger = TriggerBuilder.newTrigger().withIdentity(TRIGGER_START + route.getId(), "triggerGroup-" + route.getId()).withSchedule(CronScheduleBuilder.cronSchedule(this.getRouteStartTime())).build();
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            trigger = TriggerBuilder.newTrigger().withIdentity(TRIGGER_STOP + route.getId(), "triggerGroup-" + route.getId()).withSchedule(CronScheduleBuilder.cronSchedule(this.getRouteStopTime())).build();
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            trigger = TriggerBuilder.newTrigger().withIdentity(TRIGGER_SUSPEND + route.getId(), "triggerGroup-" + route.getId()).withSchedule(CronScheduleBuilder.cronSchedule(this.getRouteSuspendTime())).build();
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            trigger = TriggerBuilder.newTrigger().withIdentity(TRIGGER_RESUME + route.getId(), "triggerGroup-" + route.getId()).withSchedule(CronScheduleBuilder.cronSchedule(this.getRouteResumeTime())).build();
        }
        return trigger;
    }

    public void setRouteStartTime(String routeStartTime) {
        this.routeStartTime = routeStartTime;
    }

    public String getRouteStartTime() {
        return this.routeStartTime;
    }

    public void setRouteStopTime(String routeStopTime) {
        this.routeStopTime = routeStopTime;
    }

    public String getRouteStopTime() {
        return this.routeStopTime;
    }

    public void setRouteSuspendTime(String routeSuspendTime) {
        this.routeSuspendTime = routeSuspendTime;
    }

    public String getRouteSuspendTime() {
        return this.routeSuspendTime;
    }

    public void setRouteResumeTime(String routeResumeTime) {
        this.routeResumeTime = routeResumeTime;
    }

    public String getRouteResumeTime() {
        return this.routeResumeTime;
    }
}

