/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj.jmx.openmbean;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.quickfixj.jmx.openmbean.CompositeDataFactory;
import org.quickfixj.jmx.openmbean.CompositeTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabularDataAdapter {
    public TabularData fromArray(String tableTypeName, String rowTypeName, Object[] objects) throws OpenDataException {
        TabularDataSupport table = null;
        CompositeTypeFactory rowTypeFactory = new CompositeTypeFactory(rowTypeName, rowTypeName);
        rowTypeFactory.defineItem(rowTypeName, SimpleType.STRING);
        CompositeType rowType = rowTypeFactory.createCompositeType();
        TabularType tableType = new TabularType(tableTypeName, tableTypeName, rowType, new String[]{rowTypeName});
        CompositeDataFactory rowDataFactory = new CompositeDataFactory(rowType);
        table = new TabularDataSupport(tableType);
        for (int i = 0; i < objects.length; ++i) {
            rowDataFactory.clear();
            rowDataFactory.setValue(rowTypeName, objects[i].toString());
            table.put(rowDataFactory.createCompositeData());
        }
        return table;
    }

    public TabularData fromMap(String keyLabel, String valueLabel, Map data) throws OpenDataException {
        TabularDataSupport table = null;
        CompositeTypeFactory rowTypeFactory = new CompositeTypeFactory("row", "row");
        rowTypeFactory.defineItem(keyLabel, SimpleType.STRING);
        rowTypeFactory.defineItem(valueLabel, SimpleType.STRING);
        CompositeType rowType = rowTypeFactory.createCompositeType();
        TabularType tableType = new TabularType("TabularData", "TabularData", rowType, new String[]{keyLabel, valueLabel});
        CompositeDataFactory rowDataFactory = new CompositeDataFactory(rowType);
        table = new TabularDataSupport(tableType);
        for (Map.Entry entry : data.entrySet()) {
            rowDataFactory.clear();
            rowDataFactory.setValue(keyLabel, entry.getKey().toString());
            rowDataFactory.setValue(valueLabel, entry.getValue().toString());
            table.put(rowDataFactory.createCompositeData());
        }
        return table;
    }

    public TabularData fromBean(String keyLabel, String valueLabel, Object bean) throws OpenDataException {
        TabularDataSupport table = null;
        CompositeTypeFactory rowTypeFactory = new CompositeTypeFactory("row", "row");
        rowTypeFactory.defineItem(keyLabel, SimpleType.STRING);
        rowTypeFactory.defineItem(valueLabel, SimpleType.STRING);
        CompositeType rowType = rowTypeFactory.createCompositeType();
        TabularType tableType = new TabularType("TabularData", "TabularData", rowType, new String[]{keyLabel, valueLabel});
        CompositeDataFactory rowDataFactory = new CompositeDataFactory(rowType);
        table = new TabularDataSupport(tableType);
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                PropertyDescriptor descriptor = pds[i];
                if (descriptor.getReadMethod() == null || "class".equals(descriptor.getName())) continue;
                rowDataFactory.clear();
                rowDataFactory.setValue(keyLabel, descriptor.getName());
                Object value = descriptor.getReadMethod().invoke(bean, (Object[])null);
                if (value == null) {
                    value = "(null)";
                }
                rowDataFactory.setValue(valueLabel, value);
                table.put(rowDataFactory.createCompositeData());
            }
        }
        catch (OpenDataException e) {
            throw e;
        }
        catch (Exception e) {
            OpenDataException ode = new OpenDataException(e.getMessage());
            ode.setStackTrace(e.getStackTrace());
            throw ode;
        }
        return table;
    }

    public TabularData fromBeanList(String tableTypeName, String rowTypeName, String keyProperty, List<?> beans) throws OpenDataException {
        TabularDataSupport table = null;
        try {
            CompositeTypeFactory rowTypeFactory = new CompositeTypeFactory(rowTypeName, rowTypeName);
            ArrayList<String> indexNames = new ArrayList<String>();
            indexNames.add(keyProperty);
            rowTypeFactory.defineItem(this.formatHeader(keyProperty), SimpleType.STRING);
            for (int i = 0; i < beans.size(); ++i) {
                Object bean = beans.get(i);
                BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
                PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
                for (int p = 0; p < pds.length; ++p) {
                    PropertyDescriptor descriptor = pds[p];
                    String propertyName = descriptor.getName();
                    if (descriptor.getReadMethod() == null || "class".equals(propertyName) || indexNames.contains(propertyName)) continue;
                    indexNames.add(propertyName);
                    rowTypeFactory.defineItem(this.formatHeader(propertyName), SimpleType.STRING);
                }
            }
            CompositeType rowType = rowTypeFactory.createCompositeType();
            TabularType tableType = new TabularType(tableTypeName, tableTypeName, rowType, this.createTableHeaders(indexNames));
            CompositeDataFactory rowDataFactory = new CompositeDataFactory(rowType);
            table = new TabularDataSupport(tableType);
            for (int i = 0; i < beans.size(); ++i) {
                rowDataFactory.clear();
                Object bean = beans.get(i);
                BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
                PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
                for (int p = 0; p < pds.length; ++p) {
                    PropertyDescriptor descriptor = pds[p];
                    String propertyName = descriptor.getName();
                    String headerName = this.formatHeader(propertyName);
                    if (descriptor.getReadMethod() == null || "class".equals(propertyName)) continue;
                    Object value = descriptor.getReadMethod().invoke(bean, (Object[])null);
                    if (value == null) {
                        value = "(null)";
                    }
                    rowDataFactory.setValue(headerName, value.toString());
                }
                table.put(rowDataFactory.createCompositeData());
            }
        }
        catch (OpenDataException e) {
            throw e;
        }
        catch (Exception e) {
            OpenDataException ode = new OpenDataException(e.getMessage());
            ode.setStackTrace(e.getStackTrace());
            throw ode;
        }
        return table;
    }

    private String[] createTableHeaders(List<String> indexNames) {
        String[] headers = new String[indexNames.size()];
        for (int i = 0; i < indexNames.size(); ++i) {
            String name = indexNames.get(i);
            headers[i] = this.formatHeader(name);
        }
        return headers;
    }

    private String formatHeader(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }
}

