/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Log;

class CompositeLog
implements Log {
    private Logger defaultLog = LoggerFactory.getLogger(this.getClass());
    private final Log[] logs;
    private boolean rethrowException;

    public CompositeLog(Log[] logs) {
        this.logs = logs;
    }

    public void clear() {
        for (int i = 0; i < this.logs.length; ++i) {
            try {
                this.logs[i].clear();
                continue;
            }
            catch (Throwable e) {
                this.handleError(e);
            }
        }
    }

    private void handleError(Throwable e) {
        if (this.rethrowException) {
            throw new RuntimeException(e);
        }
        this.defaultLog.error(e.getMessage() + ", continuing", e);
    }

    public void onIncoming(String message) {
        for (int i = 0; i < this.logs.length; ++i) {
            try {
                this.logs[i].onIncoming(message);
                continue;
            }
            catch (Throwable e) {
                this.handleError(e);
            }
        }
    }

    public void onOutgoing(String message) {
        for (int i = 0; i < this.logs.length; ++i) {
            try {
                this.logs[i].onOutgoing(message);
                continue;
            }
            catch (Throwable e) {
                this.defaultLog.error(e.getMessage() + ", continuing", e);
            }
        }
    }

    public void onEvent(String text) {
        for (int i = 0; i < this.logs.length; ++i) {
            try {
                this.logs[i].onEvent(text);
                continue;
            }
            catch (Throwable e) {
                this.handleError(e);
            }
        }
    }

    public void onErrorEvent(String text) {
        for (int i = 0; i < this.logs.length; ++i) {
            try {
                this.logs[i].onErrorEvent(text);
                continue;
            }
            catch (Throwable e) {
                this.handleError(e);
            }
        }
    }

    void setRethrowExceptions(boolean flag) {
        this.rethrowException = flag;
    }
}

