/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quickfix.ConfigError;
import quickfix.Field;
import quickfix.FieldConvertError;
import quickfix.FieldException;
import quickfix.FieldMap;
import quickfix.FieldNotFound;
import quickfix.FieldType;
import quickfix.FileUtil;
import quickfix.Group;
import quickfix.IncorrectDataFormat;
import quickfix.IncorrectTagValue;
import quickfix.Message;
import quickfix.StringField;
import quickfix.UnsupportedVersion;
import quickfix.field.converter.BooleanConverter;
import quickfix.field.converter.CharConverter;
import quickfix.field.converter.DoubleConverter;
import quickfix.field.converter.IntConverter;
import quickfix.field.converter.UtcDateOnlyConverter;
import quickfix.field.converter.UtcTimeOnlyConverter;
import quickfix.field.converter.UtcTimestampConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataDictionary {
    private static final String FIXT_PREFIX = "FIXT";
    private static final String FIX_PREFIX = "FIX";
    public static final String ANY_VALUE = "__ANY__";
    public static final String HEADER_ID = "HEADER";
    public static final String TRAILER_ID = "TRAILER";
    private static final String MESSAGE_CATEGORY_ADMIN = "admin".intern();
    private static final String MESSAGE_CATEGORY_APP = "app".intern();
    private static final int USER_DEFINED_TAG_MIN = 5000;
    private static final String NO = "N";
    private boolean hasVersion = false;
    private boolean checkFieldsOutOfOrder = true;
    private boolean checkFieldsHaveValues = true;
    private boolean checkUserDefinedFields = true;
    private boolean checkUnorderedGroupFields = true;
    private boolean allowUnknownMessageFields = false;
    private String beginString;
    private final Map<String, Set<Integer>> messageFields = new HashMap<String, Set<Integer>>();
    private final Map<String, Set<Integer>> requiredFields = new HashMap<String, Set<Integer>>();
    private final Set<String> messages = new HashSet<String>();
    private final Map<String, String> messageCategory = new HashMap<String, String>();
    private final Map<String, String> messageTypeForName = new HashMap<String, String>();
    private final LinkedHashSet<Integer> fields = new LinkedHashSet();
    private final Map<Integer, FieldType> fieldTypes = new HashMap<Integer, FieldType>();
    private final Map<Integer, Set<String>> fieldValues = new HashMap<Integer, Set<String>>();
    private final Map<Integer, String> fieldNames = new HashMap<Integer, String>();
    private final Map<String, Integer> names = new HashMap<String, Integer>();
    private final Map<IntStringPair, String> valueNames = new HashMap<IntStringPair, String>();
    private final Map<IntStringPair, GroupInfo> groups = new HashMap<IntStringPair, GroupInfo>();
    private final Map<String, Node> components = new HashMap<String, Node>();
    private int[] orderedFieldsArray;

    private DataDictionary() {
    }

    public DataDictionary(String location) throws ConfigError {
        this.read(location);
    }

    public DataDictionary(InputStream in) throws ConfigError {
        this.load(in);
    }

    public DataDictionary(DataDictionary source) {
        this.copyFrom(source);
    }

    private void setVersion(String beginString) {
        this.beginString = beginString;
        this.hasVersion = true;
    }

    public String getVersion() {
        return this.beginString;
    }

    private void addField(int field) {
        this.fields.add(field);
    }

    private void addFieldName(int field, String name) throws ConfigError {
        if (this.names.put(name, field) != null) {
            throw new ConfigError("Field named " + name + " defined multiple times");
        }
        this.fieldNames.put(field, name);
    }

    public String getFieldName(int field) {
        return this.fieldNames.get(field);
    }

    private void addValueName(int field, String value, String name) {
        this.valueNames.put(new IntStringPair(field, value), name);
    }

    public String getValueName(int field, String value) {
        return this.valueNames.get(new IntStringPair(field, value));
    }

    public boolean isField(int field) {
        return this.fields.contains(field);
    }

    public FieldType getFieldTypeEnum(int field) {
        return this.fieldTypes.get(field);
    }

    private void addMsgType(String msgType, String msgName) {
        this.messages.add(msgType);
        if (msgName != null) {
            this.messageTypeForName.put(msgName, msgType);
        }
    }

    public String getMsgType(String msgName) {
        return this.messageTypeForName.get(msgName);
    }

    public boolean isMsgType(String msgType) {
        return this.messages.contains(msgType);
    }

    public boolean isAdminMessage(String msgType) {
        return this.messageCategory.get(msgType) == MESSAGE_CATEGORY_ADMIN;
    }

    public boolean isAppMessage(String msgType) {
        return this.messageCategory.get(msgType) == MESSAGE_CATEGORY_APP;
    }

    private void addMsgField(String msgType, int field) {
        Set<Integer> fields = this.messageFields.get(msgType);
        if (fields == null) {
            fields = new HashSet<Integer>();
            this.messageFields.put(msgType, fields);
        }
        fields.add(field);
    }

    public boolean isMsgField(String msgType, int field) {
        Set<Integer> fields = this.messageFields.get(msgType);
        return fields != null && fields.contains(field);
    }

    public boolean isHeaderField(int field) {
        if (this.messageFields.get(HEADER_ID) == null) {
            return false;
        }
        return this.messageFields.get(HEADER_ID).contains(field);
    }

    public boolean isTrailerField(int field) {
        return this.messageFields.get(TRAILER_ID).contains(field);
    }

    private void addFieldType(int field, FieldType fieldType) {
        this.fieldTypes.put(field, fieldType);
    }

    public int getFieldType(int field) {
        return this.getFieldTypeEnum(field).getOrdinal();
    }

    public int getFieldTag(String name) {
        Integer tag = this.names.get(name);
        return tag != null ? tag : -1;
    }

    private void addRequiredField(String msgType, int field) {
        Set<Integer> fields = this.requiredFields.get(msgType);
        if (fields == null) {
            fields = new HashSet<Integer>();
            this.requiredFields.put(msgType, fields);
        }
        fields.add(field);
    }

    public boolean isRequiredField(String msgType, int field) {
        Set<Integer> fields = this.requiredFields.get(msgType);
        return fields != null && fields.contains(field);
    }

    public boolean isRequiredHeaderField(int field) {
        return this.isRequiredField(HEADER_ID, field);
    }

    public boolean isRequiredTrailerField(int field) {
        return this.isRequiredField(TRAILER_ID, field);
    }

    private void addFieldValue(int field, String value) {
        Set<String> values = this.fieldValues.get(field);
        if (values == null) {
            values = new HashSet<String>();
            this.fieldValues.put(field, values);
        }
        values.add(value);
    }

    public boolean hasFieldValue(int field) {
        Set<String> values = this.fieldValues.get(field);
        return values != null && values.size() > 0;
    }

    public boolean isFieldValue(int field, String value) {
        Set<String> validValues = this.fieldValues.get(field);
        if (validValues == null || validValues.size() == 0) {
            return false;
        }
        if (validValues.contains(ANY_VALUE)) {
            return true;
        }
        if (!this.isMultipleValueStringField(field)) {
            return validValues.contains(value);
        }
        String[] values = value.split(" ");
        for (int i = 0; i < values.length; ++i) {
            if (validValues.contains(values[i])) continue;
            return false;
        }
        return true;
    }

    private void addGroup(String msg, int field, int delim, DataDictionary dataDictionary) {
        this.groups.put(new IntStringPair(field, msg), new GroupInfo(delim, dataDictionary));
    }

    public boolean isGroup(String msg, int field) {
        return this.groups.containsKey(new IntStringPair(field, msg));
    }

    public boolean isHeaderGroup(int field) {
        return this.groups.containsKey(new IntStringPair(field, HEADER_ID));
    }

    public GroupInfo getGroup(String msg, int field) {
        return this.groups.get(new IntStringPair(field, msg));
    }

    public boolean isDataField(int field) {
        return this.fieldTypes.get(field) == FieldType.Data;
    }

    private boolean isMultipleValueStringField(int field) {
        return this.fieldTypes.get(field) == FieldType.MultipleValueString;
    }

    public void setCheckFieldsOutOfOrder(boolean flag) {
        this.checkFieldsOutOfOrder = flag;
    }

    public boolean isCheckFieldsOutOfOrder() {
        return this.checkFieldsOutOfOrder;
    }

    public boolean isCheckUnorderedGroupFields() {
        return this.checkUnorderedGroupFields;
    }

    public void setCheckUnorderedGroupFields(boolean flag) {
        this.checkUnorderedGroupFields = flag;
        for (GroupInfo gi : this.groups.values()) {
            gi.getDataDictionary().setCheckUnorderedGroupFields(flag);
        }
    }

    public void setCheckFieldsHaveValues(boolean flag) {
        this.checkFieldsHaveValues = flag;
        for (GroupInfo gi : this.groups.values()) {
            gi.getDataDictionary().setCheckFieldsHaveValues(flag);
        }
    }

    public void setCheckUserDefinedFields(boolean flag) {
        this.checkUserDefinedFields = flag;
        for (GroupInfo gi : this.groups.values()) {
            gi.getDataDictionary().setCheckUserDefinedFields(flag);
        }
    }

    public void setAllowUnknownMessageFields(boolean allowUnknownFields) {
        this.allowUnknownMessageFields = allowUnknownFields;
        for (GroupInfo gi : this.groups.values()) {
            gi.getDataDictionary().setAllowUnknownMessageFields(allowUnknownFields);
        }
    }

    private void copyFrom(DataDictionary rhs) {
        this.hasVersion = rhs.hasVersion;
        this.beginString = rhs.beginString;
        this.checkFieldsOutOfOrder = rhs.checkFieldsOutOfOrder;
        this.checkFieldsHaveValues = rhs.checkFieldsHaveValues;
        this.checkUserDefinedFields = rhs.checkUserDefinedFields;
        this.copyMap(this.messageFields, rhs.messageFields);
        this.copyMap(this.requiredFields, rhs.requiredFields);
        this.copyCollection(this.messages, rhs.messages);
        this.copyCollection(this.fields, rhs.fields);
        this.copyMap(this.fieldTypes, rhs.fieldTypes);
        this.copyMap(this.fieldValues, rhs.fieldValues);
        this.copyMap(this.fieldNames, rhs.fieldNames);
        this.copyMap(this.names, rhs.names);
        this.copyMap(this.valueNames, rhs.valueNames);
        this.copyMap(this.groups, rhs.groups);
        this.copyMap(this.components, rhs.components);
    }

    private <K, V> void copyMap(Map<K, V> lhs, Map<K, V> rhs) {
        lhs.clear();
        for (Map.Entry<K, V> entry : rhs.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Collection) {
                Collection copy;
                try {
                    copy = (Collection)value.getClass().newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (java.lang.Exception e) {
                    throw new RuntimeException(e);
                }
                this.copyCollection(copy, (Collection)value);
                value = copy;
            }
            lhs.put(entry.getKey(), value);
        }
    }

    private <V> void copyCollection(Collection<V> lhs, Collection<V> rhs) {
        lhs.clear();
        lhs.addAll(rhs);
    }

    public void validate(Message message) throws IncorrectTagValue, FieldNotFound, IncorrectDataFormat {
        this.validate(message, false);
    }

    public void validate(Message message, boolean bodyOnly) throws IncorrectTagValue, FieldNotFound, IncorrectDataFormat {
        DataDictionary.validate(message, bodyOnly ? null : this, this);
    }

    static void validate(Message message, DataDictionary sessionDataDictionary, DataDictionary applicationDataDictionary) throws IncorrectTagValue, FieldNotFound, IncorrectDataFormat {
        boolean bodyOnly;
        boolean bl = bodyOnly = sessionDataDictionary == null;
        if (DataDictionary.isVersionSpecified(sessionDataDictionary) && !sessionDataDictionary.getVersion().equals(message.getHeader().getString(8)) && !message.getHeader().getString(8).equals("FIXT.1.1") && !sessionDataDictionary.getVersion().equals("FIX.5.0")) {
            throw new UnsupportedVersion("Message version '" + message.getHeader().getString(8) + "' does not match the data dictionary version '" + sessionDataDictionary.getVersion() + "'");
        }
        if (!message.hasValidStructure() && message.getException() != null) {
            throw message.getException();
        }
        String msgType = message.getHeader().getString(35);
        if (DataDictionary.isVersionSpecified(applicationDataDictionary)) {
            applicationDataDictionary.checkMsgType(msgType);
            applicationDataDictionary.checkHasRequired(message.getHeader(), message, message.getTrailer(), msgType, bodyOnly);
        }
        if (!bodyOnly) {
            sessionDataDictionary.iterate(message.getHeader(), HEADER_ID, sessionDataDictionary);
            sessionDataDictionary.iterate(message.getTrailer(), TRAILER_ID, sessionDataDictionary);
        }
        applicationDataDictionary.iterate(message, msgType, applicationDataDictionary);
    }

    private static boolean isVersionSpecified(DataDictionary dd) {
        return dd != null && dd.hasVersion;
    }

    private void iterate(FieldMap map, String msgType, DataDictionary dd) throws IncorrectTagValue, IncorrectDataFormat {
        Iterator<Field<?>> iterator = map.iterator();
        while (iterator.hasNext()) {
            StringField field = (StringField)iterator.next();
            this.checkHasValue(field);
            if (this.hasVersion) {
                this.checkValidFormat(field);
                this.checkValue(field);
            }
            if (this.beginString == null || !this.shouldCheckTag(field)) continue;
            dd.checkValidTagNumber(field);
            if (map instanceof Message) {
                this.checkIsInMessage(field, msgType);
            }
            dd.checkGroupCount(field, map, msgType);
        }
        for (List<Group> groups : map.getGroups().values()) {
            for (Group group : groups) {
                this.iterate(group, msgType, dd.getGroup(msgType, group.getFieldTag()).getDataDictionary());
            }
        }
    }

    private void checkMsgType(String msgType) {
        if (!this.isMsgType(msgType)) {
            throw new FieldException(11);
        }
    }

    private boolean shouldCheckTag(Field<?> field) {
        return this.checkUserDefinedFields || field.getField() < 5000;
    }

    void checkValidTagNumber(Field<?> field) {
        if (!this.fields.contains(field.getTag())) {
            throw new FieldException(0, field.getField());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkValidFormat(StringField field) throws IncorrectDataFormat {
        try {
            FieldType fieldType = this.getFieldTypeEnum(field.getTag());
            if (fieldType == FieldType.String) return;
            if (fieldType == FieldType.Char) {
                if (this.beginString.compareTo("FIX.4.1") <= 0) return;
                CharConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.Price) {
                DoubleConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.Int) {
                IntConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.Amt) {
                DoubleConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.Qty) {
                DoubleConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.Qty || fieldType == FieldType.MultipleValueString || fieldType == FieldType.Exchange) return;
            if (fieldType == FieldType.Boolean) {
                BooleanConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.LocalMktDate || fieldType == FieldType.Data) return;
            if (fieldType == FieldType.Float) {
                DoubleConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.PriceOffset) {
                DoubleConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.MonthYear || fieldType == FieldType.DayOfMonth) return;
            if (fieldType == FieldType.UtcDate) {
                UtcDateOnlyConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.UtcTimeOnly) {
                UtcTimeOnlyConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.UtcTimeStamp || fieldType == FieldType.Time) {
                UtcTimestampConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.NumInGroup) {
                IntConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.Percentage) {
                DoubleConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.SeqNum) {
                IntConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.Length) {
                IntConverter.convert(field.getValue());
                return;
            }
            if (fieldType != FieldType.Country) return;
        }
        catch (FieldConvertError e) {
            throw new IncorrectDataFormat(field.getTag(), field.getValue());
        }
    }

    private void checkValue(StringField field) throws IncorrectTagValue {
        int tag = field.getField();
        if (!this.hasFieldValue(tag)) {
            return;
        }
        String value = field.getValue();
        if (!this.isFieldValue(tag, value)) {
            throw new IncorrectTagValue(tag);
        }
    }

    private void checkHasValue(StringField field) {
        if (this.checkFieldsHaveValues && field.getValue().length() == 0) {
            throw new FieldException(4, field.getField());
        }
    }

    private void checkIsInMessage(Field<?> field, String msgType) {
        if (!this.isMsgField(msgType, field.getField()) && !this.allowUnknownMessageFields) {
            throw new FieldException(2, field.getField());
        }
    }

    private void checkGroupCount(StringField field, FieldMap fieldMap, String msgType) {
        int fieldNum = field.getField();
        if (this.isGroup(msgType, fieldNum) && fieldMap.getGroupCount(fieldNum) != Integer.parseInt(field.getValue())) {
            throw new FieldException(16, fieldNum);
        }
    }

    void checkHasRequired(FieldMap header, FieldMap body, FieldMap trailer, String msgType, boolean bodyOnly) {
        if (!bodyOnly) {
            this.checkHasRequired(HEADER_ID, header, bodyOnly);
            this.checkHasRequired(TRAILER_ID, trailer, bodyOnly);
        }
        this.checkHasRequired(msgType, body, bodyOnly);
    }

    private void checkHasRequired(String msgType, FieldMap fields, boolean bodyOnly) {
        Set<Integer> requiredFieldsForMessage = this.requiredFields.get(msgType);
        if (requiredFieldsForMessage == null || requiredFieldsForMessage.size() == 0) {
            return;
        }
        for (int field : requiredFieldsForMessage) {
            if (fields.isSetField(field)) continue;
            throw new FieldException(1, field);
        }
        Map<Integer, List<Group>> groups = fields.getGroups();
        if (groups.size() > 0) {
            for (Map.Entry<Integer, List<Group>> entry : groups.entrySet()) {
                GroupInfo p = this.getGroup(msgType, entry.getKey());
                if (p == null) continue;
                List<Group> groupInstances = entry.getValue();
                for (int i = 0; i < groupInstances.size(); ++i) {
                    FieldMap groupFields = groupInstances.get(i);
                    p.getDataDictionary().checkHasRequired(groupFields, groupFields, groupFields, msgType, bodyOnly);
                }
            }
        }
    }

    private void read(String location) throws ConfigError {
        InputStream inputStream = FileUtil.open(this.getClass(), location, FileUtil.Location.URL, FileUtil.Location.FILESYSTEM, FileUtil.Location.CONTEXT_RESOURCE, FileUtil.Location.CLASSLOADER_RESOURCE);
        if (inputStream == null) {
            throw new Exception("Could not find data dictionary: " + location);
        }
        try {
            this.load(inputStream);
        }
        catch (java.lang.Exception e) {
            throw new ConfigError(location + ": " + e.getMessage(), e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new ConfigError(e);
            }
        }
    }

    private void load(InputStream inputStream) throws ConfigError {
        NodeList messagesNode;
        NodeList fieldsNode;
        Document document;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(inputStream);
        }
        catch (Throwable e) {
            throw new ConfigError("Could not parse data dictionary file", e);
        }
        Element documentElement = document.getDocumentElement();
        if (!documentElement.getNodeName().equals("fix")) {
            throw new ConfigError("Could not parse data dictionary file, or no <fix> node found at root");
        }
        if (!documentElement.hasAttribute("major")) {
            throw new ConfigError("major attribute not found on <fix>");
        }
        if (!documentElement.hasAttribute("minor")) {
            throw new ConfigError("minor attribute not found on <fix>");
        }
        String dictionaryType = documentElement.hasAttribute("type") ? documentElement.getAttribute("type") : FIX_PREFIX;
        this.setVersion(dictionaryType + "." + documentElement.getAttribute("major") + "." + documentElement.getAttribute("minor"));
        NodeList componentsNode = documentElement.getElementsByTagName("components");
        if (componentsNode.getLength() > 0) {
            NodeList componentNodes = componentsNode.item(0).getChildNodes();
            for (int i = 0; i < componentNodes.getLength(); ++i) {
                Node componentNode = componentNodes.item(i);
                if (!componentNode.getNodeName().equals("component")) continue;
                String name = this.getAttribute(componentNode, "name");
                if (name == null) {
                    throw new ConfigError("<component> does not have a name attribute");
                }
                this.components.put(name, componentNode);
            }
        }
        if ((fieldsNode = documentElement.getElementsByTagName("fields")).getLength() == 0) {
            throw new ConfigError("<fields> section not found in data dictionary");
        }
        NodeList fieldNodes = fieldsNode.item(0).getChildNodes();
        if (fieldNodes.getLength() == 0) {
            throw new ConfigError("No fields defined");
        }
        for (int i = 0; i < fieldNodes.getLength(); ++i) {
            String allowOtherValues;
            Node fieldNode = fieldNodes.item(i);
            if (!fieldNode.getNodeName().equals("field")) continue;
            String name = this.getAttribute(fieldNode, "name");
            if (name == null) {
                throw new ConfigError("<field> does not have a name attribute");
            }
            String number = this.getAttribute(fieldNode, "number");
            if (number == null) {
                throw new ConfigError("<field> " + name + " does not have a number attribute");
            }
            int num = Integer.parseInt(number);
            String type = this.getAttribute(fieldNode, "type");
            if (type == null) {
                throw new ConfigError("<field> " + name + " does not have a type attribute");
            }
            this.addField(num);
            this.addFieldType(num, FieldType.fromName(this.getVersion(), type));
            this.addFieldName(num, name);
            NodeList valueNodes = fieldNode.getChildNodes();
            for (int j = 0; j < valueNodes.getLength(); ++j) {
                Node valueNode = valueNodes.item(j);
                if (!valueNode.getNodeName().equals("value")) continue;
                String enumeration = this.getAttribute(valueNode, "enum");
                if (enumeration == null) {
                    throw new ConfigError("<value> does not have enum attribute in field " + name);
                }
                this.addFieldValue(num, enumeration);
                String description = this.getAttribute(valueNode, "description");
                if (description == null) continue;
                this.addValueName(num, enumeration, description);
            }
            if (!this.fieldValues.containsKey(num) || (allowOtherValues = this.getAttribute(fieldNode, "allowOtherValues")) == null || !Boolean.parseBoolean(allowOtherValues)) continue;
            this.addFieldValue(num, ANY_VALUE);
        }
        if (this.beginString.startsWith(FIXT_PREFIX) || this.beginString.compareTo("FIX.5.0") < 0) {
            NodeList headerNode = documentElement.getElementsByTagName("header");
            if (headerNode.getLength() == 0) {
                throw new ConfigError("<header> section not found in data dictionary");
            }
            this.load(document, HEADER_ID, headerNode.item(0));
            NodeList trailerNode = documentElement.getElementsByTagName("trailer");
            if (trailerNode.getLength() == 0) {
                throw new ConfigError("<trailer> section not found in data dictionary");
            }
            this.load(document, TRAILER_ID, trailerNode.item(0));
        }
        if ((messagesNode = documentElement.getElementsByTagName("messages")).getLength() == 0) {
            throw new ConfigError("<messages> section not found in data dictionary");
        }
        NodeList messageNodes = messagesNode.item(0).getChildNodes();
        if (messageNodes.getLength() == 0) {
            throw new ConfigError("No messages defined");
        }
        for (int i = 0; i < messageNodes.getLength(); ++i) {
            Node messageNode = messageNodes.item(i);
            if (!messageNode.getNodeName().equals("message")) continue;
            String msgtype = this.getAttribute(messageNode, "msgtype");
            if (msgtype == null) {
                throw new ConfigError("<message> does not have a msgtype attribute");
            }
            String msgcat = this.getAttribute(messageNode, "msgcat");
            if (msgcat != null) {
                this.messageCategory.put(msgtype, msgcat.intern());
            }
            String name = this.getAttribute(messageNode, "name");
            this.addMsgType(msgtype, name);
            if (name != null) {
                this.addValueName(35, msgtype, name);
            }
            this.load(document, msgtype, messageNode);
        }
    }

    private void load(Document document, String msgtype, Node node) throws ConfigError {
        NodeList fieldNodes = node.getChildNodes();
        if (fieldNodes.getLength() == 0) {
            throw new ConfigError("No fields found: msgType=" + msgtype);
        }
        for (int j = 0; j < fieldNodes.getLength(); ++j) {
            Node fieldNode = fieldNodes.item(j);
            if (fieldNode.getNodeName().equals("field") || fieldNode.getNodeName().equals("group")) {
                String name = this.getAttribute(fieldNode, "name");
                if (name == null) {
                    throw new ConfigError("<field> does not have a name attribute");
                }
                int num = this.lookupXMLFieldNumber(document, name);
                this.addMsgField(msgtype, num);
                String required = this.getAttribute(fieldNode, "required", NO);
                if (required == null) {
                    throw new ConfigError("<" + fieldNode.getNodeName() + "> does not have a 'required' attribute");
                }
                if (required.equalsIgnoreCase("Y")) {
                    this.addRequiredField(msgtype, num);
                }
            } else if (fieldNode.getNodeName().equals("component")) {
                String required = this.getAttribute(fieldNode, "required");
                if (required == null) {
                    throw new ConfigError("<component> does not have a 'required' attribute");
                }
                this.addXMLComponentFields(document, fieldNode, msgtype, this, required.equalsIgnoreCase("Y"));
            }
            if (!fieldNode.getNodeName().equals("group")) continue;
            String required = this.getAttribute(fieldNode, "required");
            if (required == null) {
                throw new ConfigError("<group> does not have a 'required' attribute");
            }
            this.addXMLGroup(document, fieldNode, msgtype, this, required.equalsIgnoreCase("Y"));
        }
    }

    public int[] getOrderedFields() {
        if (this.orderedFieldsArray == null) {
            this.orderedFieldsArray = new int[this.fields.size()];
            Iterator fieldItr = this.fields.iterator();
            int i = 0;
            while (fieldItr.hasNext()) {
                this.orderedFieldsArray[i++] = (Integer)fieldItr.next();
            }
        }
        return this.orderedFieldsArray;
    }

    private int lookupXMLFieldNumber(Document document, Node node) throws ConfigError {
        Element element = (Element)node;
        if (!element.hasAttribute("name")) {
            throw new ConfigError("No name given to field");
        }
        return this.lookupXMLFieldNumber(document, element.getAttribute("name"));
    }

    private int lookupXMLFieldNumber(Document document, String name) throws ConfigError {
        Integer fieldNumber = this.names.get(name);
        if (fieldNumber == null) {
            throw new ConfigError("Field " + name + " not defined in fields section");
        }
        return fieldNumber;
    }

    private int addXMLComponentFields(Document document, Node node, String msgtype, DataDictionary dd, boolean componentRequired) throws ConfigError {
        int firstField = 0;
        String name = this.getAttribute(node, "name");
        if (name == null) {
            throw new ConfigError("No name given to component");
        }
        Node componentNode = this.components.get(name);
        if (componentNode == null) {
            throw new ConfigError("Component " + name + " not found");
        }
        NodeList componentFieldNodes = componentNode.getChildNodes();
        for (int i = 0; i < componentFieldNodes.getLength(); ++i) {
            Node componentFieldNode = componentFieldNodes.item(i);
            if (componentFieldNode.getNodeName().equals("field") || componentFieldNode.getNodeName().equals("group")) {
                String required;
                name = this.getAttribute(componentFieldNode, "name");
                if (name == null) {
                    throw new ConfigError("No name given to field");
                }
                int field = this.lookupXMLFieldNumber(document, name);
                if (firstField == 0) {
                    firstField = field;
                }
                if ((required = this.getAttribute(componentFieldNode, "required")).equalsIgnoreCase("Y") && componentRequired) {
                    this.addRequiredField(msgtype, field);
                }
                dd.addField(field);
                dd.addMsgField(msgtype, field);
            }
            if (componentFieldNode.getNodeName().equals("group")) {
                String required = this.getAttribute(componentFieldNode, "required");
                boolean isRequired = required.equalsIgnoreCase("Y");
                this.addXMLGroup(document, componentFieldNode, msgtype, dd, isRequired);
            }
            if (!componentFieldNode.getNodeName().equals("component")) continue;
            String required = this.getAttribute(componentFieldNode, "required");
            boolean isRequired = required.equalsIgnoreCase("Y");
            this.addXMLComponentFields(document, componentFieldNode, msgtype, dd, isRequired);
        }
        return firstField;
    }

    private void addXMLGroup(Document document, Node node, String msgtype, DataDictionary dd, boolean groupRequired) throws ConfigError {
        String name = this.getAttribute(node, "name");
        if (name == null) {
            throw new ConfigError("No name given to group");
        }
        int group = this.lookupXMLFieldNumber(document, name);
        int delim = 0;
        int field = 0;
        DataDictionary groupDD = new DataDictionary();
        groupDD.setVersion(dd.getVersion());
        NodeList fieldNodeList = node.getChildNodes();
        for (int i = 0; i < fieldNodeList.getLength(); ++i) {
            String required;
            Node fieldNode = fieldNodeList.item(i);
            if (fieldNode.getNodeName().equals("field")) {
                field = this.lookupXMLFieldNumber(document, fieldNode);
                groupDD.addField(field);
                required = this.getAttribute(fieldNode, "required");
                if (required != null && required.equalsIgnoreCase("Y") && groupRequired) {
                    groupDD.addRequiredField(msgtype, field);
                }
            } else if (fieldNode.getNodeName().equals("component")) {
                field = this.addXMLComponentFields(document, fieldNode, msgtype, groupDD, false);
            } else if (fieldNode.getNodeName().equals("group")) {
                field = this.lookupXMLFieldNumber(document, fieldNode);
                groupDD.addField(field);
                required = this.getAttribute(fieldNode, "required");
                if (required != null && required.equalsIgnoreCase("Y") && groupRequired) {
                    groupDD.addRequiredField(msgtype, field);
                }
                boolean isRequired = required == null ? false : required.equalsIgnoreCase("Y");
                this.addXMLGroup(document, fieldNode, msgtype, groupDD, isRequired);
            }
            if (delim != 0) continue;
            delim = field;
        }
        if (delim != 0) {
            dd.addGroup(msgtype, group, delim, groupDD);
        }
    }

    private String getAttribute(Node node, String name) {
        return this.getAttribute(node, name, null);
    }

    private String getAttribute(Node node, String name, String defaultValue) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            Node namedItem = attributes.getNamedItem(name);
            return namedItem != null ? namedItem.getNodeValue() : null;
        }
        return defaultValue;
    }

    public static final class GroupInfo {
        private final int delimiterField;
        private final DataDictionary dataDictionary;

        private GroupInfo(int field, DataDictionary dictionary) {
            this.delimiterField = field;
            this.dataDictionary = dictionary;
        }

        public DataDictionary getDataDictionary() {
            return this.dataDictionary;
        }

        @Deprecated
        public int getDelimeterField() {
            return this.delimiterField;
        }

        public int getDelimiterField() {
            return this.delimiterField;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GroupInfo)) {
                return false;
            }
            return this.delimiterField == ((GroupInfo)other).delimiterField && this.dataDictionary.equals(((GroupInfo)other).dataDictionary);
        }

        public int hashCode() {
            return this.delimiterField;
        }
    }

    private static final class IntStringPair {
        private final int intValue;
        private final String stringValue;

        public IntStringPair(int value, String value2) {
            this.intValue = value;
            this.stringValue = value2;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IntStringPair)) {
                return false;
            }
            return this.intValue == ((IntStringPair)other).intValue && this.stringValue.equals(((IntStringPair)other).stringValue);
        }

        public int hashCode() {
            return this.stringValue.hashCode() + this.intValue;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append('(').append(this.intValue).append(',').append(this.stringValue).append(')');
            return b.toString();
        }
    }

    public static class Exception
    extends RuntimeException {
        public Exception(Throwable cause) {
            super(cause);
        }

        public Exception(String message) {
            super(message);
        }
    }
}

