/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.quickfixj.QFJException;
import quickfix.ConfigError;
import quickfix.DataDictionary;
import quickfix.DataDictionaryProvider;
import quickfix.MessageUtils;
import quickfix.field.ApplVerID;

public class DefaultDataDictionaryProvider
implements DataDictionaryProvider {
    private Map<String, DataDictionary> transportDictionaries = new ConcurrentHashMap<String, DataDictionary>();
    private Map<AppVersionKey, DataDictionary> applicationDictionaries = new ConcurrentHashMap<AppVersionKey, DataDictionary>();
    private final boolean findDataDictionaries;

    public DefaultDataDictionaryProvider() {
        this.findDataDictionaries = true;
    }

    public DefaultDataDictionaryProvider(boolean findDataDictionaries) {
        this.findDataDictionaries = findDataDictionaries;
    }

    public synchronized DataDictionary getSessionDataDictionary(String beginString) {
        DataDictionary dd = this.transportDictionaries.get(beginString);
        if (dd == null && this.findDataDictionaries) {
            String path = beginString.replace(".", "") + ".xml";
            try {
                dd = new DataDictionary(path);
                this.transportDictionaries.put(beginString, dd);
            }
            catch (ConfigError e) {
                throw new QFJException(e);
            }
        }
        return dd;
    }

    public DataDictionary getApplicationDataDictionary(ApplVerID applVerID) {
        AppVersionKey appVersionKey = new AppVersionKey(applVerID);
        DataDictionary dd = this.applicationDictionaries.get(appVersionKey);
        if (dd == null && this.findDataDictionaries) {
            String beginString = MessageUtils.toBeginString(applVerID);
            String path = beginString.replace(".", "") + ".xml";
            try {
                dd = new DataDictionary(path);
                this.applicationDictionaries.put(appVersionKey, dd);
            }
            catch (ConfigError e) {
                throw new QFJException(e);
            }
        }
        return dd;
    }

    public void addTransportDictionary(String beginString, DataDictionary dd) {
        this.transportDictionaries.put(beginString, dd);
    }

    public void addApplicationDictionary(ApplVerID applVerID, DataDictionary dataDictionary) {
        this.applicationDictionaries.put(new AppVersionKey(applVerID), dataDictionary);
    }

    private static class AppVersionKey {
        private final ApplVerID applVerID;

        public AppVersionKey(ApplVerID applVerID) {
            this.applVerID = applVerID;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.applVerID == null ? 0 : this.applVerID.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AppVersionKey other = (AppVersionKey)obj;
            return !(this.applVerID == null ? other.applVerID != null : !this.applVerID.equals(other.applVerID));
        }
    }
}

