/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.util.HashMap;
import java.util.Map;
import quickfix.ConfigError;
import quickfix.DayConverter;
import quickfix.FieldConvertError;
import quickfix.RuntimeError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dictionary {
    private String name;
    private HashMap<Object, Object> data = new HashMap();

    public Dictionary() {
    }

    public Dictionary(String name) {
        this(name, new HashMap<Object, Object>());
    }

    public Dictionary(Dictionary dictionary) {
        this(dictionary.name, dictionary.data);
    }

    public Dictionary(String name, Map<Object, Object> data) {
        this.name = name;
        this.data.putAll(data);
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        return this.data.size();
    }

    public String getString(String key) throws ConfigError, FieldConvertError {
        try {
            return this.data.get(key).toString();
        }
        catch (NullPointerException e) {
            throw new ConfigError("No value for key: " + key);
        }
    }

    public String getString(String key, boolean capitalize) throws ConfigError, FieldConvertError {
        String string = this.getString(key);
        return capitalize ? string.toUpperCase() : string;
    }

    public long getLong(String key) throws ConfigError, FieldConvertError {
        try {
            return (Long)this.data.get(key);
        }
        catch (ClassCastException e) {
            throw new FieldConvertError("Incorrect data type");
        }
        catch (NullPointerException e) {
            throw new ConfigError("No value for key: " + key);
        }
    }

    public double getDouble(String key) throws ConfigError, FieldConvertError {
        try {
            return (Double)this.data.get(key);
        }
        catch (ClassCastException e) {
            throw new FieldConvertError("Incorrect data type");
        }
        catch (NullPointerException e) {
            throw new ConfigError("No value for key: " + key);
        }
    }

    public boolean getBool(String key) throws ConfigError, FieldConvertError {
        try {
            return (Boolean)this.data.get(key);
        }
        catch (ClassCastException e) {
            throw new FieldConvertError("Incorrect data type");
        }
        catch (NullPointerException e) {
            throw new ConfigError("No value for key: " + key);
        }
    }

    public int getDay(String key) throws ConfigError, FieldConvertError {
        Object datum = this.data.get(key);
        if (datum == null) {
            throw new ConfigError("No value for key.");
        }
        if (datum instanceof String) {
            return DayConverter.toInteger((String)datum);
        }
        throw new ConfigError("Invalid data type for day value: " + datum.getClass().getName());
    }

    public void setString(String key, String value) {
        this.data.put(key, value);
    }

    public void setLong(String key, long value) {
        this.data.put(key, value);
    }

    public void setDouble(String key, double value) {
        this.data.put(key, value);
    }

    public void setBool(String key, boolean value) {
        this.data.put(key, value);
    }

    public void setDay(String key, int value) {
        try {
            this.data.put(key, DayConverter.toString(value));
        }
        catch (ConfigError e) {
            throw new RuntimeError(e);
        }
    }

    public void setDay(String key, String dayName) {
        this.data.put(key, dayName);
    }

    public boolean has(String key) {
        return this.data.containsKey(key);
    }

    public void merge(Dictionary toMerge) {
        this.data.putAll(toMerge.data);
    }

    public Map<Object, Object> toMap() {
        return this.data;
    }
}

