/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.TreeMap;
import org.quickfixj.CharsetSupport;
import quickfix.FileUtil;
import quickfix.MemoryStore;
import quickfix.MessageStore;
import quickfix.SessionID;
import quickfix.SystemTime;
import quickfix.field.converter.UtcTimestampConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStore
implements MessageStore,
Closeable {
    private static final String READ_OPTION = "r";
    private static final String WRITE_OPTION = "w";
    private static final String SYNC_OPTION = "d";
    private static final String NOSYNC_OPTION = "";
    private final TreeMap<Long, long[]> messageIndex;
    private final MemoryStore cache = new MemoryStore();
    private final String msgFileName;
    private final String headerFileName;
    private final String senderSeqNumFileName;
    private final String targetSeqNumFileName;
    private final String sessionFileName;
    private final boolean syncWrites;
    private final int maxCachedMsgs;
    private final String charsetEncoding = CharsetSupport.getCharset();
    private RandomAccessFile messageFileReader;
    private RandomAccessFile messageFileWriter;
    private DataOutputStream headerDataOutputStream;
    private FileOutputStream headerFileOutputStream;
    private RandomAccessFile senderSequenceNumberFile;
    private RandomAccessFile targetSequenceNumberFile;

    FileStore(String path, SessionID sessionID, boolean syncWrites, int maxCachedMsgs) throws IOException {
        this.syncWrites = syncWrites;
        this.maxCachedMsgs = maxCachedMsgs;
        this.messageIndex = maxCachedMsgs > 0 ? new TreeMap() : null;
        String fullPath = new File(path == null ? "." : path).getAbsolutePath();
        String sessionName = FileUtil.sessionIdFileName(sessionID);
        String prefix = FileUtil.fileAppendPath(fullPath, sessionName + ".");
        this.msgFileName = prefix + "body";
        this.headerFileName = prefix + "header";
        this.senderSeqNumFileName = prefix + "senderseqnums";
        this.targetSeqNumFileName = prefix + "targetseqnums";
        this.sessionFileName = prefix + "session";
        File directory = new File(this.msgFileName).getParentFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        this.initialize(false);
    }

    void initialize(boolean deleteFiles) throws IOException {
        this.closeFiles();
        if (deleteFiles) {
            this.deleteFiles();
        }
        this.messageFileWriter = new RandomAccessFile(this.msgFileName, this.getRandomAccessFileOptions());
        this.messageFileReader = new RandomAccessFile(this.msgFileName, READ_OPTION);
        this.senderSequenceNumberFile = new RandomAccessFile(this.senderSeqNumFileName, this.getRandomAccessFileOptions());
        this.targetSequenceNumberFile = new RandomAccessFile(this.targetSeqNumFileName, this.getRandomAccessFileOptions());
        this.initializeCache();
    }

    private void initializeCache() throws IOException {
        this.cache.reset();
        this.initializeMessageIndex();
        this.initializeSequenceNumbers();
        this.initializeSessionCreateTime();
        this.messageFileWriter.seek(this.messageFileWriter.length());
    }

    private void initializeSessionCreateTime() throws IOException {
        File sessionTimeFile = new File(this.sessionFileName);
        if (sessionTimeFile.exists() && sessionTimeFile.length() > 0L) {
            DataInputStream sessionTimeInput = new DataInputStream(new BufferedInputStream(new FileInputStream(sessionTimeFile)));
            try {
                Calendar c = SystemTime.getUtcCalendar(UtcTimestampConverter.convert(sessionTimeInput.readUTF()));
                this.cache.setCreationTime(c);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            finally {
                sessionTimeInput.close();
            }
        } else {
            this.storeSessionTimeStamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSessionTimeStamp() throws IOException {
        DataOutputStream sessionTimeOutput = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.sessionFileName, false)));
        try {
            Date date = SystemTime.getDate();
            this.cache.setCreationTime(SystemTime.getUtcCalendar(date));
            sessionTimeOutput.writeUTF(UtcTimestampConverter.convert(date, true));
        }
        finally {
            sessionTimeOutput.close();
        }
    }

    @Override
    public Date getCreationTime() throws IOException {
        return this.cache.getCreationTime();
    }

    private void initializeSequenceNumbers() throws IOException {
        String s;
        this.senderSequenceNumberFile.seek(0L);
        this.targetSequenceNumberFile.seek(0L);
        if (this.senderSequenceNumberFile.length() > 0L) {
            s = this.senderSequenceNumberFile.readUTF();
            this.cache.setNextSenderMsgSeqNum(Integer.parseInt(s));
        }
        if (this.targetSequenceNumberFile.length() > 0L) {
            s = this.targetSequenceNumberFile.readUTF();
            this.cache.setNextTargetMsgSeqNum(Integer.parseInt(s));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeMessageIndex() throws IOException {
        if (this.messageIndex != null) {
            this.messageIndex.clear();
            File headerFile = new File(this.headerFileName);
            if (headerFile.exists()) {
                DataInputStream headerDataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(headerFile)));
                try {
                    while (headerDataInputStream.available() > 0) {
                        int sequenceNumber = headerDataInputStream.readInt();
                        long offset = headerDataInputStream.readLong();
                        int size = headerDataInputStream.readInt();
                        this.updateMessageIndex(Long.valueOf(sequenceNumber), new long[]{offset, size});
                    }
                }
                finally {
                    headerDataInputStream.close();
                }
            }
        }
        this.headerFileOutputStream = new FileOutputStream(this.headerFileName, true);
        this.headerDataOutputStream = new DataOutputStream(new BufferedOutputStream(this.headerFileOutputStream));
    }

    private void updateMessageIndex(Long sequenceNum, long[] offsetAndSize) {
        if (this.messageIndex.size() >= this.maxCachedMsgs && this.messageIndex.get(sequenceNum) == null) {
            this.messageIndex.remove(this.messageIndex.firstKey());
        }
        this.messageIndex.put(sequenceNum, offsetAndSize);
    }

    private String getRandomAccessFileOptions() {
        return "rw" + (this.syncWrites ? SYNC_OPTION : NOSYNC_OPTION);
    }

    @Deprecated
    public void closeFiles() throws IOException {
        this.close();
    }

    @Override
    public void close() throws IOException {
        this.closeOutputStream(this.headerDataOutputStream);
        this.closeFile(this.messageFileWriter);
        this.closeFile(this.messageFileReader);
        this.closeFile(this.senderSequenceNumberFile);
        this.closeFile(this.targetSequenceNumberFile);
    }

    private void closeFile(RandomAccessFile file) throws IOException {
        if (file != null) {
            file.close();
        }
    }

    private void closeOutputStream(OutputStream stream) throws IOException {
        if (stream != null) {
            stream.close();
        }
    }

    public void deleteFiles() throws IOException {
        this.close();
        this.deleteFile(this.headerFileName);
        this.deleteFile(this.msgFileName);
        this.deleteFile(this.senderSeqNumFileName);
        this.deleteFile(this.targetSeqNumFileName);
        this.deleteFile(this.sessionFileName);
    }

    private void deleteFile(String fileName) throws IOException {
        File file = new File(fileName);
        if (file.exists() && !file.delete()) {
            System.err.println("File delete failed: " + fileName);
        }
    }

    @Override
    public int getNextSenderMsgSeqNum() throws IOException {
        return this.cache.getNextSenderMsgSeqNum();
    }

    @Override
    public int getNextTargetMsgSeqNum() throws IOException {
        return this.cache.getNextTargetMsgSeqNum();
    }

    @Override
    public void setNextSenderMsgSeqNum(int next) throws IOException {
        this.cache.setNextSenderMsgSeqNum(next);
        this.storeSenderSequenceNumber();
    }

    @Override
    public void setNextTargetMsgSeqNum(int next) throws IOException {
        this.cache.setNextTargetMsgSeqNum(next);
        this.storeTargetSequenceNumber();
    }

    @Override
    public void incrNextSenderMsgSeqNum() throws IOException {
        this.cache.incrNextSenderMsgSeqNum();
        this.storeSenderSequenceNumber();
    }

    @Override
    public void incrNextTargetMsgSeqNum() throws IOException {
        this.cache.incrNextTargetMsgSeqNum();
        this.storeTargetSequenceNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(int startSequence, int endSequence, Collection<String> messages) throws IOException {
        HashSet<Integer> uncachedOffsetMsgIds = new HashSet<Integer>();
        TreeMap<Integer, String> messagesFound = new TreeMap<Integer, String>();
        for (int i = startSequence; i <= endSequence; ++i) {
            String message = this.getMessage(i);
            if (message != null) {
                messagesFound.put(i, message);
                continue;
            }
            uncachedOffsetMsgIds.add(i);
        }
        if (!uncachedOffsetMsgIds.isEmpty()) {
            File headerFile = new File(this.headerFileName);
            DataInputStream headerDataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(headerFile)));
            try {
                while (headerDataInputStream.available() > 0) {
                    String message;
                    int sequenceNumber = headerDataInputStream.readInt();
                    long offset = headerDataInputStream.readLong();
                    int size = headerDataInputStream.readInt();
                    if (uncachedOffsetMsgIds.remove(sequenceNumber) && (message = this.getMessage(new long[]{offset, size}, sequenceNumber)) != null) {
                        messagesFound.put(sequenceNumber, message);
                    }
                    if (!uncachedOffsetMsgIds.isEmpty()) continue;
                    break;
                }
            }
            finally {
                headerDataInputStream.close();
            }
        }
        messages.addAll(messagesFound.values());
    }

    public boolean get(int sequence, String message) throws IOException {
        throw new UnsupportedOperationException("not supported");
    }

    private String getMessage(int i) throws IOException {
        long[] offsetAndSize;
        String message = null;
        if (this.messageIndex != null && (offsetAndSize = this.messageIndex.get(i)) != null) {
            message = this.getMessage(offsetAndSize, i);
        }
        return message;
    }

    private String getMessage(long[] offsetAndSize, int i) throws IOException {
        long offset = offsetAndSize[0];
        this.messageFileReader.seek(offset);
        int size = (int)offsetAndSize[1];
        byte[] data = new byte[size];
        int sizeRead = this.messageFileReader.read(data);
        if (sizeRead != size) {
            throw new IOException("Truncated input while reading message: messageIndex=" + i + ", offset=" + offset + ", expected size=" + size + ", size read from file=" + sizeRead);
        }
        String message = new String(data, this.charsetEncoding);
        this.messageFileReader.seek(this.messageFileReader.length());
        return message;
    }

    @Override
    public boolean set(int sequence, String message) throws IOException {
        long offset = this.messageFileWriter.getFilePointer();
        int size = message.length();
        if (this.messageIndex != null) {
            this.updateMessageIndex(Long.valueOf(sequence), new long[]{offset, size});
        }
        this.headerDataOutputStream.writeInt(sequence);
        this.headerDataOutputStream.writeLong(offset);
        this.headerDataOutputStream.writeInt(size);
        this.headerDataOutputStream.flush();
        if (this.syncWrites) {
            this.headerFileOutputStream.getFD().sync();
        }
        this.messageFileWriter.write(message.getBytes(CharsetSupport.getCharset()));
        return true;
    }

    private void storeSenderSequenceNumber() throws IOException {
        this.senderSequenceNumberFile.seek(0L);
        this.senderSequenceNumberFile.writeUTF(NOSYNC_OPTION + this.cache.getNextSenderMsgSeqNum());
    }

    private void storeTargetSequenceNumber() throws IOException {
        this.targetSequenceNumberFile.seek(0L);
        this.targetSequenceNumberFile.writeUTF(NOSYNC_OPTION + this.cache.getNextTargetMsgSeqNum());
    }

    String getHeaderFileName() {
        return this.headerFileName;
    }

    String getMsgFileName() {
        return this.msgFileName;
    }

    String getSeqNumSenderFileName() {
        return this.senderSeqNumFileName;
    }

    String getSeqNumTargetFileName() {
        return this.targetSeqNumFileName;
    }

    @Override
    public void refresh() throws IOException {
        this.initialize(false);
    }

    @Override
    public void reset() throws IOException {
        this.initialize(true);
    }
}

