/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.logicalcobwebs.proxool.ProxoolDataSource;
import org.quickfixj.QFJException;
import org.slf4j.LoggerFactory;
import quickfix.ConfigError;
import quickfix.FieldConvertError;
import quickfix.LogUtil;
import quickfix.SessionID;
import quickfix.SessionSettings;

class JdbcUtil {
    static final String CONNECTION_POOL_ALIAS = "quickfixj";
    private static Map<String, ProxoolDataSource> dataSources = new ConcurrentHashMap<String, ProxoolDataSource>();
    private static int dataSourceCounter = 1;

    JdbcUtil() {
    }

    static DataSource getDataSource(SessionSettings settings, SessionID sessionID) throws ConfigError, FieldConvertError {
        if (settings.isSetting(sessionID, "JdbcDataSourceName")) {
            String jndiName = settings.getString(sessionID, "JdbcDataSourceName");
            try {
                return (DataSource)new InitialContext().lookup(jndiName);
            }
            catch (NamingException e) {
                throw new ConfigError(e);
            }
        }
        String jdbcDriver = settings.getString(sessionID, "JdbcDriver");
        String connectionURL = settings.getString(sessionID, "JdbcURL");
        String user = settings.getString(sessionID, "JdbcUser");
        String password = settings.getString(sessionID, "JdbcPassword");
        return JdbcUtil.getDataSource(jdbcDriver, connectionURL, user, password, true);
    }

    static synchronized DataSource getDataSource(String jdbcDriver, String connectionURL, String user, String password, boolean cache) {
        ProxoolDataSource ds;
        String key = jdbcDriver + "#" + connectionURL + "#" + user + "#" + password;
        ProxoolDataSource proxoolDataSource = ds = cache ? dataSources.get(key) : null;
        if (ds == null) {
            ds = new ProxoolDataSource("quickfixj-" + dataSourceCounter++);
            ds.setDriver(jdbcDriver);
            ds.setDriverUrl(connectionURL);
            ds.setDelegateProperties("user=" + user + "," + (password != null && !"".equals(password) ? "password=" + password : ""));
            ds.setUser(user);
            ds.setPassword(password);
            JdbcUtil.setMaximumActiveTime(ds, 5000L);
            ds.setMaximumConnectionLifetime(28800000);
            ds.setMaximumConnectionCount(10);
            ds.setSimultaneousBuildThrottle(10);
            if (cache) {
                dataSources.put(key, ds);
            }
        }
        return ds;
    }

    private static void setMaximumActiveTime(ProxoolDataSource ds, long ms) {
        String methodName = "setMaximumActiveTime";
        Method setter = null;
        try {
            setter = ds.getClass().getMethod(methodName, Long.TYPE);
        }
        catch (NoSuchMethodException e) {
            try {
                setter = ds.getClass().getMethod(methodName, Integer.TYPE);
            }
            catch (NoSuchMethodException e1) {
                // empty catch block
            }
        }
        if (setter != null) {
            try {
                setter.invoke((Object)ds, (int)ms);
            }
            catch (Exception e) {
                throw new QFJException(e);
            }
        } else {
            LoggerFactory.getLogger(LogUtil.class).warn("Couldn't set maximum active time on Proxool data source");
        }
    }

    static void close(SessionID sessionID, Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                LogUtil.logThrowable(sessionID, e.getMessage(), (Throwable)e);
            }
        }
    }

    static void close(SessionID sessionID, PreparedStatement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LogUtil.logThrowable(sessionID, e.getMessage(), (Throwable)e);
            }
        }
    }

    static void close(SessionID sessionID, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LogUtil.logThrowable(sessionID, e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean determineSessionIdSupport(DataSource dataSource, String tableName) throws SQLException {
        Connection connection = dataSource.getConnection();
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String columnName = "sendersubid";
            boolean bl = JdbcUtil.isColumn(metaData, tableName.toUpperCase(), columnName.toUpperCase()) || JdbcUtil.isColumn(metaData, tableName, columnName);
            return bl;
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isColumn(DatabaseMetaData metaData, String tableName, String columnName) throws SQLException {
        ResultSet columns = metaData.getColumns(null, null, tableName, columnName);
        try {
            boolean bl = columns.next();
            return bl;
        }
        finally {
            columns.close();
        }
    }

    static String getIDWhereClause(boolean isExtendedSessionID) {
        return isExtendedSessionID ? "beginstring=? and sendercompid=? and sendersubid=? and senderlocid=? and targetcompid=? and targetsubid=? and targetlocid=? and session_qualifier=? " : "beginstring=? and sendercompid=? and targetcompid=? and session_qualifier=? ";
    }

    static String getIDColumns(boolean isExtendedSessionID) {
        return isExtendedSessionID ? "beginstring,sendercompid,sendersubid,senderlocid,targetcompid,targetsubid,targetlocid,session_qualifier" : "beginstring,sendercompid,targetcompid,session_qualifier";
    }

    static String getIDPlaceholders(boolean isExtendedSessionID) {
        return isExtendedSessionID ? "?,?,?,?,?,?,?,?" : "?,?,?,?";
    }

    static int setSessionIdParameters(SessionID sessionID, PreparedStatement query, int offset, boolean isExtendedSessionID, String defaultSqlValue) throws SQLException {
        if (isExtendedSessionID) {
            query.setString(offset++, JdbcUtil.getSqlValue(sessionID.getBeginString(), defaultSqlValue));
            query.setString(offset++, JdbcUtil.getSqlValue(sessionID.getSenderCompID(), defaultSqlValue));
            query.setString(offset++, JdbcUtil.getSqlValue(sessionID.getSenderSubID(), defaultSqlValue));
            query.setString(offset++, JdbcUtil.getSqlValue(sessionID.getSenderLocationID(), defaultSqlValue));
            query.setString(offset++, JdbcUtil.getSqlValue(sessionID.getTargetCompID(), defaultSqlValue));
            query.setString(offset++, JdbcUtil.getSqlValue(sessionID.getTargetSubID(), defaultSqlValue));
            query.setString(offset++, JdbcUtil.getSqlValue(sessionID.getTargetLocationID(), defaultSqlValue));
            query.setString(offset++, JdbcUtil.getSqlValue(sessionID.getSessionQualifier(), defaultSqlValue));
        } else {
            query.setString(offset++, JdbcUtil.getSqlValue(sessionID.getBeginString(), defaultSqlValue));
            query.setString(offset++, JdbcUtil.getSqlValue(sessionID.getSenderCompID(), defaultSqlValue));
            query.setString(offset++, JdbcUtil.getSqlValue(sessionID.getTargetCompID(), defaultSqlValue));
            query.setString(offset++, JdbcUtil.getSqlValue(sessionID.getSessionQualifier(), defaultSqlValue));
        }
        return offset;
    }

    private static String getSqlValue(String javaValue, String defaultSqlValue) {
        return !"".equals(javaValue) ? javaValue : defaultSqlValue;
    }
}

