/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerSupport {
    private final List<Object> listeners = new CopyOnWriteArrayList<Object>();
    private final Object multicaster;

    public ListenerSupport(Class<?> listenerClass) {
        this.multicaster = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{listenerClass}, (InvocationHandler)new ListenerInvocationHandler());
    }

    public Object getMulticaster() {
        return this.multicaster;
    }

    public void addListener(Object listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Object listener) {
        this.listeners.remove(listener);
    }

    private class ListenerInvocationHandler
    implements InvocationHandler {
        private ListenerInvocationHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("toString") && args.length == 0) {
                return this.getClass().getSimpleName() + "@" + System.identityHashCode(proxy);
            }
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke(proxy, args);
            }
            for (Object listener : ListenerSupport.this.listeners) {
                method.invoke(listener, args);
            }
            return null;
        }
    }
}

