/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import quickfix.FieldNotFound;
import quickfix.IncorrectTagValue;
import quickfix.Message;
import quickfix.SessionID;
import quickfix.UnsupportedMessageType;

public class MessageCracker {
    private Map<Class<?>, Invoker> invokers = new HashMap();

    protected MessageCracker() {
        this.initialize(this);
    }

    public MessageCracker(Object messageHandler) {
        this.initialize(messageHandler);
    }

    public void initialize(Object messageHandler) {
        Class<?> handlerClass = messageHandler.getClass();
        for (Method method : handlerClass.getMethods()) {
            if (!this.isHandlerMethod(method)) continue;
            Class<?> messageClass = method.getParameterTypes()[0];
            method.setAccessible(true);
            Invoker invoker = new Invoker(messageHandler, method);
            Invoker existingInvoker = this.invokers.get(messageClass);
            if (existingInvoker != null) {
                throw new RedundantHandlerException(messageClass, existingInvoker.getMethod(), method);
            }
            this.invokers.put(messageClass, invoker);
        }
    }

    private boolean isHandlerMethod(Method method) {
        int modifiers = method.getModifiers();
        Class<?>[] parameterTypes = method.getParameterTypes();
        return !Modifier.isPrivate(modifiers) && this.matchesConventionOrAnnotation(method) && parameterTypes.length == 2 && Message.class.isAssignableFrom(parameterTypes[0]) && parameterTypes[1] == SessionID.class;
    }

    private boolean matchesConventionOrAnnotation(Method method) {
        return method.getName().equals("onMessage") || method.isAnnotationPresent(Handler.class);
    }

    public void crack(Message message, SessionID sessionID) throws UnsupportedMessageType, FieldNotFound, IncorrectTagValue {
        Invoker invoker = this.invokers.get(message.getClass());
        if (invoker != null) {
            try {
                invoker.Invoke(message, sessionID);
            }
            catch (InvocationTargetException ite) {
                try {
                    throw ite.getTargetException();
                }
                catch (UnsupportedMessageType e) {
                    throw e;
                }
                catch (FieldNotFound e) {
                    throw e;
                }
                catch (IncorrectTagValue e) {
                    throw e;
                }
                catch (Throwable t) {
                    this.propagate(t);
                }
            }
            catch (Exception e) {
                this.propagate(e);
            }
        } else {
            this.onMessage(message, sessionID);
        }
    }

    private void propagate(Throwable e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new RuntimeException(e);
    }

    protected void onMessage(Message message, SessionID sessionID) throws FieldNotFound, UnsupportedMessageType, IncorrectTagValue {
        throw new UnsupportedMessageType();
    }

    private class Invoker {
        private final Object target;
        private final Method method;

        public Invoker(Object target, Method method) {
            this.target = target;
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }

        public void Invoke(Message message, SessionID sessionID) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.method.invoke(this.target, message, sessionID);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RedundantHandlerException
    extends RuntimeException {
        private final Class<?> messageClass;
        private final Method originalMethod;
        private final Method redundantMethod;

        public RedundantHandlerException(Class<?> messageClass, Method originalMethod, Method redundantMethod) {
            this.messageClass = messageClass;
            this.originalMethod = originalMethod;
            this.redundantMethod = redundantMethod;
        }

        @Override
        public String toString() {
            return "Duplicate handler method for " + this.messageClass + ", orginal method is " + this.originalMethod + ", redundant method is " + this.redundantMethod;
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Handler {
    }
}

