/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.AbstractLog;
import quickfix.LocationAwareLogFactory;
import quickfix.Log;
import quickfix.SLF4JLog;
import quickfix.SessionID;
import quickfix.SessionSettings;

public class SLF4JLogFactory
implements LocationAwareLogFactory {
    public static final String SETTING_EVENT_CATEGORY = "SLF4JLogEventCategory";
    public static final String SETTING_ERROR_EVENT_CATEGORY = "SLF4JLogErrorEventCategory";
    public static final String SETTING_INMSG_CATEGORY = "SLF4JLogIncomingMessageCategory";
    public static final String SETTING_OUTMSG_CATEGORY = "SLF4JLogOutgoingMessageCategory";
    public static final String SETTING_PREPEND_SESSION_ID = "SLF4JLogPrependSessionID";
    public static final String SETTING_LOG_HEARTBEATS = "SLF4JLogHeartbeats";
    private final SessionSettings settings;

    public SLF4JLogFactory(SessionSettings settings) {
        this.settings = settings;
    }

    public Log create(SessionID sessionID) {
        return this.create(sessionID, AbstractLog.class.getName());
    }

    public Log create(SessionID sessionID, String callerFQCN) {
        String eventCategory = null;
        String errorEventCategory = null;
        String incomingMsgCategory = null;
        String outgoingMsgCategory = null;
        boolean prependSessionID = true;
        boolean logHeartbeats = true;
        try {
            if (this.settings.isSetting(sessionID, SETTING_EVENT_CATEGORY)) {
                eventCategory = this.settings.getString(sessionID, SETTING_EVENT_CATEGORY);
            }
            if (this.settings.isSetting(sessionID, SETTING_ERROR_EVENT_CATEGORY)) {
                errorEventCategory = this.settings.getString(sessionID, SETTING_ERROR_EVENT_CATEGORY);
            }
            if (this.settings.isSetting(sessionID, SETTING_INMSG_CATEGORY)) {
                incomingMsgCategory = this.settings.getString(sessionID, SETTING_INMSG_CATEGORY);
            }
            if (this.settings.isSetting(sessionID, SETTING_OUTMSG_CATEGORY)) {
                outgoingMsgCategory = this.settings.getString(sessionID, SETTING_OUTMSG_CATEGORY);
            }
            if (this.settings.isSetting(sessionID, SETTING_PREPEND_SESSION_ID)) {
                prependSessionID = this.settings.getBool(sessionID, SETTING_PREPEND_SESSION_ID);
            }
            if (this.settings.isSetting(sessionID, SETTING_LOG_HEARTBEATS)) {
                logHeartbeats = this.settings.getBool(sessionID, SETTING_LOG_HEARTBEATS);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new SLF4JLog(sessionID, eventCategory, errorEventCategory, incomingMsgCategory, outgoingMsgCategory, prependSessionID, logHeartbeats, callerFQCN);
    }

    public Log create() {
        throw new UnsupportedOperationException();
    }
}

