/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.ConfigError;
import quickfix.Dictionary;
import quickfix.FieldConvertError;
import quickfix.SessionID;
import quickfix.field.converter.BooleanConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionSettings {
    private static final Logger log = LoggerFactory.getLogger(SessionSettings.class);
    private static final SessionID DEFAULT_SESSION_ID = new SessionID("DEFAULT", "", "");
    private static final String SESSION_SECTION_NAME = "session";
    private static final String DEFAULT_SECTION_NAME = "default";
    public static final String BEGINSTRING = "BeginString";
    public static final String SENDERCOMPID = "SenderCompID";
    public static final String SENDERSUBID = "SenderSubID";
    public static final String SENDERLOCID = "SenderLocationID";
    public static final String TARGETCOMPID = "TargetCompID";
    public static final String TARGETSUBID = "TargetSubID";
    public static final String TARGETLOCID = "TargetLocationID";
    public static final String SESSION_QUALIFIER = "SessionQualifier";
    private static final String NEWLINE = "\r\n";
    private Properties variableValues = System.getProperties();
    private final HashMap<SessionID, Properties> sections = new HashMap();
    private final Pattern variablePattern = Pattern.compile("\\$\\{(.+?)}");

    public SessionSettings() {
        this.sections.put(DEFAULT_SESSION_ID, new Properties());
    }

    public SessionSettings(String filename) throws ConfigError {
        this();
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(filename);
        if (in == null) {
            try {
                in = new FileInputStream(filename);
            }
            catch (IOException e) {
                throw new ConfigError(e.getMessage());
            }
        }
        this.load(in);
    }

    public SessionSettings(InputStream stream) throws ConfigError {
        this();
        this.load(stream);
    }

    public String getString(String key) throws ConfigError, FieldConvertError {
        return this.getString(DEFAULT_SESSION_ID, key);
    }

    public String getString(SessionID sessionID, String key) throws ConfigError, FieldConvertError {
        String value = this.interpolate(this.getSessionProperties(sessionID).getProperty(key));
        if (value == null) {
            throw new ConfigError(key + " not defined");
        }
        return value;
    }

    public Properties getSessionProperties(SessionID sessionID, boolean includeDefaults) throws ConfigError {
        Properties p = this.sections.get(sessionID);
        if (p == null) {
            throw new ConfigError("Session not found");
        }
        if (includeDefaults) {
            Properties mergedProperties = new Properties();
            mergedProperties.putAll((Map<?, ?>)this.sections.get(DEFAULT_SESSION_ID));
            mergedProperties.putAll((Map<?, ?>)p);
            return mergedProperties;
        }
        return p;
    }

    public Properties getSessionProperties(SessionID sessionID) throws ConfigError {
        return this.getSessionProperties(sessionID, false);
    }

    public Properties getDefaultProperties() {
        try {
            return this.getSessionProperties(DEFAULT_SESSION_ID);
        }
        catch (ConfigError e) {
            return new Properties();
        }
    }

    public long getLong(String key) throws ConfigError, FieldConvertError {
        return this.getLong(DEFAULT_SESSION_ID, key);
    }

    public long getLong(SessionID sessionID, String key) throws ConfigError, FieldConvertError {
        try {
            return Long.parseLong(this.getString(sessionID, key));
        }
        catch (NumberFormatException e) {
            throw new FieldConvertError(e.getMessage());
        }
    }

    private Properties getOrCreateSessionProperties(SessionID sessionID) {
        Properties p = this.sections.get(sessionID);
        if (p == null) {
            p = new Properties(this.sections.get(DEFAULT_SESSION_ID));
            this.sections.put(sessionID, p);
        }
        return p;
    }

    public double getDouble(String key) throws ConfigError, FieldConvertError {
        return this.getDouble(DEFAULT_SESSION_ID, key);
    }

    public double getDouble(SessionID sessionID, String key) throws ConfigError, FieldConvertError {
        try {
            return Double.parseDouble(this.getString(sessionID, key));
        }
        catch (NumberFormatException e) {
            throw new FieldConvertError(e.getMessage());
        }
    }

    public boolean getBool(String key) throws ConfigError, FieldConvertError {
        return this.getBool(DEFAULT_SESSION_ID, key);
    }

    public boolean getBool(SessionID sessionID, String key) throws ConfigError, FieldConvertError {
        try {
            return BooleanConverter.convert(this.getString(sessionID, key));
        }
        catch (FieldConvertError e) {
            throw new ConfigError(e);
        }
    }

    public void setString(SessionID sessionID, String key, String value) {
        this.getOrCreateSessionProperties(sessionID).setProperty(key, value.trim());
    }

    public void setLong(SessionID sessionID, String key, long value) {
        this.getOrCreateSessionProperties(sessionID).setProperty(key, Long.toString(value));
    }

    public void setDouble(SessionID sessionID, String key, double value) {
        this.getOrCreateSessionProperties(sessionID).setProperty(key, Double.toString(value));
    }

    public void setBool(SessionID sessionID, String key, boolean value) {
        this.getOrCreateSessionProperties(sessionID).setProperty(key, BooleanConverter.convert(value));
    }

    public Iterator<SessionID> sectionIterator() {
        HashSet<SessionID> nondefaultSessions = new HashSet<SessionID>(this.sections.keySet());
        nondefaultSessions.remove(DEFAULT_SESSION_ID);
        return nondefaultSessions.iterator();
    }

    private void load(InputStream inputStream) throws ConfigError {
        try {
            Properties currentSection = null;
            String currentSectionId = null;
            Tokenizer tokenizer = new Tokenizer();
            InputStreamReader reader = new InputStreamReader(inputStream);
            Tokenizer.Token token = tokenizer.getToken(reader);
            while (token != null) {
                if (token.getType() == 4) {
                    this.storeSection(currentSectionId, currentSection);
                    if (token.getValue().equalsIgnoreCase(DEFAULT_SECTION_NAME)) {
                        currentSectionId = DEFAULT_SECTION_NAME;
                        currentSection = this.getSessionProperties(DEFAULT_SESSION_ID);
                    } else if (token.getValue().equalsIgnoreCase(SESSION_SECTION_NAME)) {
                        currentSectionId = SESSION_SECTION_NAME;
                        currentSection = new Properties(this.getSessionProperties(DEFAULT_SESSION_ID));
                    }
                } else if (token.getType() == 2) {
                    Tokenizer.Token valueToken = tokenizer.getToken(reader);
                    if (currentSection != null && token != null) {
                        String value = this.interpolate(valueToken.getValue());
                        currentSection.put(token.getValue(), value);
                    }
                }
                token = tokenizer.getToken(reader);
            }
            this.storeSection(currentSectionId, currentSection);
        }
        catch (IOException e) {
            ConfigError configError = new ConfigError(e.getMessage());
            configError.fillInStackTrace();
            throw configError;
        }
    }

    private void storeSection(String currentSectionId, Properties currentSection) {
        if (currentSectionId != null && currentSectionId.equals(SESSION_SECTION_NAME)) {
            SessionID sessionId = new SessionID(currentSection.getProperty(BEGINSTRING), currentSection.getProperty(SENDERCOMPID), currentSection.getProperty(SENDERSUBID), currentSection.getProperty(SENDERLOCID), currentSection.getProperty(TARGETCOMPID), currentSection.getProperty(TARGETSUBID), currentSection.getProperty(TARGETLOCID), currentSection.getProperty(SESSION_QUALIFIER));
            this.sections.put(sessionId, currentSection);
            currentSectionId = null;
            currentSection = null;
        }
    }

    public boolean isSetting(String key) {
        return this.isSetting(DEFAULT_SESSION_ID, key);
    }

    public boolean isSetting(SessionID sessionID, String key) {
        return this.getOrCreateSessionProperties(sessionID).getProperty(key) != null;
    }

    public void removeSetting(SessionID sessionID, String key) {
        this.getOrCreateSessionProperties(sessionID).remove(key);
    }

    private String interpolate(String value) {
        if (value == null || value.indexOf(36) == -1) {
            return value;
        }
        StringBuffer buffer = new StringBuffer();
        Matcher m = this.variablePattern.matcher(value);
        while (m.find()) {
            String variable;
            String variableValue;
            if (m.start() > 0 && value.charAt(m.start() - 1) == '\\' || (variableValue = this.variableValues.getProperty(variable = m.group(1))) == null) continue;
            m.appendReplacement(buffer, variableValue);
        }
        m.appendTail(buffer);
        return buffer.toString();
    }

    public void setVariableValues(Properties variableValues) {
        this.variableValues = variableValues;
    }

    public void set(Map<Object, Object> defaults) {
        this.getOrCreateSessionProperties(DEFAULT_SESSION_ID).putAll(defaults);
    }

    public void setBool(String key, boolean value) {
        this.setBool(DEFAULT_SESSION_ID, key, value);
    }

    public void setDouble(String key, double value) {
        this.setDouble(DEFAULT_SESSION_ID, key, value);
    }

    public void setLong(String key, long value) {
        this.setLong(DEFAULT_SESSION_ID, key, value);
    }

    public void setString(String key, String value) {
        this.setString(DEFAULT_SESSION_ID, key, value.trim());
    }

    public int size() {
        return this.sections.size() - 1;
    }

    public Dictionary get(SessionID sessionID) throws ConfigError {
        return new Dictionary(null, this.getSessionProperties(sessionID));
    }

    public void set(SessionID sessionID, Dictionary dictionary) throws ConfigError {
        Properties p = this.getOrCreateSessionProperties(sessionID);
        p.clear();
        p.putAll(dictionary.toMap());
    }

    public Dictionary get() {
        return new Dictionary(null, this.getDefaultProperties());
    }

    public void set(Dictionary dictionary) throws ConfigError {
        this.getDefaultProperties().putAll(dictionary.toMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toString(PrintWriter writer) {
        try {
            this.writeSection("[DEFAULT]", writer, this.getDefaultProperties());
            Iterator<SessionID> s = this.sectionIterator();
            while (s.hasNext()) {
                try {
                    this.writeSection("[SESSION]", writer, this.getSessionProperties(s.next()));
                }
                catch (ConfigError e) {
                    log.error("Invalid session", (Throwable)e);
                }
            }
        }
        finally {
            writer.flush();
        }
    }

    public void toStream(OutputStream out) {
        this.toString(new PrintWriter(new OutputStreamWriter(out)));
    }

    private void writeSection(String sectionName, PrintWriter writer, Properties properties) {
        writer.println(sectionName);
        for (String string : properties.keySet()) {
            writer.print(string);
            writer.print("=");
            writer.println(properties.getProperty(string));
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        this.toString(new PrintWriter(writer));
        return writer.toString();
    }

    public static int[] parseSettingReconnectInterval(String raw) {
        if (raw == null || raw.length() == 0) {
            return null;
        }
        String multiplierCharacter = raw.contains("*") ? "\\*" : "x";
        String[] data = raw.split(";");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String multi : data) {
            int secs;
            int times;
            String[] timesSec = multi.split(multiplierCharacter);
            try {
                if (timesSec.length > 1) {
                    times = Integer.parseInt(timesSec[0]);
                    secs = Integer.parseInt(timesSec[1]);
                } else {
                    times = 1;
                    secs = Integer.parseInt(timesSec[0]);
                }
            }
            catch (NumberFormatException e) {
                throw new InvalidParameterException("Invalid number '" + multi + "' in '" + raw + "'. Expected format: [<multiplier>x]<seconds>;[<multiplier>x]<seconds>;...");
            }
            for (int ii = 0; ii != times; ++ii) {
                result.add(secs);
            }
        }
        int[] ret = new int[result.size()];
        int ii = 0;
        for (Integer sec : result) {
            ret[ii++] = sec;
        }
        return ret;
    }

    public static Set<InetAddress> parseRemoteAddresses(String raw) {
        if (raw == null || raw.length() == 0) {
            return null;
        }
        String[] data = raw.split(",");
        HashSet<InetAddress> result = new HashSet<InetAddress>();
        for (String multi : data) {
            try {
                result.add(InetAddress.getByName(multi));
            }
            catch (UnknownHostException e) {
                log.error("Ignored unknown host : " + multi, (Throwable)e);
            }
        }
        return result;
    }

    private static class Tokenizer {
        public static final int ID_TOKEN = 2;
        public static final int VALUE_TOKEN = 3;
        public static final int SECTION_TOKEN = 4;
        private char ch = '\u0000';
        private final StringBuffer sb = new StringBuffer();

        private Tokenizer() {
        }

        private Token getToken(Reader reader) throws IOException {
            if (this.ch == '\u0000') {
                this.ch = this.nextCharacter(reader);
            }
            this.skipWhitespace(reader);
            if (this.isLabelCharacter(this.ch)) {
                this.sb.setLength(0);
                do {
                    this.sb.append(this.ch);
                    this.ch = this.nextCharacter(reader);
                } while (this.isLabelCharacter(this.ch));
                return new Token(2, this.sb.toString());
            }
            if (this.ch == '=') {
                this.ch = this.nextCharacter(reader);
                this.sb.setLength(0);
                if (this.isValueCharacter(this.ch)) {
                    do {
                        this.sb.append(this.ch);
                        this.ch = this.nextCharacter(reader);
                    } while (this.isValueCharacter(this.ch));
                }
                return new Token(3, this.sb.toString().trim());
            }
            if (this.ch == '[') {
                this.ch = this.nextCharacter(reader);
                Token id = this.getToken(reader);
                this.ch = this.nextCharacter(reader);
                return new Token(4, id.getValue());
            }
            if (this.ch == '#') {
                do {
                    this.ch = this.nextCharacter(reader);
                } while (this.isValueCharacter(this.ch));
                return this.getToken(reader);
            }
            return null;
        }

        private boolean isNewLineCharacter(char ch) {
            return SessionSettings.NEWLINE.indexOf(ch) != -1;
        }

        private boolean isLabelCharacter(char ch) {
            return !this.isEndOfStream(ch) && "[]=#".indexOf(ch) == -1;
        }

        private boolean isValueCharacter(char ch) {
            return !this.isEndOfStream(ch) && !this.isNewLineCharacter(ch);
        }

        private boolean isEndOfStream(char ch) {
            return (byte)ch == -1;
        }

        private char nextCharacter(Reader reader) throws IOException {
            return (char)reader.read();
        }

        private void skipWhitespace(Reader reader) throws IOException {
            if (Character.isWhitespace(this.ch)) {
                do {
                    this.ch = this.nextCharacter(reader);
                } while (Character.isWhitespace(this.ch));
            }
        }

        private static class Token {
            private final int type;
            private final String value;

            public Token(int type, String value) {
                this.type = type;
                this.value = value;
            }

            public int getType() {
                return this.type;
            }

            public String getValue() {
                return this.value;
            }

            public String toString() {
                return this.type + ": " + this.value;
            }
        }
    }
}

