/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.Application;
import quickfix.ConfigError;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.RuntimeError;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionSettings;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.SingleThreadedEventHandlingStrategy;
import quickfix.mina.acceptor.AbstractSocketAcceptor;

public class SocketAcceptor
extends AbstractSocketAcceptor {
    private Boolean isStarted = Boolean.FALSE;
    private final Object lock = new Object();
    private SingleThreadedEventHandlingStrategy eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this);

    public SocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, logFactory, messageFactory);
    }

    public SocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, messageFactory);
    }

    public SocketAcceptor(SessionFactory sessionFactory, SessionSettings settings) throws ConfigError {
        super(settings, sessionFactory);
    }

    public void block() throws ConfigError, RuntimeError {
        this.initialize();
        this.eventHandlingStrategy.block();
    }

    public void start() throws ConfigError, RuntimeError {
        this.initialize();
        this.eventHandlingStrategy.blockInThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws ConfigError {
        Object object = this.lock;
        synchronized (object) {
            if (this.isStarted.equals(Boolean.FALSE)) {
                this.startAcceptingConnections();
            }
            this.isStarted = Boolean.TRUE;
        }
    }

    public void stop() {
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean forceDisconnect) {
        try {
            this.eventHandlingStrategy.stopHandlingMessages();
            this.stopAcceptingConnections();
            this.logoutAllSessions(forceDisconnect);
            this.stopSessionTimer();
        }
        finally {
            Session.unregisterSessions(this.getSessions());
            this.isStarted = Boolean.FALSE;
        }
    }

    protected EventHandlingStrategy getEventHandlingStrategy() {
        return this.eventHandlingStrategy;
    }
}

