/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.Application;
import quickfix.ConfigError;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.RuntimeError;
import quickfix.ScreenLogFactory;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionSettings;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.SingleThreadedEventHandlingStrategy;
import quickfix.mina.initiator.AbstractSocketInitiator;

public class SocketInitiator
extends AbstractSocketInitiator {
    private Boolean isStarted = Boolean.FALSE;
    private final Object lock = new Object();
    private SingleThreadedEventHandlingStrategy eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this);

    public SocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, new ScreenLogFactory(settings), messageFactory);
        if (settings == null) {
            throw new ConfigError("no settings");
        }
    }

    public SocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, logFactory, messageFactory);
        if (settings == null) {
            throw new ConfigError("no settings");
        }
    }

    public SocketInitiator(SessionFactory sessionFactory, SessionSettings settings) throws ConfigError {
        super(settings, sessionFactory);
    }

    public void block() throws ConfigError, RuntimeError {
        this.initialize();
        this.eventHandlingStrategy.block();
    }

    public void start() throws ConfigError, RuntimeError {
        this.initialize();
        this.eventHandlingStrategy.blockInThread();
    }

    public void stop() {
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean forceDisconnect) {
        try {
            this.eventHandlingStrategy.stopHandlingMessages();
            this.logoutAllSessions(forceDisconnect);
            this.stopInitiators();
        }
        finally {
            Session.unregisterSessions(this.getSessions());
            this.isStarted = Boolean.FALSE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws ConfigError {
        Object object = this.lock;
        synchronized (object) {
            if (this.isStarted.equals(Boolean.FALSE)) {
                this.createSessionInitiators();
                for (Session session : this.getSessionMap().values()) {
                    Session.registerSession(session);
                }
                this.startInitiators();
                this.isStarted = Boolean.TRUE;
            }
        }
    }

    protected EventHandlingStrategy getEventHandlingStrategy() {
        return this.eventHandlingStrategy;
    }
}

