/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import quickfix.LogUtil;
import quickfix.Message;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.SessionConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPerSessionEventHandlingStrategy
implements EventHandlingStrategy {
    private static final long THREAD_WAIT_FOR_MESSAGE_MS = 250L;
    private final ConcurrentMap<SessionID, MessageDispatchingThread> dispatchers = new ConcurrentHashMap<SessionID, MessageDispatchingThread>();
    private final SessionConnector sessionConnector;

    public ThreadPerSessionEventHandlingStrategy(SessionConnector connector) {
        this.sessionConnector = connector;
    }

    @Override
    public void onMessage(Session quickfixSession, Message message) {
        MessageDispatchingThread dispatcher = (MessageDispatchingThread)this.dispatchers.get(quickfixSession.getSessionID());
        if (dispatcher == null) {
            MessageDispatchingThread temp = new MessageDispatchingThread(quickfixSession);
            dispatcher = this.dispatchers.putIfAbsent(quickfixSession.getSessionID(), temp);
            if (dispatcher == null) {
                dispatcher = temp;
            }
            this.startDispatcherThread(dispatcher);
        }
        dispatcher.enqueue(message);
    }

    @Override
    public SessionConnector getSessionConnector() {
        return this.sessionConnector;
    }

    protected void startDispatcherThread(MessageDispatchingThread dispatcher) {
        dispatcher.start();
    }

    public void stopDispatcherThreads() {
        Collection dispatchersToShutdown = this.dispatchers.values();
        for (MessageDispatchingThread dispatcher : dispatchersToShutdown) {
            dispatcher.stopDispatcher();
        }
        while (!dispatchersToShutdown.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            Iterator iterator = dispatchersToShutdown.iterator();
            while (iterator.hasNext()) {
                MessageDispatchingThread messageDispatchingThread = (MessageDispatchingThread)iterator.next();
                if (!messageDispatchingThread.isStopped()) continue;
                iterator.remove();
            }
        }
    }

    protected MessageDispatchingThread getDispatcher(SessionID sessionID) {
        return (MessageDispatchingThread)this.dispatchers.get(sessionID);
    }

    protected Message getNextMessage(BlockingQueue<Message> messages) throws InterruptedException {
        return messages.poll(250L, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getQueueSize() {
        int ret = 0;
        for (MessageDispatchingThread mdt : this.dispatchers.values()) {
            ret += mdt.getQueueSize();
        }
        return ret;
    }

    protected class MessageDispatchingThread
    extends Thread {
        private final Session quickfixSession;
        private final BlockingQueue<Message> messages;
        private volatile boolean stopped;
        private volatile boolean stopping;

        private MessageDispatchingThread(Session session) {
            super("QF/J Session dispatcher: " + session.getSessionID());
            this.messages = new LinkedBlockingQueue<Message>();
            this.quickfixSession = session;
        }

        public void enqueue(Message message) {
            try {
                this.messages.put(message);
            }
            catch (InterruptedException e) {
                this.quickfixSession.getLog().onErrorEvent(e.toString());
            }
        }

        public int getQueueSize() {
            return this.messages.size();
        }

        public void run() {
            while (!this.stopping) {
                try {
                    if (this.quickfixSession.hasResponder()) {
                        Message message = ThreadPerSessionEventHandlingStrategy.this.getNextMessage(this.messages);
                        if (message == null || !this.quickfixSession.hasResponder()) continue;
                        this.quickfixSession.next(message);
                        continue;
                    }
                    this.stopping = true;
                }
                catch (InterruptedException e) {
                    LogUtil.logThrowable(this.quickfixSession.getSessionID(), "Message dispatcher interrupted", (Throwable)e);
                    this.stopping = true;
                }
                catch (Throwable e) {
                    LogUtil.logThrowable(this.quickfixSession.getSessionID(), "Error during message processing", e);
                }
            }
            ThreadPerSessionEventHandlingStrategy.this.dispatchers.remove(this.quickfixSession.getSessionID());
            this.stopped = true;
        }

        public void stopDispatcher() {
            this.stopping = true;
            this.stopped = true;
        }

        public boolean isStopped() {
            return this.stopped;
        }
    }
}

