/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.acceptor;

import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.common.TransportType;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import quickfix.Acceptor;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.DefaultSessionFactory;
import quickfix.FieldConvertError;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.RuntimeError;
import quickfix.ScreenLogFactory;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.mina.CompositeIoFilterChainBuilder;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.NetworkingOptions;
import quickfix.mina.ProtocolFactory;
import quickfix.mina.SessionConnector;
import quickfix.mina.acceptor.AcceptorIoHandler;
import quickfix.mina.acceptor.AcceptorSessionProvider;
import quickfix.mina.message.FIXProtocolCodecFactory;
import quickfix.mina.ssl.SSLContextFactory;
import quickfix.mina.ssl.SSLSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSocketAcceptor
extends SessionConnector
implements Acceptor {
    private final Map<SocketAddress, AcceptorSessionProvider> sessionProviders = new HashMap<SocketAddress, AcceptorSessionProvider>();
    private final SessionFactory sessionFactory;
    private final Map<SocketAddress, AcceptorSocketDescriptor> socketDescriptorForAddress = new HashMap<SocketAddress, AcceptorSocketDescriptor>();
    private final Map<TransportTypeAndSSL, IoAcceptor> ioAcceptorForTransport = new HashMap<TransportTypeAndSSL, IoAcceptor>();

    protected AbstractSocketAcceptor(SessionSettings settings, SessionFactory sessionFactory) throws ConfigError {
        super(settings, sessionFactory);
        ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
        ByteBuffer.setUseDirectBuffers((boolean)false);
        this.sessionFactory = sessionFactory;
    }

    protected AbstractSocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory) throws ConfigError {
        this(application, messageStoreFactory, settings, new ScreenLogFactory(settings), messageFactory);
    }

    protected AbstractSocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory) throws ConfigError {
        this(settings, new DefaultSessionFactory(application, messageStoreFactory, logFactory, messageFactory));
    }

    protected synchronized void startAcceptingConnections() throws ConfigError {
        try {
            this.createSessions(this.getSettings());
            this.startSessionTimer();
            SessionSettings settings = this.getSettings();
            for (AcceptorSocketDescriptor socketDescriptor : this.socketDescriptorForAddress.values()) {
                SocketAddress address = socketDescriptor.getAddress();
                boolean useSSL = socketDescriptor.isUseSSL();
                IoAcceptor ioAcceptor = this.getIoAcceptor(address, useSSL);
                IoServiceConfig serviceConfig = ioAcceptor.getDefaultConfig();
                CompositeIoFilterChainBuilder ioFilterChainBuilder = new CompositeIoFilterChainBuilder(this.getIoFilterChainBuilder());
                if (useSSL) {
                    this.installSSL(socketDescriptor, ioFilterChainBuilder);
                }
                ioFilterChainBuilder.addLast("FIXCodec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new FIXProtocolCodecFactory()));
                serviceConfig.setFilterChainBuilder((IoFilterChainBuilder)ioFilterChainBuilder);
                serviceConfig.setThreadModel(ThreadModel.MANUAL);
                AcceptorSessionProvider sessionProvider = this.sessionProviders.get(address);
                if (sessionProvider == null) {
                    sessionProvider = new DefaultAcceptorSessionProvider(socketDescriptor.getAcceptedSessions());
                }
                if (serviceConfig instanceof SocketAcceptorConfig) {
                    ((SocketAcceptorConfig)serviceConfig).setDisconnectOnUnbind(false);
                }
                ioAcceptor.bind(address, (IoHandler)new AcceptorIoHandler(sessionProvider, new NetworkingOptions(settings.getDefaultProperties()), this.getEventHandlingStrategy()));
                this.log.info("Listening for connections at " + address + " for session(s) " + socketDescriptor.getAcceptedSessions().keySet());
            }
        }
        catch (FieldConvertError e) {
            throw new ConfigError(e);
        }
        catch (Exception e) {
            throw new RuntimeError(e);
        }
    }

    private void installSSL(AcceptorSocketDescriptor descriptor, CompositeIoFilterChainBuilder ioFilterChainBuilder) throws GeneralSecurityException {
        this.log.info("Installing SSL filter for " + descriptor.getAddress());
        SSLContext sslContext = SSLContextFactory.getInstance(descriptor.getKeyStoreName(), descriptor.getKeyStorePassword().toCharArray());
        SSLFilter sslFilter = new SSLFilter(sslContext);
        sslFilter.setUseClientMode(false);
        ioFilterChainBuilder.addLast("SSLFilter", (IoFilter)sslFilter);
    }

    private IoAcceptor getIoAcceptor(SocketAddress address, boolean useSSL) {
        TransportType transportType = ProtocolFactory.getAddressTransportType(address);
        TransportTypeAndSSL key = new TransportTypeAndSSL(transportType, useSSL);
        IoAcceptor ioAcceptor = this.ioAcceptorForTransport.get(key);
        if (ioAcceptor == null) {
            ioAcceptor = ProtocolFactory.createIoAcceptor(transportType);
            this.ioAcceptorForTransport.put(key, ioAcceptor);
        }
        return ioAcceptor;
    }

    private AcceptorSocketDescriptor getAcceptorSocketDescriptor(SessionSettings settings, SessionID sessionID) throws ConfigError, FieldConvertError {
        SocketAddress acceptorAddress;
        AcceptorSocketDescriptor descriptor;
        TransportType acceptTransportType = TransportType.SOCKET;
        if (settings.isSetting(sessionID, "SocketAcceptProtocol")) {
            try {
                acceptTransportType = TransportType.getInstance((String)settings.getString(sessionID, "SocketAcceptProtocol"));
            }
            catch (IllegalArgumentException e) {
                throw new ConfigError(e);
            }
        }
        boolean useSSL = false;
        String keyStoreName = null;
        String keyStorePassword = null;
        if (this.getSettings().isSetting(sessionID, "SocketUseSSL") && this.getSettings().getBool(sessionID, "SocketUseSSL")) {
            if (acceptTransportType == TransportType.SOCKET) {
                useSSL = true;
                keyStoreName = SSLSupport.getKeystoreName(this.getSettings(), sessionID);
                keyStorePassword = SSLSupport.getKeystorePasswd(this.getSettings(), sessionID);
            } else {
                this.log.warn("SSL will not be enabled for transport type=" + acceptTransportType + ", session=" + sessionID);
            }
        }
        int acceptPort = (int)settings.getLong(sessionID, "SocketAcceptPort");
        String acceptHost = null;
        if (settings.isSetting(sessionID, "SocketAcceptAddress")) {
            acceptHost = settings.getString(sessionID, "SocketAcceptAddress");
        }
        if ((descriptor = this.socketDescriptorForAddress.get(acceptorAddress = ProtocolFactory.createSocketAddress(acceptTransportType, acceptHost, acceptPort))) != null) {
            if (descriptor.isUseSSL() && !useSSL || !this.equals(descriptor.getKeyStoreName(), keyStoreName) || !this.equals(descriptor.getKeyStorePassword(), keyStorePassword)) {
                throw new ConfigError("Conflicting configurations of acceptor socket: " + acceptorAddress);
            }
        } else {
            descriptor = new AcceptorSocketDescriptor(acceptorAddress, useSSL, keyStoreName, keyStorePassword);
            this.socketDescriptorForAddress.put(acceptorAddress, descriptor);
        }
        return descriptor;
    }

    private boolean equals(Object object1, Object object2) {
        return object1 == null ? object2 == null : object1.equals(object2);
    }

    private void createSessions(SessionSettings settings) throws ConfigError, FieldConvertError {
        HashMap<SessionID, Session> allSessions = new HashMap<SessionID, Session>();
        Iterator<SessionID> i = settings.sectionIterator();
        while (i.hasNext()) {
            SessionID sessionID = i.next();
            String connectionType = settings.getString(sessionID, "ConnectionType");
            boolean isTemplate = false;
            if (settings.isSetting(sessionID, "AcceptorTemplate")) {
                isTemplate = settings.getBool(sessionID, "AcceptorTemplate");
            }
            if (!connectionType.equals("acceptor")) continue;
            AcceptorSocketDescriptor descriptor = this.getAcceptorSocketDescriptor(settings, sessionID);
            if (isTemplate) continue;
            Session session = this.sessionFactory.create(sessionID, settings);
            descriptor.acceptSession(session);
            allSessions.put(sessionID, session);
        }
        this.setSessions(allSessions);
        if (this.socketDescriptorForAddress.size() == 0) {
            throw new ConfigError("No acceptor sessions found in settings.");
        }
    }

    protected void stopAcceptingConnections() {
        for (AcceptorSocketDescriptor socketDescriptor : this.socketDescriptorForAddress.values()) {
            SocketAddress acceptorSocketAddress = socketDescriptor.getAddress();
            this.log.info("No longer accepting connections on " + acceptorSocketAddress);
            IoAcceptor ioAcceptor = this.getIoAcceptor(acceptorSocketAddress, socketDescriptor.isUseSSL());
            if (!ioAcceptor.isManaged(acceptorSocketAddress)) continue;
            ioAcceptor.unbind(acceptorSocketAddress);
        }
        this.ioAcceptorForTransport.clear();
    }

    public Collection<IoAcceptor> getEndpoints() {
        return this.ioAcceptorForTransport.values();
    }

    public Map<SessionID, SocketAddress> getAcceptorAddresses() {
        HashMap<SessionID, SocketAddress> sessionIdToAddressMap = new HashMap<SessionID, SocketAddress>();
        for (AcceptorSocketDescriptor descriptor : this.socketDescriptorForAddress.values()) {
            Iterator<SessionID> sessionIDs = descriptor.getAcceptedSessions().keySet().iterator();
            while (sessionIDs.hasNext()) {
                sessionIdToAddressMap.put(sessionIDs.next(), descriptor.getAddress());
            }
        }
        return sessionIdToAddressMap;
    }

    public void setSessionProvider(SocketAddress address, AcceptorSessionProvider provider) {
        this.sessionProviders.put(address, provider);
    }

    public int getQueueSize() {
        EventHandlingStrategy ehs = this.getEventHandlingStrategy();
        return ehs == null ? 0 : ehs.getQueueSize();
    }

    protected abstract EventHandlingStrategy getEventHandlingStrategy();

    private class TransportTypeAndSSL {
        private final TransportType transportType;
        private final boolean useSSL;

        public TransportTypeAndSSL(TransportType transportType, boolean useSSL) {
            this.transportType = transportType;
            this.useSSL = useSSL;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.transportType == null ? 0 : this.transportType.hashCode());
            result = 31 * result + (this.useSSL ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TransportTypeAndSSL other = (TransportTypeAndSSL)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.transportType == null ? other.transportType != null : !this.transportType.equals(other.transportType)) {
                return false;
            }
            return this.useSSL == other.useSSL;
        }

        private AbstractSocketAcceptor getOuterType() {
            return AbstractSocketAcceptor.this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultAcceptorSessionProvider
    implements AcceptorSessionProvider {
        private final Map<SessionID, Session> acceptorSessions;

        public DefaultAcceptorSessionProvider(Map<SessionID, Session> acceptorSessions) {
            this.acceptorSessions = acceptorSessions;
        }

        @Override
        public Session getSession(SessionID sessionID, SessionConnector ignored) {
            Session session = this.acceptorSessions.get(sessionID);
            if (session == null) {
                session = this.acceptorSessions.get(this.reduceSessionID(sessionID));
            }
            return session;
        }

        private SessionID reduceSessionID(SessionID sessionID) {
            return new SessionID(sessionID.getBeginString(), sessionID.getSenderCompID(), sessionID.getTargetCompID());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StaticAcceptorSessionProvider
    implements AcceptorSessionProvider {
        private final Map<SessionID, Session> acceptorSessions;

        public StaticAcceptorSessionProvider(Map<SessionID, Session> acceptorSessions) {
            this.acceptorSessions = acceptorSessions;
        }

        @Override
        public Session getSession(SessionID sessionID, SessionConnector connector) {
            return this.acceptorSessions.get(sessionID);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AcceptorSocketDescriptor {
        private final SocketAddress address;
        private final boolean useSSL;
        private final String keyStoreName;
        private final String keyStorePassword;
        private final Map<SessionID, Session> acceptedSessions = new HashMap<SessionID, Session>();

        public AcceptorSocketDescriptor(SocketAddress address, boolean useSSL, String keyStoreName, String keyStorePassword) {
            this.address = address;
            this.useSSL = useSSL;
            this.keyStoreName = keyStoreName;
            this.keyStorePassword = keyStorePassword;
        }

        public void acceptSession(Session session) {
            this.acceptedSessions.put(session.getSessionID(), session);
        }

        public Map<SessionID, Session> getAcceptedSessions() {
            return Collections.unmodifiableMap(this.acceptedSessions);
        }

        public SocketAddress getAddress() {
            return this.address;
        }

        public String getKeyStoreName() {
            return this.keyStoreName;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public boolean isUseSSL() {
            return this.useSSL;
        }
    }
}

