/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.acceptor;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.quickfixj.QFJException;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.DefaultSessionFactory;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.mina.SessionConnector;
import quickfix.mina.acceptor.AcceptorSessionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicAcceptorSessionProvider
implements AcceptorSessionProvider {
    public static final String WILDCARD = "*";
    private static final SessionID ANY_SESSION = new SessionID("*", "*", "*", "*", "*", "*", "*", null);
    private final List<TemplateMapping> templateMappings;
    protected final SessionSettings settings;
    protected final SessionFactory sessionFactory;

    public DynamicAcceptorSessionProvider(SessionSettings settings, SessionID templateID, Application application, MessageStoreFactory messageStoreFactory, LogFactory logFactory, MessageFactory messageFactory) {
        this(settings, Collections.singletonList(new TemplateMapping(ANY_SESSION, templateID)), application, messageStoreFactory, logFactory, messageFactory);
    }

    public DynamicAcceptorSessionProvider(SessionSettings settings, List<TemplateMapping> templateMappings, Application application, MessageStoreFactory messageStoreFactory, LogFactory logFactory, MessageFactory messageFactory) {
        this.settings = settings;
        this.templateMappings = templateMappings;
        this.sessionFactory = new DefaultSessionFactory(application, messageStoreFactory, logFactory, messageFactory);
    }

    @Override
    public synchronized Session getSession(SessionID sessionID, SessionConnector sessionConnector) {
        Session s = Session.lookupSession(sessionID);
        if (s == null) {
            try {
                SessionID templateID = this.lookupTemplateID(sessionID);
                if (templateID == null) {
                    throw new ConfigError("Unable to find a session template for " + sessionID);
                }
                SessionSettings dynamicSettings = new SessionSettings();
                this.copySettings(dynamicSettings, this.settings.getDefaultProperties());
                this.copySettings(dynamicSettings, this.settings.getSessionProperties(templateID));
                dynamicSettings.setString("BeginString", sessionID.getBeginString());
                dynamicSettings.setString("SenderCompID", sessionID.getSenderCompID());
                this.optionallySetValue(dynamicSettings, "SenderSubID", sessionID.getSenderSubID());
                this.optionallySetValue(dynamicSettings, "SenderLocationID", sessionID.getSenderLocationID());
                dynamicSettings.setString("TargetCompID", sessionID.getTargetCompID());
                this.optionallySetValue(dynamicSettings, "TargetSubID", sessionID.getTargetSubID());
                this.optionallySetValue(dynamicSettings, "TargetLocationID", sessionID.getTargetLocationID());
                s = this.sessionFactory.create(sessionID, dynamicSettings);
                if (sessionConnector != null) {
                    sessionConnector.addDynamicSession(s);
                }
            }
            catch (ConfigError e) {
                throw new QFJException(e);
            }
        }
        return s;
    }

    protected void optionallySetValue(SessionSettings dynamicSettings, String key, String value) {
        dynamicSettings.setString(key, value);
    }

    protected SessionID lookupTemplateID(SessionID sessionID) {
        for (TemplateMapping mapping : this.templateMappings) {
            if (!this.isMatching(mapping.getPattern(), sessionID)) continue;
            return mapping.getTemplateID();
        }
        return null;
    }

    private boolean isMatching(SessionID pattern, SessionID sessionID) {
        return this.isMatching(pattern.getBeginString(), sessionID.getBeginString()) && this.isMatching(pattern.getSenderCompID(), sessionID.getSenderCompID()) && this.isMatching(pattern.getSenderSubID(), sessionID.getSenderSubID()) && this.isMatching(pattern.getSenderLocationID(), sessionID.getSenderLocationID()) && this.isMatching(pattern.getTargetCompID(), sessionID.getTargetCompID()) && this.isMatching(pattern.getTargetSubID(), sessionID.getTargetSubID()) && this.isMatching(pattern.getTargetLocationID(), sessionID.getTargetLocationID());
    }

    private boolean isMatching(String pattern, String value) {
        return WILDCARD.equals(pattern) || pattern != null && pattern.equals(value);
    }

    protected void copySettings(SessionSettings settings, Properties properties) {
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            settings.setString((String)e.getKey(), e.getValue().toString());
        }
    }

    public static class TemplateMapping {
        private final SessionID pattern;
        private final SessionID templateID;

        public TemplateMapping(SessionID pattern, SessionID templateID) {
            this.pattern = pattern;
            this.templateID = templateID;
        }

        public SessionID getPattern() {
            return this.pattern;
        }

        public SessionID getTemplateID() {
            return this.templateID;
        }

        public String toString() {
            return "<" + this.pattern + "," + this.templateID + ">";
        }
    }
}

