/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.initiator;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.ConfigError;
import quickfix.LogUtil;
import quickfix.Session;
import quickfix.SystemTime;
import quickfix.mina.CompositeIoFilterChainBuilder;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.NetworkingOptions;
import quickfix.mina.ProtocolFactory;
import quickfix.mina.initiator.InitiatorIoHandler;
import quickfix.mina.message.FIXProtocolCodecFactory;
import quickfix.mina.ssl.SSLContextFactory;

public class IoSessionInitiator {
    private static final long CONNECT_POLL_TIMEOUT = 2000L;
    private final ScheduledExecutorService executor;
    private final ConnectTask reconnectTask;
    private Future<?> reconnectFuture;
    protected static final Logger log = LoggerFactory.getLogger((String)("display." + IoSessionInitiator.class.getName()));

    public IoSessionInitiator(Session fixSession, SocketAddress[] socketAddresses, SocketAddress localAddress, int[] reconnectIntervalInSeconds, ScheduledExecutorService executor, NetworkingOptions networkingOptions, EventHandlingStrategy eventHandlingStrategy, IoFilterChainBuilder userIoFilterChainBuilder, boolean sslEnabled, String keyStoreName, String keyStorePassword, String[] enableProtocole, String[] cipherSuites) throws ConfigError {
        this.executor = executor;
        long[] reconnectIntervalInMillis = new long[reconnectIntervalInSeconds.length];
        for (int ii = 0; ii != reconnectIntervalInSeconds.length; ++ii) {
            reconnectIntervalInMillis[ii] = (long)reconnectIntervalInSeconds[ii] * 1000L;
        }
        try {
            this.reconnectTask = new ConnectTask(sslEnabled, socketAddresses, localAddress, userIoFilterChainBuilder, fixSession, reconnectIntervalInMillis, networkingOptions, eventHandlingStrategy, keyStoreName, keyStorePassword, enableProtocole, cipherSuites);
        }
        catch (GeneralSecurityException e) {
            throw new ConfigError(e);
        }
        log.info("[" + fixSession.getSessionID() + "] " + Arrays.asList(socketAddresses));
    }

    synchronized void start() {
        if (this.reconnectFuture == null) {
            this.reconnectTask.getFixSession().logon();
            this.reconnectFuture = this.executor.scheduleWithFixedDelay(this.reconnectTask, 0L, 1L, TimeUnit.SECONDS);
        }
    }

    synchronized void stop() {
        if (this.reconnectFuture != null) {
            this.reconnectFuture.cancel(true);
            this.reconnectFuture = null;
        }
    }

    private static class ConnectTask
    implements Runnable {
        private final SocketAddress[] socketAddresses;
        private final SocketAddress localAddress;
        private final IoConnector ioConnector;
        private final Session fixSession;
        private final long[] reconnectIntervalInMillis;
        private String keyStoreName;
        private String keyStorePassword;
        private String[] enableProtocole;
        private String[] cipherSuites;
        private final InitiatorIoHandler ioHandler;
        private IoSession ioSession;
        private long lastReconnectAttemptTime;
        private long lastConnectTime;
        private int nextSocketAddressIndex;
        private int connectionFailureCount;
        private ConnectFuture connectFuture;

        public ConnectTask(boolean sslEnabled, SocketAddress[] socketAddresses, SocketAddress localAddress, IoFilterChainBuilder userIoFilterChainBuilder, Session fixSession, long[] reconnectIntervalInMillis, NetworkingOptions networkingOptions, EventHandlingStrategy eventHandlingStrategy, String keyStoreName, String keyStorePassword, String[] enableProtocole, String[] cipherSuites) throws ConfigError, GeneralSecurityException {
            this.socketAddresses = socketAddresses;
            this.localAddress = localAddress;
            this.fixSession = fixSession;
            this.reconnectIntervalInMillis = reconnectIntervalInMillis;
            this.keyStoreName = keyStoreName;
            this.keyStorePassword = keyStorePassword;
            this.enableProtocole = enableProtocole;
            this.cipherSuites = cipherSuites;
            this.ioConnector = ProtocolFactory.createIoConnector(socketAddresses[0]);
            CompositeIoFilterChainBuilder ioFilterChainBuilder = new CompositeIoFilterChainBuilder(userIoFilterChainBuilder);
            if (sslEnabled) {
                this.installSSLFilter(ioFilterChainBuilder);
            }
            ioFilterChainBuilder.addLast("FIXCodec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new FIXProtocolCodecFactory()));
            IoServiceConfig serviceConfig = this.ioConnector.getDefaultConfig();
            serviceConfig.setFilterChainBuilder((IoFilterChainBuilder)ioFilterChainBuilder);
            serviceConfig.setThreadModel(ThreadModel.MANUAL);
            this.ioHandler = new InitiatorIoHandler(fixSession, networkingOptions, eventHandlingStrategy);
        }

        private void installSSLFilter(CompositeIoFilterChainBuilder ioFilterChainBuilder) throws GeneralSecurityException {
            SSLFilter sslFilter = new SSLFilter(SSLContextFactory.getInstance(this.keyStoreName, this.keyStorePassword.toCharArray()));
            if (this.enableProtocole != null) {
                sslFilter.setEnabledProtocols(this.enableProtocole);
            }
            if (this.cipherSuites != null) {
                sslFilter.setEnabledCipherSuites(this.cipherSuites);
            }
            sslFilter.setUseClientMode(true);
            ioFilterChainBuilder.addLast("SSLFilter", (IoFilter)sslFilter);
        }

        public synchronized void run() {
            if (this.connectFuture == null) {
                if (this.shouldReconnect()) {
                    this.connect();
                }
            } else {
                this.pollConnectFuture();
            }
        }

        private void connect() {
            this.lastReconnectAttemptTime = SystemTime.currentTimeMillis();
            SocketAddress nextSocketAddress = this.getNextSocketAddress();
            try {
                this.connectFuture = this.localAddress == null ? this.ioConnector.connect(nextSocketAddress, (IoHandler)this.ioHandler) : this.ioConnector.connect(nextSocketAddress, this.localAddress, (IoHandler)this.ioHandler);
                this.pollConnectFuture();
            }
            catch (Throwable e) {
                this.handleConnectException(e);
            }
        }

        private void pollConnectFuture() {
            try {
                this.connectFuture.join(2000L);
                if (this.connectFuture.getSession() != null) {
                    this.ioSession = this.connectFuture.getSession();
                    this.connectionFailureCount = 0;
                    this.lastConnectTime = System.currentTimeMillis();
                    this.connectFuture = null;
                } else {
                    this.fixSession.getLog().onEvent("Pending connection not established after " + (System.currentTimeMillis() - this.lastReconnectAttemptTime) + " ms.");
                }
            }
            catch (Throwable e) {
                this.handleConnectException(e);
            }
        }

        private void handleConnectException(Throwable e) {
            ++this.connectionFailureCount;
            while (e.getCause() != null) {
                e = e.getCause();
            }
            String nextRetryMsg = " (Next retry in " + this.computeNextRetryConnectDelay() + " milliseconds)";
            if (e instanceof IOException) {
                this.fixSession.getLog().onErrorEvent(e.getClass().getName() + ": " + e + nextRetryMsg);
            } else {
                LogUtil.logThrowable(this.fixSession.getLog(), "Exception during connection" + nextRetryMsg, e);
            }
            this.connectFuture = null;
        }

        private SocketAddress getNextSocketAddress() {
            InetSocketAddress inetAddr;
            SocketAddress socketAddress = this.socketAddresses[this.nextSocketAddressIndex];
            if (socketAddress instanceof InetSocketAddress && (inetAddr = (InetSocketAddress)socketAddress).isUnresolved()) {
                this.socketAddresses[this.nextSocketAddressIndex] = socketAddress = new InetSocketAddress(inetAddr.getHostName(), inetAddr.getPort());
            }
            this.nextSocketAddressIndex = (this.nextSocketAddressIndex + 1) % this.socketAddresses.length;
            return socketAddress;
        }

        private boolean shouldReconnect() {
            return (this.ioSession == null || !this.ioSession.isConnected()) && this.isTimeForReconnect() && this.fixSession.isEnabled() && this.fixSession.isSessionTime();
        }

        private long computeNextRetryConnectDelay() {
            int index = this.connectionFailureCount - 1;
            if (index < 0) {
                index = 0;
            }
            long millis = index >= this.reconnectIntervalInMillis.length ? this.reconnectIntervalInMillis[this.reconnectIntervalInMillis.length - 1] : this.reconnectIntervalInMillis[index];
            return millis;
        }

        private boolean isTimeForReconnect() {
            return SystemTime.currentTimeMillis() - this.lastReconnectAttemptTime >= this.computeNextRetryConnectDelay();
        }

        public synchronized int getConnectionFailureCount() {
            return this.connectionFailureCount;
        }

        public synchronized long getLastReconnectAttemptTime() {
            return this.lastReconnectAttemptTime;
        }

        public synchronized long getLastConnectTime() {
            return this.lastConnectTime;
        }

        public Session getFixSession() {
            return this.fixSession;
        }
    }
}

