/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.message;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.demux.MessageDecoder;
import org.apache.mina.filter.codec.demux.MessageDecoderResult;
import org.quickfixj.CharsetSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.mina.CriticalProtocolCodecException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIXMessageDecoder
implements MessageDecoder {
    private static final String FIELD_DELIMITER = "\u0001";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final byte[] HEADER_PATTERN;
    private final byte[] CHECKSUM_PATTERN;
    private final byte[] LOGON_PATTERN;
    private static final int SEEKING_HEADER = 1;
    private static final int PARSING_LENGTH = 2;
    private static final int READING_BODY = 3;
    private static final int PARSING_CHECKSUM = 4;
    private static final int MAX_UNDECODED_DATA_LENGTH = 4096;
    private int state;
    private int bodyLength;
    private int position;
    private final String charsetEncoding;

    private void resetState() {
        this.state = 1;
        this.bodyLength = 0;
        this.position = 0;
    }

    public FIXMessageDecoder() throws UnsupportedEncodingException {
        this(CharsetSupport.getCharset(), FIELD_DELIMITER);
    }

    public FIXMessageDecoder(String charset) throws UnsupportedEncodingException {
        this(charset, FIELD_DELIMITER);
    }

    public FIXMessageDecoder(String charset, String delimiter) throws UnsupportedEncodingException {
        this.charsetEncoding = CharsetSupport.validate(charset);
        this.HEADER_PATTERN = FIXMessageDecoder.getBytes("8=FIXt.?.?" + delimiter + "9=");
        this.CHECKSUM_PATTERN = FIXMessageDecoder.getBytes("10=???" + delimiter);
        this.LOGON_PATTERN = FIXMessageDecoder.getBytes("\u000135=A" + delimiter);
        this.resetState();
    }

    public MessageDecoderResult decodable(IoSession session, ByteBuffer in) {
        BufPos bufPos = FIXMessageDecoder.indexOf(in, in.position(), this.HEADER_PATTERN);
        int headerOffset = bufPos._offset;
        return headerOffset != -1 ? MessageDecoderResult.OK : (in.remaining() > 4096 ? MessageDecoderResult.NOT_OK : MessageDecoderResult.NEED_DATA);
    }

    public MessageDecoderResult decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws ProtocolCodecException {
        int messageCount = 0;
        while (this.parseMessage(in, out)) {
            ++messageCount;
        }
        if (messageCount > 0) {
            if (this.state == 1) {
                this.position = 0;
            }
            return MessageDecoderResult.OK;
        }
        this.position -= in.position();
        return MessageDecoderResult.NEED_DATA;
    }

    private boolean parseMessage(ByteBuffer in, ProtocolDecoderOutput out) throws ProtocolCodecException {
        try {
            boolean messageFound = false;
            while (in.hasRemaining() && !messageFound) {
                if (this.state == 1) {
                    BufPos bufPos = FIXMessageDecoder.indexOf(in, this.position, this.HEADER_PATTERN);
                    int headerOffset = bufPos._offset;
                    if (headerOffset == -1) break;
                    in.position(headerOffset);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("detected header: " + this.getBufferDebugInfo(in));
                    }
                    this.position = headerOffset + bufPos._length;
                    this.state = 2;
                }
                if (this.state == 2) {
                    byte ch = 0;
                    while (this.hasRemaining(in) && Character.isDigit((char)(ch = this.get(in)))) {
                        this.bodyLength = this.bodyLength * 10 + (ch - 48);
                    }
                    if (ch == 1) {
                        this.state = 3;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("body length = " + this.bodyLength + ": " + this.getBufferDebugInfo(in));
                        }
                    } else {
                        if (!this.hasRemaining(in)) break;
                        String messageString = this.getMessageStringForError(in);
                        this.handleError(in, in.position() + 1, "Length format error in message (last character:" + ch + "): " + messageString, false);
                        continue;
                    }
                }
                if (this.state == 3) {
                    if (this.remaining(in) < this.bodyLength) break;
                    this.position += this.bodyLength;
                    this.state = 4;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("message body found: " + this.getBufferDebugInfo(in));
                    }
                }
                if (this.state != 4) continue;
                if (FIXMessageDecoder.startsWith(in, this.position, this.CHECKSUM_PATTERN) > 0) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("found checksum: " + this.getBufferDebugInfo(in));
                    }
                    this.position += this.CHECKSUM_PATTERN.length;
                } else {
                    if (this.position + this.CHECKSUM_PATTERN.length > in.limit()) break;
                    int recoveryPosition = this.position + 1;
                    this.handleError(in, recoveryPosition, "did not find checksum field, bad length?", this.isLogon(in));
                    continue;
                }
                String messageString = this.getMessageString(in);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("parsed message: " + this.getBufferDebugInfo(in) + " " + messageString);
                }
                out.write((Object)messageString);
                this.state = 1;
                this.bodyLength = 0;
                messageFound = true;
            }
            return messageFound;
        }
        catch (Throwable t) {
            this.state = 1;
            this.position = 0;
            this.bodyLength = 0;
            if (t instanceof ProtocolCodecException) {
                throw (ProtocolCodecException)t;
            }
            throw new ProtocolCodecException(t);
        }
    }

    private int remaining(ByteBuffer in) {
        return in.limit() - this.position;
    }

    private String getBufferDebugInfo(ByteBuffer in) {
        return "pos=" + in.position() + ",lim=" + in.limit() + ",rem=" + in.remaining() + ",offset=" + this.position + ",state=" + this.state;
    }

    private byte get(ByteBuffer in) {
        return in.get(this.position++);
    }

    private boolean hasRemaining(ByteBuffer in) {
        return this.position < in.limit();
    }

    private static int minMaskLength(byte[] data) {
        int len = 0;
        for (int i = 0; i < data.length; ++i) {
            if (Character.isLetter(data[i]) && Character.isLowerCase(data[i])) continue;
            ++len;
        }
        return len;
    }

    private String getMessageString(ByteBuffer buffer) throws UnsupportedEncodingException {
        byte[] data = new byte[this.position - buffer.position()];
        buffer.get(data);
        return new String(data, this.charsetEncoding);
    }

    private String getMessageStringForError(ByteBuffer buffer) throws UnsupportedEncodingException {
        int initialPosition = buffer.position();
        byte[] data = new byte[buffer.limit() - initialPosition];
        buffer.get(data);
        buffer.position(this.position - initialPosition);
        return new String(data, this.charsetEncoding);
    }

    private void handleError(ByteBuffer buffer, int recoveryPosition, String text, boolean disconnect) throws ProtocolCodecException {
        buffer.position(recoveryPosition);
        this.position = recoveryPosition;
        this.state = 1;
        this.bodyLength = 0;
        if (disconnect) {
            throw new CriticalProtocolCodecException(text);
        }
        this.log.error(text);
    }

    private boolean isLogon(ByteBuffer buffer) {
        BufPos bufPos = FIXMessageDecoder.indexOf(buffer, buffer.position(), this.LOGON_PATTERN);
        return bufPos._offset != -1;
    }

    private static BufPos indexOf(ByteBuffer buffer, int position, byte[] data) {
        int limit = buffer.limit() - FIXMessageDecoder.minMaskLength(data) + 1;
        for (int offset = position; offset < limit; ++offset) {
            int length;
            if (buffer.get(offset) != data[0] || (length = FIXMessageDecoder.startsWith(buffer, offset, data)) <= 0) continue;
            return new BufPos(offset, length);
        }
        return new BufPos(-1, 0);
    }

    private static int startsWith(ByteBuffer buffer, int bufferOffset, byte[] data) {
        int dataOffset;
        if (bufferOffset + FIXMessageDecoder.minMaskLength(data) > buffer.limit()) {
            return -1;
        }
        int initOffset = bufferOffset;
        int bufferLimit = buffer.limit();
        for (dataOffset = 0; dataOffset < data.length && bufferOffset < bufferLimit; ++dataOffset, ++bufferOffset) {
            if (buffer.get(bufferOffset) == data[dataOffset] || data[dataOffset] == 63 || Character.toUpperCase(data[dataOffset]) == buffer.get(bufferOffset)) continue;
            if (Character.isLetter(data[dataOffset]) && Character.isLowerCase(data[dataOffset])) {
                --bufferOffset;
                continue;
            }
            return -1;
        }
        if (dataOffset != data.length) {
            return -1;
        }
        return bufferOffset - initOffset;
    }

    public void finishDecode(IoSession arg0, ProtocolDecoderOutput arg1) throws Exception {
    }

    public List<String> extractMessages(File file) throws IOException, ProtocolCodecException {
        final ArrayList<String> messages = new ArrayList<String>();
        this.extractMessages(file, new MessageListener(){

            public void onMessage(String message) {
                messages.add(message);
            }
        });
        return messages;
    }

    public void extractMessages(File file, final MessageListener listener) throws IOException, ProtocolCodecException {
        FileChannel readOnlyChannel = new RandomAccessFile(file, "r").getChannel();
        MappedByteBuffer memoryMappedBuffer = readOnlyChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)readOnlyChannel.size());
        this.decode(null, ByteBuffer.wrap((java.nio.ByteBuffer)memoryMappedBuffer), new ProtocolDecoderOutput(){

            public void write(Object message) {
                listener.onMessage((String)message);
            }

            public void flush() {
            }
        });
    }

    private static byte[] getBytes(String s) {
        try {
            return s.getBytes(CharsetSupport.getDefaultCharset());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface MessageListener {
        public void onMessage(String var1);
    }

    static class BufPos {
        int _offset;
        int _length;

        public BufPos(int offset, int length) {
            this._offset = offset;
            this._length = length;
        }

        public String toString() {
            return this._offset + "," + this._length;
        }
    }
}

