/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quickfixj;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.quickfixj.QuickfixjConsumer;
import org.apache.camel.component.quickfixj.QuickfixjEngine;
import org.apache.camel.component.quickfixj.QuickfixjEventCategory;
import org.apache.camel.component.quickfixj.QuickfixjEventListener;
import org.apache.camel.component.quickfixj.QuickfixjProducer;
import org.apache.camel.component.quickfixj.converter.QuickfixjConverters;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Message;
import quickfix.SessionID;

@UriEndpoint(firstVersion="2.1.0", scheme="quickfix", title="QuickFix", syntax="quickfix:configurationName", consumerClass=QuickfixjConsumer.class, label="engine,messaging")
public class QuickfixjEndpoint
extends DefaultEndpoint
implements QuickfixjEventListener,
MultipleConsumersSupport {
    public static final String EVENT_CATEGORY_KEY = "EventCategory";
    public static final String SESSION_ID_KEY = "SessionID";
    public static final String MESSAGE_TYPE_KEY = "MessageType";
    public static final String DATA_DICTIONARY_KEY = "DataDictionary";
    private static final Logger LOG = LoggerFactory.getLogger(QuickfixjEndpoint.class);
    private final QuickfixjEngine engine;
    private final List<QuickfixjConsumer> consumers = new CopyOnWriteArrayList<QuickfixjConsumer>();
    @UriPath
    @Metadata(required="true")
    private String configurationName;
    @UriParam
    private SessionID sessionID;
    @UriParam
    private boolean lazyCreateEngine;

    @Deprecated
    public QuickfixjEndpoint(QuickfixjEngine engine, String uri, CamelContext context) {
        super(uri, context);
        this.engine = engine;
    }

    public QuickfixjEndpoint(QuickfixjEngine engine, String uri, Component component) {
        super(uri, component);
        this.engine = engine;
    }

    public SessionID getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(SessionID sessionID) {
        this.sessionID = sessionID;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public boolean isLazyCreateEngine() {
        return this.lazyCreateEngine;
    }

    public void setLazyCreateEngine(boolean lazyCreateEngine) {
        this.lazyCreateEngine = lazyCreateEngine;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        LOG.info("Creating QuickFIX/J consumer: {}, ExchangePattern={}", this.sessionID != null ? this.sessionID : "No Session", (Object)this.getExchangePattern());
        QuickfixjConsumer consumer = new QuickfixjConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)consumer);
        this.consumers.add(consumer);
        return consumer;
    }

    public Producer createProducer() throws Exception {
        LOG.info("Creating QuickFIX/J producer: {}", this.sessionID != null ? this.sessionID : "No Session");
        if (this.isWildcarded()) {
            throw new ResolveEndpointFailedException("Cannot create consumer on wildcarded session identifier: " + this.sessionID);
        }
        return new QuickfixjProducer((Endpoint)this);
    }

    public boolean isSingleton() {
        return true;
    }

    @Override
    public void onEvent(QuickfixjEventCategory eventCategory, SessionID sessionID, Message message) throws Exception {
        if (this.sessionID == null || this.isMatching(sessionID)) {
            for (QuickfixjConsumer consumer : this.consumers) {
                Exchange exchange = QuickfixjConverters.toExchange((Endpoint)this, sessionID, message, eventCategory, this.getExchangePattern());
                consumer.onExchange(exchange);
                if (exchange.getException() == null) continue;
                throw exchange.getException();
            }
        }
    }

    private boolean isMatching(SessionID sessionID) {
        if (this.sessionID.equals(sessionID)) {
            return true;
        }
        return this.isMatching(this.sessionID.getBeginString(), sessionID.getBeginString()) && this.isMatching(this.sessionID.getSenderCompID(), sessionID.getSenderCompID()) && this.isMatching(this.sessionID.getSenderSubID(), sessionID.getSenderSubID()) && this.isMatching(this.sessionID.getSenderLocationID(), sessionID.getSenderLocationID()) && this.isMatching(this.sessionID.getTargetCompID(), sessionID.getTargetCompID()) && this.isMatching(this.sessionID.getTargetSubID(), sessionID.getTargetSubID()) && this.isMatching(this.sessionID.getTargetLocationID(), sessionID.getTargetLocationID());
    }

    private boolean isMatching(String s1, String s2) {
        return s1.equals("") || s1.equals("*") || s1.equals(s2);
    }

    private boolean isWildcarded() {
        if (this.sessionID == null) {
            return false;
        }
        return this.sessionID.getBeginString().equals("*") || this.sessionID.getSenderCompID().equals("*") || this.sessionID.getSenderSubID().equals("*") || this.sessionID.getSenderLocationID().equals("*") || this.sessionID.getTargetCompID().equals("*") || this.sessionID.getTargetSubID().equals("*") || this.sessionID.getTargetLocationID().equals("*");
    }

    public boolean isMultipleConsumersSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureInitialized() throws Exception {
        if (!this.engine.isInitialized()) {
            QuickfixjEngine quickfixjEngine = this.engine;
            synchronized (quickfixjEngine) {
                if (!this.engine.isInitialized()) {
                    this.engine.initializeEngine();
                    this.engine.start();
                }
            }
        }
    }

    public QuickfixjEngine getEngine() {
        return this.engine;
    }

    protected void doStop() throws Exception {
        this.consumers.clear();
    }
}

