/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public final class ModelUtils {
    private static final ModelPartCloner DEPENDENCY_CLONER = new ModelPartCloner(){

        public Object cloneModelPart(Object src) {
            return ModelUtils.cloneDependency((Dependency)src);
        }
    };
    private static final ModelPartCloner PLUGIN_CLONER = new ModelPartCloner(){

        public Object cloneModelPart(Object src) {
            return ModelUtils.clonePlugin((Plugin)src);
        }
    };
    private static final ModelPartCloner EXTENSION_CLONER = new ModelPartCloner(){

        public Object cloneModelPart(Object src) {
            return ModelUtils.cloneExtension((Extension)src);
        }
    };
    private static final ModelPartCloner RESOURCE_CLONER = new ModelPartCloner(){

        public Object cloneModelPart(Object src) {
            return ModelUtils.cloneResource((Resource)src);
        }
    };
    private static final ModelPartCloner NOTIFIER_CLONER = new ModelPartCloner(){

        public Object cloneModelPart(Object src) {
            return ModelUtils.cloneNotifier((Notifier)src);
        }
    };
    private static final ModelPartCloner CONTRIBUTOR_CLONER = new ModelPartCloner(){

        public Object cloneModelPart(Object src) {
            return ModelUtils.cloneContributor((Contributor)src);
        }
    };
    private static final ModelPartCloner DEVELOPER_CLONER = new ModelPartCloner(){

        public Object cloneModelPart(Object src) {
            return ModelUtils.cloneDeveloper((Developer)src);
        }
    };
    private static final ModelPartCloner LICENSE_CLONER = new ModelPartCloner(){

        public Object cloneModelPart(Object src) {
            return ModelUtils.cloneLicense((License)src);
        }
    };
    private static final ModelPartCloner MAILING_LIST_CLONER = new ModelPartCloner(){

        public Object cloneModelPart(Object src) {
            return ModelUtils.cloneMailingList((MailingList)src);
        }
    };
    private static final ModelPartCloner REPOSITORY_CLONER = new ModelPartCloner(){

        public Object cloneModelPart(Object src) {
            return ModelUtils.cloneRepository((Repository)src);
        }
    };
    private static final ModelPartCloner PROFILE_CLONER = new ModelPartCloner(){

        public Object cloneModelPart(Object src) {
            return ModelUtils.cloneProfile((Profile)src);
        }
    };
    private static final ModelPartCloner REPORT_PLUGIN_CLONER = new ModelPartCloner(){

        public Object cloneModelPart(Object src) {
            return ModelUtils.cloneReportPlugin((ReportPlugin)src);
        }
    };
    private static final ModelPartCloner REPORT_SET_CLONER = new ModelPartCloner(){

        public Object cloneModelPart(Object src) {
            return ModelUtils.cloneReportSet((ReportSet)src);
        }
    };
    private static final ModelPartCloner DEPENDENCY_EXCLUSION_CLONER = new ModelPartCloner(){

        public Object cloneModelPart(Object src) {
            return ModelUtils.cloneExclusion((Exclusion)src);
        }
    };
    private static final ModelPartCloner PLUGIN_EXECUTION_CLONER = new ModelPartCloner(){

        public Object cloneModelPart(Object src) {
            return ModelUtils.clonePluginExecution((PluginExecution)src);
        }
    };

    public static void mergeDuplicatePluginDefinitions(PluginContainer pluginContainer) {
        if (pluginContainer == null) {
            return;
        }
        List<Plugin> originalPlugins = pluginContainer.getPlugins();
        if (originalPlugins == null || originalPlugins.isEmpty()) {
            return;
        }
        ArrayList<Plugin> normalized = new ArrayList<Plugin>(originalPlugins.size());
        for (Plugin currentPlugin : originalPlugins) {
            if (normalized.contains(currentPlugin)) {
                int idx = normalized.indexOf(currentPlugin);
                Plugin firstPlugin = (Plugin)normalized.get(idx);
                ModelUtils.mergePluginDefinitions(currentPlugin, firstPlugin, false);
                normalized.set(idx, currentPlugin);
                continue;
            }
            normalized.add(currentPlugin);
        }
        pluginContainer.setPlugins(normalized);
    }

    public static ReportSet cloneReportSet(ReportSet src) {
        if (src == null) {
            return null;
        }
        ReportSet result = new ReportSet();
        result.setConfiguration(ModelUtils.cloneConfiguration(src.getConfiguration()));
        result.setId(src.getId());
        result.setInherited(src.getInherited());
        result.setReports(ModelUtils.cloneListOfStrings(src.getReports()));
        return result;
    }

    public static ReportPlugin cloneReportPlugin(ReportPlugin src) {
        if (src == null) {
            return null;
        }
        ReportPlugin result = new ReportPlugin();
        result.setArtifactId(src.getArtifactId());
        result.setConfiguration(ModelUtils.cloneConfiguration(src.getConfiguration()));
        result.setGroupId(src.getGroupId());
        result.setInherited(src.getInherited());
        result.setReportSets(ModelUtils.cloneList(src.getReportSets(), REPORT_SET_CLONER));
        result.setVersion(src.getVersion());
        return result;
    }

    public static Profile cloneProfile(Profile src) {
        if (src == null) {
            return null;
        }
        Profile result = new Profile();
        ModelUtils.cloneModelBaseFields(src, result);
        result.setActivation(ModelUtils.cloneActivation(src.getActivation()));
        BuildBase resultBuild = null;
        if (src.getBuild() != null) {
            resultBuild = new BuildBase();
            ModelUtils.cloneBuildBaseFields(src.getBuild(), resultBuild);
        }
        result.setBuild(resultBuild);
        result.setId(src.getId());
        result.setSource(src.getSource());
        return result;
    }

    private static void cloneModelBaseFields(ModelBase src, ModelBase result) {
        result.setDependencies(ModelUtils.cloneList(src.getDependencies(), DEPENDENCY_CLONER));
        result.setDependencyManagement(ModelUtils.cloneDependencyManagement(src.getDependencyManagement()));
        result.setDistributionManagement(ModelUtils.cloneDistributionManagement(src.getDistributionManagement()));
        result.setModules(ModelUtils.cloneListOfStrings(src.getModules()));
        result.setPluginRepositories(ModelUtils.cloneList(src.getPluginRepositories(), REPOSITORY_CLONER));
        result.setProperties(ModelUtils.cloneProperties(src.getProperties()));
        result.setReporting(ModelUtils.cloneReporting(src.getReporting()));
        result.setRepositories(ModelUtils.cloneList(src.getRepositories(), REPOSITORY_CLONER));
    }

    public static Reporting cloneReporting(Reporting src) {
        if (src == null) {
            return null;
        }
        Reporting result = new Reporting();
        result.setExcludeDefaults(src.isExcludeDefaults());
        result.setOutputDirectory(src.getOutputDirectory());
        result.setPlugins(ModelUtils.cloneList(src.getPlugins(), REPORT_PLUGIN_CLONER));
        return result;
    }

    public static Activation cloneActivation(Activation src) {
        if (src == null) {
            return null;
        }
        Activation result = new Activation();
        result.setActiveByDefault(src.isActiveByDefault());
        result.setFile(ModelUtils.cloneActivationFile(src.getFile()));
        result.setJdk(src.getJdk());
        result.setOs(ModelUtils.cloneActivationOs(src.getOs()));
        result.setProperty(ModelUtils.cloneActivationProperty(src.getProperty()));
        return result;
    }

    public static ActivationProperty cloneActivationProperty(ActivationProperty src) {
        if (src == null) {
            return null;
        }
        ActivationProperty result = new ActivationProperty();
        result.setName(src.getName());
        result.setValue(src.getValue());
        return result;
    }

    public static ActivationOS cloneActivationOs(ActivationOS src) {
        if (src == null) {
            return null;
        }
        ActivationOS result = new ActivationOS();
        result.setArch(src.getArch());
        result.setFamily(src.getFamily());
        result.setName(src.getName());
        result.setVersion(src.getVersion());
        return result;
    }

    public static ActivationFile cloneActivationFile(ActivationFile src) {
        if (src == null) {
            return null;
        }
        ActivationFile result = new ActivationFile();
        result.setExists(src.getExists());
        result.setMissing(src.getMissing());
        return result;
    }

    public static Repository cloneRepository(Repository src) {
        if (src == null) {
            return null;
        }
        Repository result = new Repository();
        result.setReleases(ModelUtils.cloneRepositoryPolicy(src.getReleases()));
        result.setSnapshots(ModelUtils.cloneRepositoryPolicy(src.getSnapshots()));
        ModelUtils.cloneRepositoryBaseFields(src, result);
        return result;
    }

    public static RepositoryPolicy cloneRepositoryPolicy(RepositoryPolicy src) {
        if (src == null) {
            return null;
        }
        RepositoryPolicy result = new RepositoryPolicy();
        result.setChecksumPolicy(src.getChecksumPolicy());
        result.setEnabled(src.isEnabled());
        result.setUpdatePolicy(src.getUpdatePolicy());
        return result;
    }

    public static MailingList cloneMailingList(MailingList src) {
        if (src == null) {
            return null;
        }
        MailingList result = new MailingList();
        result.setArchive(src.getArchive());
        result.setName(src.getName());
        result.setOtherArchives(src.getOtherArchives());
        result.setPost(src.getPost());
        result.setSubscribe(src.getSubscribe());
        result.setUnsubscribe(src.getUnsubscribe());
        return result;
    }

    public static void mergePluginLists(PluginContainer child, PluginContainer parent, boolean handleAsInheritance) {
        if (child == null || parent == null) {
            return;
        }
        List<Plugin> parentPlugins = parent.getPlugins();
        if (parentPlugins != null && !parentPlugins.isEmpty()) {
            parentPlugins = new ArrayList<Plugin>(parentPlugins);
            if (handleAsInheritance) {
                Iterator<Plugin> it = parentPlugins.iterator();
                while (it.hasNext()) {
                    Plugin plugin = it.next();
                    String inherited = plugin.getInherited();
                    if (inherited == null || Boolean.valueOf(inherited).booleanValue()) continue;
                    it.remove();
                }
            }
            ArrayList<Plugin> assembledPlugins = new ArrayList<Plugin>();
            Map<String, Plugin> childPlugins = child.getPluginsAsMap();
            for (Plugin parentPlugin : parentPlugins) {
                String parentInherited = parentPlugin.getInherited();
                if (!handleAsInheritance || parentInherited == null || Boolean.valueOf(parentInherited).booleanValue()) {
                    Plugin childPlugin = childPlugins.get(parentPlugin.getKey());
                    if (childPlugin != null && !assembledPlugins.contains(childPlugin)) {
                        Plugin assembledPlugin = childPlugin;
                        ModelUtils.mergePluginDefinitions(childPlugin, parentPlugin, handleAsInheritance);
                        assembledPlugins.add(assembledPlugin);
                    }
                    if (handleAsInheritance && parentInherited == null) {
                        parentPlugin.unsetInheritanceApplied();
                    }
                }
                List results = ModelUtils.orderAfterMerge(assembledPlugins, parentPlugins, child.getPlugins());
                child.setPlugins(results);
                child.flushPluginMap();
            }
        }
    }

    public static List orderAfterMerge(List merged, List highPrioritySource, List lowPrioritySource) {
        ArrayList results = new ArrayList();
        if (!merged.isEmpty()) {
            results.addAll(merged);
        }
        ArrayList missingFromResults = new ArrayList();
        ArrayList<List> sources = new ArrayList<List>();
        sources.add(highPrioritySource);
        sources.add(lowPrioritySource);
        for (List source : sources) {
            for (Object item : source) {
                if (results.contains(item)) {
                    if (missingFromResults.isEmpty()) continue;
                    int idx = results.indexOf(item);
                    if (idx < 0) {
                        idx = 0;
                    }
                    results.addAll(idx, missingFromResults);
                    missingFromResults.clear();
                    continue;
                }
                missingFromResults.add(item);
            }
            if (missingFromResults.isEmpty()) continue;
            results.addAll(missingFromResults);
            missingFromResults.clear();
        }
        return results;
    }

    public static void mergeReportPluginLists(Reporting child, Reporting parent, boolean handleAsInheritance) {
        if (child == null || parent == null) {
            return;
        }
        List<ReportPlugin> parentPlugins = parent.getPlugins();
        if (parentPlugins != null && !parentPlugins.isEmpty()) {
            parentPlugins = new ArrayList<ReportPlugin>(parentPlugins);
            if (handleAsInheritance) {
                Iterator<ReportPlugin> it = parentPlugins.iterator();
                while (it.hasNext()) {
                    ReportPlugin plugin = it.next();
                    String inherited = plugin.getInherited();
                    if (inherited == null || Boolean.valueOf(inherited).booleanValue()) continue;
                    it.remove();
                }
            }
            ArrayList<ReportPlugin> assembledPlugins = new ArrayList<ReportPlugin>();
            Map<String, ReportPlugin> childPlugins = child.getReportPluginsAsMap();
            for (ReportPlugin parentPlugin : parentPlugins) {
                String parentInherited = parentPlugin.getInherited();
                if (!handleAsInheritance || parentInherited == null || Boolean.valueOf(parentInherited).booleanValue()) {
                    ReportPlugin childPlugin = childPlugins.get(parentPlugin.getKey());
                    if (childPlugin != null && !assembledPlugins.contains(childPlugin)) {
                        ReportPlugin assembledPlugin = childPlugin;
                        ModelUtils.mergeReportPluginDefinitions(childPlugin, parentPlugin, handleAsInheritance);
                        assembledPlugins.add(assembledPlugin);
                    }
                    if (handleAsInheritance && parentInherited == null) {
                        parentPlugin.unsetInheritanceApplied();
                    }
                }
                List results = ModelUtils.orderAfterMerge(assembledPlugins, parentPlugins, child.getPlugins());
                child.setPlugins(results);
                child.flushReportPluginMap();
            }
        }
    }

    public static void mergePluginDefinitions(Plugin child, Plugin parent, boolean handleAsInheritance) {
        if (child == null || parent == null) {
            return;
        }
        if (parent.isExtensions()) {
            child.setExtensions(true);
        }
        if (child.getVersion() == null && parent.getVersion() != null) {
            child.setVersion(parent.getVersion());
        }
        Xpp3Dom childConfiguration = (Xpp3Dom)child.getConfiguration();
        Xpp3Dom parentConfiguration = (Xpp3Dom)parent.getConfiguration();
        childConfiguration = Xpp3Dom.mergeXpp3Dom(childConfiguration, parentConfiguration);
        child.setConfiguration(childConfiguration);
        child.setDependencies(ModelUtils.mergeDependencyList(child.getDependencies(), parent.getDependencies()));
        String parentInherited = parent.getInherited();
        boolean parentIsInherited = parentInherited == null || Boolean.valueOf(parentInherited) != false;
        List<PluginExecution> parentExecutions = parent.getExecutions();
        if (parentExecutions != null && !parentExecutions.isEmpty()) {
            ArrayList<PluginExecution> mergedExecutions = new ArrayList<PluginExecution>();
            TreeMap<String, PluginExecution> assembledExecutions = new TreeMap<String, PluginExecution>();
            Map<String, PluginExecution> childExecutions = child.getExecutionsAsMap();
            for (PluginExecution parentExecution : parentExecutions) {
                boolean parentExecInherited;
                String inherited = parentExecution.getInherited();
                boolean bl = parentExecInherited = parentIsInherited && (inherited == null || Boolean.valueOf(inherited) != false);
                if (handleAsInheritance && !parentExecInherited) continue;
                PluginExecution assembled = parentExecution;
                PluginExecution childExecution = childExecutions.get(parentExecution.getId());
                if (childExecution != null) {
                    ModelUtils.mergePluginExecutionDefinitions(childExecution, parentExecution);
                    assembled = childExecution;
                } else if (handleAsInheritance && parentInherited == null) {
                    parentExecution.unsetInheritanceApplied();
                }
                assembledExecutions.put(assembled.getId(), assembled);
                mergedExecutions.add(assembled);
            }
            for (PluginExecution childExecution : child.getExecutions()) {
                if (assembledExecutions.containsKey(childExecution.getId())) continue;
                mergedExecutions.add(childExecution);
            }
            child.setExecutions(mergedExecutions);
            child.flushExecutionMap();
        }
    }

    public static void mergeReportPluginDefinitions(ReportPlugin child, ReportPlugin parent, boolean handleAsInheritance) {
        List<ReportSet> parentReportSets;
        String parentInherited;
        boolean parentIsInherited;
        if (child == null || parent == null) {
            return;
        }
        if (child.getVersion() == null && parent.getVersion() != null) {
            child.setVersion(parent.getVersion());
        }
        boolean bl = parentIsInherited = (parentInherited = parent.getInherited()) == null || Boolean.valueOf(parentInherited) != false;
        if (parentIsInherited) {
            Xpp3Dom childConfiguration = (Xpp3Dom)child.getConfiguration();
            Xpp3Dom parentConfiguration = (Xpp3Dom)parent.getConfiguration();
            childConfiguration = Xpp3Dom.mergeXpp3Dom(childConfiguration, parentConfiguration);
            child.setConfiguration(childConfiguration);
        }
        if ((parentReportSets = parent.getReportSets()) != null && !parentReportSets.isEmpty()) {
            TreeMap<String, ReportSet> assembledReportSets = new TreeMap<String, ReportSet>();
            Map<String, ReportSet> childReportSets = child.getReportSetsAsMap();
            for (ReportSet reportSet : parentReportSets) {
                if (handleAsInheritance && !parentIsInherited) continue;
                ReportSet assembledReportSet = reportSet;
                ReportSet childReportSet = childReportSets.get(reportSet.getId());
                if (childReportSet != null) {
                    ModelUtils.mergeReportSetDefinitions(childReportSet, reportSet);
                    assembledReportSet = childReportSet;
                } else if (handleAsInheritance && parentInherited == null) {
                    reportSet.unsetInheritanceApplied();
                }
                assembledReportSets.put(assembledReportSet.getId(), assembledReportSet);
            }
            for (Map.Entry entry : childReportSets.entrySet()) {
                String id = (String)entry.getKey();
                if (assembledReportSets.containsKey(id)) continue;
                assembledReportSets.put(id, (ReportSet)entry.getValue());
            }
            child.setReportSets(new ArrayList<ReportSet>(assembledReportSets.values()));
            child.flushReportSetMap();
        }
    }

    private static void mergePluginExecutionDefinitions(PluginExecution child, PluginExecution parent) {
        if (child.getPhase() == null) {
            child.setPhase(parent.getPhase());
        }
        List<String> parentGoals = parent.getGoals();
        List<String> childGoals = child.getGoals();
        ArrayList<String> goals = new ArrayList<String>();
        if (childGoals != null && !childGoals.isEmpty()) {
            goals.addAll(childGoals);
        }
        if (parentGoals != null) {
            for (String goal : parentGoals) {
                if (goals.contains(goal)) continue;
                goals.add(goal);
            }
        }
        child.setGoals(goals);
        Xpp3Dom childConfiguration = (Xpp3Dom)child.getConfiguration();
        Xpp3Dom parentConfiguration = (Xpp3Dom)parent.getConfiguration();
        childConfiguration = Xpp3Dom.mergeXpp3Dom(childConfiguration, parentConfiguration);
        child.setConfiguration(childConfiguration);
    }

    private static void mergeReportSetDefinitions(ReportSet child, ReportSet parent) {
        List<String> parentReports = parent.getReports();
        List<String> childReports = child.getReports();
        ArrayList<String> reports = new ArrayList<String>();
        if (childReports != null && !childReports.isEmpty()) {
            reports.addAll(childReports);
        }
        if (parentReports != null) {
            for (String report : parentReports) {
                if (reports.contains(report)) continue;
                reports.add(report);
            }
        }
        child.setReports(reports);
        Xpp3Dom childConfiguration = (Xpp3Dom)child.getConfiguration();
        Xpp3Dom parentConfiguration = (Xpp3Dom)parent.getConfiguration();
        childConfiguration = Xpp3Dom.mergeXpp3Dom(childConfiguration, parentConfiguration);
        child.setConfiguration(childConfiguration);
    }

    public static Model cloneModel(Model src) {
        if (src == null) {
            return null;
        }
        Model result = new Model();
        ModelUtils.cloneModelBaseFields(src, result);
        result.setArtifactId(src.getArtifactId());
        result.setBuild(ModelUtils.cloneBuild(src.getBuild()));
        result.setCiManagement(ModelUtils.cloneCiManagement(src.getCiManagement()));
        result.setContributors(ModelUtils.cloneList(src.getContributors(), CONTRIBUTOR_CLONER));
        result.setDescription(src.getDescription());
        result.setDevelopers(ModelUtils.cloneList(src.getDevelopers(), DEVELOPER_CLONER));
        result.setGroupId(src.getGroupId());
        result.setInceptionYear(src.getInceptionYear());
        result.setIssueManagement(ModelUtils.cloneIssueManagement(src.getIssueManagement()));
        result.setLicenses(ModelUtils.cloneList(src.getLicenses(), LICENSE_CLONER));
        result.setMailingLists(ModelUtils.cloneList(src.getMailingLists(), MAILING_LIST_CLONER));
        result.setModelVersion(src.getModelVersion());
        result.setName(src.getName());
        result.setOrganization(ModelUtils.cloneOrganization(src.getOrganization()));
        result.setPackaging(src.getPackaging());
        result.setParent(ModelUtils.cloneParent(src.getParent()));
        result.setPrerequisites(ModelUtils.clonePrerequisites(src.getPrerequisites()));
        result.setProfiles(ModelUtils.cloneList(src.getProfiles(), PROFILE_CLONER));
        result.setScm(ModelUtils.cloneScm(src.getScm()));
        result.setUrl(src.getUrl());
        result.setVersion(src.getVersion());
        return result;
    }

    public static Scm cloneScm(Scm src) {
        if (src == null) {
            return null;
        }
        Scm result = new Scm();
        result.setConnection(src.getConnection());
        result.setDeveloperConnection(src.getDeveloperConnection());
        result.setTag(src.getTag());
        result.setUrl(src.getUrl());
        return result;
    }

    public static Prerequisites clonePrerequisites(Prerequisites src) {
        if (src == null) {
            return null;
        }
        Prerequisites result = new Prerequisites();
        result.setMaven(src.getMaven());
        return result;
    }

    public static Organization cloneOrganization(Organization src) {
        if (src == null) {
            return null;
        }
        Organization result = new Organization();
        result.setName(src.getName());
        result.setUrl(src.getUrl());
        return result;
    }

    public static License cloneLicense(License src) {
        if (src == null) {
            return null;
        }
        License result = new License();
        result.setComments(src.getComments());
        result.setDistribution(src.getDistribution());
        result.setName(src.getName());
        result.setUrl(src.getUrl());
        return result;
    }

    public static IssueManagement cloneIssueManagement(IssueManagement src) {
        if (src == null) {
            return null;
        }
        IssueManagement result = new IssueManagement();
        result.setSystem(src.getSystem());
        result.setUrl(src.getUrl());
        return result;
    }

    public static DistributionManagement cloneDistributionManagement(DistributionManagement src) {
        if (src == null) {
            return null;
        }
        DistributionManagement result = new DistributionManagement();
        result.setDownloadUrl(src.getDownloadUrl());
        result.setRelocation(ModelUtils.cloneRelocation(src.getRelocation()));
        result.setRepository(ModelUtils.cloneDeploymentRepository(src.getRepository()));
        result.setSite(ModelUtils.cloneSite(src.getSite()));
        result.setSnapshotRepository(ModelUtils.cloneDeploymentRepository(src.getSnapshotRepository()));
        result.setStatus(src.getStatus());
        return result;
    }

    public static Site cloneSite(Site src) {
        if (src == null) {
            return null;
        }
        Site result = new Site();
        result.setId(src.getId());
        result.setName(src.getName());
        result.setUrl(src.getUrl());
        return result;
    }

    public static DeploymentRepository cloneDeploymentRepository(DeploymentRepository src) {
        if (src == null) {
            return null;
        }
        DeploymentRepository result = new DeploymentRepository();
        result.setUniqueVersion(src.isUniqueVersion());
        ModelUtils.cloneRepositoryBaseFields(src, result);
        return result;
    }

    private static void cloneRepositoryBaseFields(RepositoryBase src, RepositoryBase result) {
        result.setId(src.getId());
        result.setLayout(src.getLayout());
        result.setName(src.getName());
        result.setUrl(src.getUrl());
    }

    public static Relocation cloneRelocation(Relocation src) {
        if (src == null) {
            return null;
        }
        Relocation result = new Relocation();
        result.setArtifactId(src.getArtifactId());
        result.setGroupId(src.getGroupId());
        result.setMessage(src.getMessage());
        result.setVersion(src.getVersion());
        return result;
    }

    public static DependencyManagement cloneDependencyManagement(DependencyManagement src) {
        if (src == null) {
            return null;
        }
        DependencyManagement result = new DependencyManagement();
        result.setDependencies(ModelUtils.cloneList(src.getDependencies(), DEPENDENCY_CLONER));
        return result;
    }

    private static List cloneList(List src, ModelPartCloner cloner) {
        ArrayList<Object> result = null;
        if (src != null) {
            result = new ArrayList<Object>(src.size());
            Iterator it = src.iterator();
            while (it.hasNext()) {
                result.add(cloner.cloneModelPart(it.next()));
            }
        }
        return result;
    }

    public static Contributor cloneContributor(Contributor src) {
        if (src == null) {
            return null;
        }
        Contributor result = new Contributor();
        ModelUtils.cloneContributorFields(src, result);
        return result;
    }

    public static Developer cloneDeveloper(Developer src) {
        if (src == null) {
            return null;
        }
        Developer result = new Developer();
        result.setId(src.getId());
        ModelUtils.cloneContributorFields(src, result);
        return result;
    }

    private static void cloneContributorFields(Contributor src, Contributor result) {
        result.setEmail(src.getEmail());
        result.setName(src.getName());
        result.setOrganization(src.getOrganization());
        result.setOrganizationUrl(src.getOrganizationUrl());
        result.setProperties(ModelUtils.cloneProperties(src.getProperties()));
        result.setRoles(ModelUtils.cloneListOfStrings(src.getRoles()));
        result.setTimezone(src.getTimezone());
        result.setUrl(src.getUrl());
    }

    public static CiManagement cloneCiManagement(CiManagement src) {
        if (src == null) {
            return null;
        }
        CiManagement result = new CiManagement();
        ArrayList<Notifier> notifiers = null;
        if (src.getNotifiers() != null) {
            notifiers = new ArrayList<Notifier>(src.getNotifiers().size());
            Iterator<Notifier> it = src.getNotifiers().iterator();
            while (it.hasNext()) {
                notifiers.add(ModelUtils.cloneNotifier(it.next()));
            }
        }
        result.setNotifiers(ModelUtils.cloneList(src.getNotifiers(), NOTIFIER_CLONER));
        result.setSystem(src.getSystem());
        result.setUrl(src.getUrl());
        return result;
    }

    public static Notifier cloneNotifier(Notifier src) {
        if (src == null) {
            return null;
        }
        Notifier result = new Notifier();
        result.setAddress(src.getAddress());
        result.setConfiguration(ModelUtils.cloneProperties(src.getConfiguration()));
        result.setSendOnError(src.isSendOnError());
        result.setSendOnFailure(result.isSendOnFailure());
        result.setSendOnSuccess(result.isSendOnSuccess());
        result.setSendOnWarning(result.isSendOnWarning());
        return result;
    }

    public static Properties cloneProperties(Properties src) {
        if (src == null) {
            return null;
        }
        Properties result = new Properties();
        Enumeration<?> e = src.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            result.setProperty(key, src.getProperty(key));
        }
        return result;
    }

    public static Build cloneBuild(Build src) {
        if (src == null) {
            return null;
        }
        Build result = new Build();
        ModelUtils.cloneBuildBaseFields(src, result);
        result.setExtensions(ModelUtils.cloneList(src.getExtensions(), EXTENSION_CLONER));
        result.setOutputDirectory(src.getOutputDirectory());
        result.setScriptSourceDirectory(src.getScriptSourceDirectory());
        result.setSourceDirectory(src.getSourceDirectory());
        result.setTestOutputDirectory(src.getTestOutputDirectory());
        result.setTestSourceDirectory(src.getTestSourceDirectory());
        return result;
    }

    public static void cloneBuildBaseFields(BuildBase src, BuildBase result) {
        result.setDefaultGoal(src.getDefaultGoal());
        result.setDirectory(src.getDirectory());
        result.setFilters(ModelUtils.cloneListOfStrings(src.getFilters()));
        result.setFinalName(src.getFinalName());
        result.setPluginManagement(ModelUtils.clonePluginManagement(src.getPluginManagement()));
        result.setPlugins(ModelUtils.cloneList(src.getPlugins(), PLUGIN_CLONER));
        result.setResources(ModelUtils.cloneList(src.getResources(), RESOURCE_CLONER));
        result.setTestResources(ModelUtils.cloneList(src.getTestResources(), RESOURCE_CLONER));
    }

    public static PluginManagement clonePluginManagement(PluginManagement src) {
        PluginManagement pMgmt = null;
        if (src != null) {
            pMgmt = new PluginManagement();
            pMgmt.setPlugins(ModelUtils.cloneList(src.getPlugins(), PLUGIN_CLONER));
        }
        return pMgmt;
    }

    public static Resource cloneResource(Resource src) {
        Resource result = null;
        if (src != null) {
            result = new Resource();
            result.setDirectory(src.getDirectory());
            result.setExcludes(ModelUtils.cloneListOfStrings(src.getExcludes()));
            result.setFiltering(src.isFiltering());
            result.setIncludes(ModelUtils.cloneListOfStrings(src.getIncludes()));
            result.setMergeId(src.getMergeId());
            result.setTargetPath(src.getTargetPath());
        }
        return result;
    }

    public static Plugin clonePlugin(Plugin src) {
        Plugin result = null;
        if (src != null) {
            result = new Plugin();
            result.setArtifactId(src.getArtifactId());
            result.setConfiguration(ModelUtils.cloneConfiguration(src.getConfiguration()));
            result.setDependencies(ModelUtils.cloneList(src.getDependencies(), DEPENDENCY_CLONER));
            result.setExecutions(ModelUtils.cloneList(src.getExecutions(), PLUGIN_EXECUTION_CLONER));
            result.setExtensions(src.isExtensions());
            result.setGroupId(src.getGroupId());
            result.setInherited(src.getInherited());
            result.setVersion(src.getVersion());
        }
        return result;
    }

    public static PluginExecution clonePluginExecution(PluginExecution src) {
        PluginExecution result = null;
        if (src != null) {
            result = new PluginExecution();
            result.setId(src.getId());
            result.setGoals(ModelUtils.cloneListOfStrings(src.getGoals()));
            result.setConfiguration(ModelUtils.cloneConfiguration(src.getConfiguration()));
            result.setInherited(src.getInherited());
            result.setPhase(src.getPhase());
        }
        return result;
    }

    public static Object cloneConfiguration(Object configuration) {
        if (configuration == null) {
            return null;
        }
        return new Xpp3Dom((Xpp3Dom)configuration);
    }

    public static Dependency cloneDependency(Dependency src) {
        Dependency result = null;
        if (src != null) {
            result = new Dependency();
            result.setArtifactId(src.getArtifactId());
            result.setClassifier(src.getClassifier());
            result.setExclusions(ModelUtils.cloneList(src.getExclusions(), DEPENDENCY_EXCLUSION_CLONER));
            result.setGroupId(src.getGroupId());
            result.setOptional(src.isOptional());
            result.setScope(src.getScope());
            result.setSystemPath(src.getSystemPath());
            result.setType(src.getType());
            result.setVersion(src.getVersion());
        }
        return result;
    }

    public static Exclusion cloneExclusion(Exclusion src) {
        Exclusion result = null;
        if (src != null) {
            result = new Exclusion();
            result.setArtifactId(src.getArtifactId());
            result.setGroupId(src.getGroupId());
        }
        return result;
    }

    public static List cloneListOfStrings(List src) {
        ArrayList<String> result = null;
        if (src != null) {
            result = new ArrayList<String>(src.size());
            for (String item : src) {
                result.add(item);
            }
        }
        return result;
    }

    public static Extension cloneExtension(Extension src) {
        Extension rExt = new Extension();
        rExt.setArtifactId(src.getArtifactId());
        rExt.setGroupId(src.getGroupId());
        rExt.setVersion(src.getVersion());
        return rExt;
    }

    public static Exclusion cloneDependencyExclusion(Exclusion src) {
        if (src == null) {
            return null;
        }
        Exclusion result = new Exclusion();
        result.setArtifactId(src.getArtifactId());
        result.setGroupId(src.getGroupId());
        return result;
    }

    public static Parent cloneParent(Parent src) {
        if (src == null) {
            return null;
        }
        Parent result = new Parent();
        result.setArtifactId(src.getArtifactId());
        result.setGroupId(src.getGroupId());
        result.setRelativePath(src.getRelativePath());
        result.setVersion(src.getVersion());
        return result;
    }

    public static List mergeRepositoryLists(List dominant, List recessive) {
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        for (Repository repository : dominant) {
            repositories.add(repository);
        }
        for (Repository repository : recessive) {
            if (repositories.contains(repository)) continue;
            repositories.add(repository);
        }
        return repositories;
    }

    public static void mergeExtensionLists(Build childBuild, Build parentBuild) {
        LinkedHashMap<String, Extension> extMap = new LinkedHashMap<String, Extension>();
        List<Extension> ext = childBuild.getExtensions();
        if (ext != null) {
            for (Extension extension : ext) {
                extMap.put(extension.getKey(), extension);
            }
        }
        if ((ext = parentBuild.getExtensions()) != null) {
            for (Extension extension : ext) {
                if (extMap.containsKey(extension.getKey())) continue;
                extMap.put(extension.getKey(), extension);
            }
        }
        childBuild.setExtensions(new ArrayList<Extension>(extMap.values()));
    }

    public static void mergeResourceLists(List childResources, List parentResources) {
        for (Resource r : parentResources) {
            if (childResources.contains(r)) continue;
            childResources.add(r);
        }
    }

    public static void mergeFilterLists(List childFilters, List parentFilters) {
        for (String f : parentFilters) {
            if (childFilters.contains(f)) continue;
            childFilters.add(f);
        }
    }

    public static List mergeDependencyList(List child, List parent) {
        LinkedHashMap<String, Dependency> depsMap = new LinkedHashMap<String, Dependency>();
        if (child != null) {
            for (Dependency dependency : child) {
                depsMap.put(dependency.getManagementKey(), dependency);
            }
        }
        if (parent != null) {
            for (Dependency dependency : parent) {
                if (depsMap.containsKey(dependency.getManagementKey())) continue;
                depsMap.put(dependency.getManagementKey(), dependency);
            }
        }
        return new ArrayList(depsMap.values());
    }

    public static interface ModelPartCloner {
        public Object cloneModelPart(Object var1);
    }
}

