/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj.codegenerator;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.quickfixj.codegenerator.MavenMessageCodeGenerator;
import org.quickfixj.codegenerator.MessageCodeGenerator;

public class GenerateMojo
extends AbstractMojo {
    private File dictFile;
    private File schemaDirectory;
    private File outputDirectory;
    private boolean decimal;
    private boolean orderedFields;
    private String packaging;
    private String fieldPackage = "quickfix.field";
    private MavenProject project;
    private MavenMessageCodeGenerator generator;

    @Override
    public void execute() throws MojoExecutionException {
        if (!this.outputDirectory.exists()) {
            FileUtils.mkdir(this.outputDirectory.getAbsolutePath());
        }
        try {
            this.generator = new MavenMessageCodeGenerator();
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info("Successfully created an instance of the QuickFIX source generator");
            }
            this.generator.setLog(this.getLog());
            MessageCodeGenerator.Task task = new MessageCodeGenerator.Task();
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info("Initialising code generator task");
            }
            if (this.dictFile != null && this.dictFile.exists()) {
                task.setSpecification(this.dictFile);
            } else {
                this.getLog().error("Cannot find file " + this.dictFile);
            }
            this.log("Processing " + this.dictFile);
            task.setName(this.dictFile.getName());
            task.setTransformDirectory(this.schemaDirectory);
            task.setMessagePackage(this.packaging);
            task.setOutputBaseDirectory(this.outputDirectory);
            task.setFieldPackage(this.fieldPackage);
            task.setOverwrite(true);
            task.setOrderedFields(this.orderedFields);
            task.setDecimalGenerated(this.decimal);
            this.generator.generate(task);
        }
        catch (Throwable t) {
            throw new MojoExecutionException("QuickFIX code generator execution failed", t);
        }
        if (this.project != null) {
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
    }

    private void log(String msg) {
        this.getLog().info(msg);
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public File getDictFile() {
        return this.dictFile;
    }

    public void setDictFile(File dictFile) {
        this.dictFile = dictFile;
    }

    public File getSchemaDirectory() {
        return this.schemaDirectory;
    }

    public void setSchemaDirectory(File schemaDirectory) {
        this.schemaDirectory = schemaDirectory;
    }

    public boolean isDecimal() {
        return this.decimal;
    }

    public void setDecimal(boolean decimal) {
        this.decimal = decimal;
    }

    public boolean isOrderedFields() {
        return this.orderedFields;
    }

    public void setOrderedFields(boolean orderedFields) {
        this.orderedFields = orderedFields;
    }

    public String getFieldPackage() {
        return this.fieldPackage;
    }

    public void setFieldPackage(String fieldPackage) {
        this.fieldPackage = fieldPackage;
    }
}

