/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.Application;
import quickfix.ConfigError;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.RuntimeError;
import quickfix.ScreenLogFactory;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionSettings;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.ThreadPerSessionEventHandlingStrategy;
import quickfix.mina.initiator.AbstractSocketInitiator;

public class ThreadedSocketInitiator
extends AbstractSocketInitiator {
    private final ThreadPerSessionEventHandlingStrategy eventHandlingStrategy;

    public ThreadedSocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory, int queueCapacity) throws ConfigError {
        super(application, messageStoreFactory, settings, logFactory, messageFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, queueCapacity);
    }

    public ThreadedSocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, logFactory, messageFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, 10000);
    }

    public ThreadedSocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory, int queueCapacity) throws ConfigError {
        super(application, messageStoreFactory, settings, new ScreenLogFactory(settings), messageFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, queueCapacity);
    }

    public ThreadedSocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, new ScreenLogFactory(settings), messageFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, 10000);
    }

    public ThreadedSocketInitiator(SessionFactory sessionFactory, SessionSettings settings, int queueCapacity) throws ConfigError {
        super(settings, sessionFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, queueCapacity);
    }

    public ThreadedSocketInitiator(SessionFactory sessionFactory, SessionSettings settings) throws ConfigError {
        super(settings, sessionFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, 10000);
    }

    @Override
    public void start() throws ConfigError, RuntimeError {
        this.createSessionInitiators();
        this.startInitiators();
    }

    @Override
    public void stop() {
        this.stop(false);
    }

    @Override
    public void stop(boolean forceDisconnect) {
        this.stopInitiators();
        this.logoutAllSessions(forceDisconnect);
        if (!forceDisconnect) {
            this.waitForLogout();
        }
        this.eventHandlingStrategy.stopDispatcherThreads();
        Session.unregisterSessions(this.getSessions());
    }

    @Override
    public void block() throws ConfigError, RuntimeError {
        throw new UnsupportedOperationException("Blocking not supported: " + this.getClass());
    }

    @Override
    protected EventHandlingStrategy getEventHandlingStrategy() {
        return this.eventHandlingStrategy;
    }
}

