/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.initiator;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.mina.core.filterchain.IoFilterChainBuilder;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.proxy.ProxyConnector;
import org.apache.mina.transport.socket.SocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.ConfigError;
import quickfix.LogUtil;
import quickfix.Session;
import quickfix.SystemTime;
import quickfix.mina.CompositeIoFilterChainBuilder;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.NetworkingOptions;
import quickfix.mina.ProtocolFactory;
import quickfix.mina.initiator.InitiatorIoHandler;
import quickfix.mina.initiator.InitiatorProxyIoHandler;
import quickfix.mina.message.FIXProtocolCodecFactory;
import quickfix.mina.ssl.SSLConfig;
import quickfix.mina.ssl.SSLContextFactory;
import quickfix.mina.ssl.SSLFilter;
import quickfix.mina.ssl.SSLSupport;

public class IoSessionInitiator {
    private static final long CONNECT_POLL_TIMEOUT = 2000L;
    private final ScheduledExecutorService executor;
    private final ConnectTask reconnectTask;
    private Future<?> reconnectFuture;
    protected static final Logger log = LoggerFactory.getLogger((String)("display." + IoSessionInitiator.class.getName()));

    public IoSessionInitiator(Session fixSession, SocketAddress[] socketAddresses, SocketAddress localAddress, int[] reconnectIntervalInSeconds, ScheduledExecutorService executor, NetworkingOptions networkingOptions, EventHandlingStrategy eventHandlingStrategy, IoFilterChainBuilder userIoFilterChainBuilder, boolean sslEnabled, SSLConfig sslConfig, String proxyType, String proxyVersion, String proxyHost, int proxyPort, String proxyUser, String proxyPassword, String proxyDomain, String proxyWorkstation) throws ConfigError {
        this.executor = executor;
        long[] reconnectIntervalInMillis = new long[reconnectIntervalInSeconds.length];
        for (int ii = 0; ii != reconnectIntervalInSeconds.length; ++ii) {
            reconnectIntervalInMillis[ii] = (long)reconnectIntervalInSeconds[ii] * 1000L;
        }
        try {
            this.reconnectTask = new ConnectTask(sslEnabled, socketAddresses, localAddress, userIoFilterChainBuilder, fixSession, reconnectIntervalInMillis, networkingOptions, eventHandlingStrategy, sslConfig, proxyType, proxyVersion, proxyHost, proxyPort, proxyUser, proxyPassword, proxyDomain, proxyWorkstation);
        }
        catch (GeneralSecurityException e) {
            throw new ConfigError(e);
        }
        log.info("[" + fixSession.getSessionID() + "] " + Arrays.asList(socketAddresses));
    }

    synchronized void start() {
        if (this.reconnectFuture == null) {
            this.reconnectTask.getFixSession().logon();
            this.reconnectFuture = this.executor.scheduleWithFixedDelay(this.reconnectTask, 0L, 1L, TimeUnit.SECONDS);
        }
    }

    synchronized void stop() {
        if (this.reconnectFuture != null) {
            this.reconnectFuture.cancel(true);
            this.reconnectFuture = null;
        }
        this.reconnectTask.ioConnector.dispose();
    }

    private static class ConnectTask
    implements Runnable {
        private final boolean sslEnabled;
        private final SocketAddress[] socketAddresses;
        private final SocketAddress localAddress;
        private final IoFilterChainBuilder userIoFilterChainBuilder;
        private IoConnector ioConnector;
        private final Session fixSession;
        private final long[] reconnectIntervalInMillis;
        private final NetworkingOptions networkingOptions;
        private final EventHandlingStrategy eventHandlingStrategy;
        private final SSLConfig sslConfig;
        private IoSession ioSession;
        private long lastReconnectAttemptTime;
        private long lastConnectTime;
        private int nextSocketAddressIndex;
        private int connectionFailureCount;
        private ConnectFuture connectFuture;
        private final String proxyType;
        private final String proxyVersion;
        private final String proxyHost;
        private final int proxyPort;
        private final String proxyUser;
        private final String proxyPassword;
        private final String proxyDomain;
        private final String proxyWorkstation;

        public ConnectTask(boolean sslEnabled, SocketAddress[] socketAddresses, SocketAddress localAddress, IoFilterChainBuilder userIoFilterChainBuilder, Session fixSession, long[] reconnectIntervalInMillis, NetworkingOptions networkingOptions, EventHandlingStrategy eventHandlingStrategy, SSLConfig sslConfig, String proxyType, String proxyVersion, String proxyHost, int proxyPort, String proxyUser, String proxyPassword, String proxyDomain, String proxyWorkstation) throws ConfigError, GeneralSecurityException {
            this.sslEnabled = sslEnabled;
            this.socketAddresses = socketAddresses;
            this.localAddress = localAddress;
            this.userIoFilterChainBuilder = userIoFilterChainBuilder;
            this.fixSession = fixSession;
            this.reconnectIntervalInMillis = reconnectIntervalInMillis;
            this.networkingOptions = networkingOptions;
            this.eventHandlingStrategy = eventHandlingStrategy;
            this.sslConfig = sslConfig;
            this.proxyType = proxyType;
            this.proxyVersion = proxyVersion;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyUser = proxyUser;
            this.proxyPassword = proxyPassword;
            this.proxyDomain = proxyDomain;
            this.proxyWorkstation = proxyWorkstation;
            this.setupIoConnector();
        }

        private void setupIoConnector() throws ConfigError, GeneralSecurityException {
            CompositeIoFilterChainBuilder ioFilterChainBuilder = new CompositeIoFilterChainBuilder(this.userIoFilterChainBuilder);
            boolean hasProxy = this.proxyType != null && this.proxyPort > 0 && this.socketAddresses[0] instanceof InetSocketAddress;
            SSLFilter sslFilter = null;
            if (this.sslEnabled) {
                sslFilter = this.installSslFilter(ioFilterChainBuilder, !hasProxy);
            }
            ioFilterChainBuilder.addLast("FIXCodec", new ProtocolCodecFilter(new FIXProtocolCodecFactory()));
            IoConnector newConnector = ProtocolFactory.createIoConnector(this.socketAddresses[0]);
            newConnector.setHandler(new InitiatorIoHandler(this.fixSession, this.networkingOptions, this.eventHandlingStrategy));
            newConnector.setFilterChainBuilder(ioFilterChainBuilder);
            if (hasProxy) {
                ProxyConnector proxyConnector = ProtocolFactory.createIoProxyConnector((SocketConnector)newConnector, (InetSocketAddress)this.socketAddresses[0], new InetSocketAddress(this.proxyHost, this.proxyPort), this.proxyType, this.proxyVersion, this.proxyUser, this.proxyPassword, this.proxyDomain, this.proxyWorkstation);
                proxyConnector.setHandler(new InitiatorProxyIoHandler(new InitiatorIoHandler(this.fixSession, this.networkingOptions, this.eventHandlingStrategy), sslFilter));
                newConnector = proxyConnector;
            }
            if (this.ioConnector != null) {
                this.ioConnector.dispose();
            }
            this.ioConnector = newConnector;
        }

        private SSLFilter installSslFilter(CompositeIoFilterChainBuilder ioFilterChainBuilder, boolean autoStart) throws GeneralSecurityException {
            SSLContext sslContext = SSLContextFactory.getInstance(this.sslConfig);
            SSLFilter sslFilter = new SSLFilter(sslContext, autoStart);
            sslFilter.setUseClientMode(true);
            sslFilter.setCipherSuites(this.sslConfig.getEnabledCipherSuites() != null ? this.sslConfig.getEnabledCipherSuites() : SSLSupport.getDefaultCipherSuites(sslContext));
            sslFilter.setEnabledProtocols(this.sslConfig.getEnabledProtocols() != null ? this.sslConfig.getEnabledProtocols() : SSLSupport.getSupportedProtocols(sslContext));
            ioFilterChainBuilder.addLast("SslFilter", sslFilter);
            return sslFilter;
        }

        @Override
        public synchronized void run() {
            this.resetIoConnector();
            try {
                if (this.connectFuture == null) {
                    if (this.shouldReconnect()) {
                        this.connect();
                    }
                } else {
                    this.pollConnectFuture();
                }
            }
            catch (Throwable e) {
                LogUtil.logThrowable(this.fixSession.getLog(), "Exception during ConnectTask run", e);
            }
        }

        private void connect() {
            try {
                this.lastReconnectAttemptTime = SystemTime.currentTimeMillis();
                SocketAddress nextSocketAddress = this.getNextSocketAddress();
                this.connectFuture = this.localAddress == null ? this.ioConnector.connect(nextSocketAddress) : this.ioConnector.connect(nextSocketAddress, this.localAddress);
                this.pollConnectFuture();
            }
            catch (Throwable e) {
                this.handleConnectException(e);
            }
        }

        private void pollConnectFuture() {
            try {
                this.connectFuture.awaitUninterruptibly(2000L);
                if (this.connectFuture.getSession() != null) {
                    this.ioSession = this.connectFuture.getSession();
                    this.connectionFailureCount = 0;
                    this.lastConnectTime = System.currentTimeMillis();
                    this.connectFuture = null;
                } else {
                    this.fixSession.getLog().onEvent("Pending connection not established after " + (System.currentTimeMillis() - this.lastReconnectAttemptTime) + " ms.");
                }
            }
            catch (Throwable e) {
                this.handleConnectException(e);
            }
        }

        private void handleConnectException(Throwable e) {
            ++this.connectionFailureCount;
            SocketAddress socketAddress = this.socketAddresses[this.getCurrentSocketAddressIndex()];
            this.unresolveCurrentSocketAddress(socketAddress);
            while (e.getCause() != null) {
                e = e.getCause();
            }
            String nextRetryMsg = " (Next retry in " + this.computeNextRetryConnectDelay() + " milliseconds)";
            if (e instanceof IOException) {
                this.fixSession.getLog().onErrorEvent(e.getClass().getName() + " during connection to " + socketAddress + ": " + e + nextRetryMsg);
            } else {
                LogUtil.logThrowable(this.fixSession.getLog(), "Exception during connection to " + socketAddress + nextRetryMsg, e);
            }
            this.connectFuture = null;
        }

        private SocketAddress getNextSocketAddress() {
            InetSocketAddress inetAddr;
            SocketAddress socketAddress = this.socketAddresses[this.nextSocketAddressIndex];
            if (socketAddress instanceof InetSocketAddress && (inetAddr = (InetSocketAddress)socketAddress).isUnresolved()) {
                this.socketAddresses[this.nextSocketAddressIndex] = socketAddress = new InetSocketAddress(inetAddr.getHostName(), inetAddr.getPort());
            }
            this.nextSocketAddressIndex = (this.nextSocketAddressIndex + 1) % this.socketAddresses.length;
            return socketAddress;
        }

        private void unresolveCurrentSocketAddress(SocketAddress socketAddress) {
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inetAddr = (InetSocketAddress)socketAddress;
                this.socketAddresses[this.getCurrentSocketAddressIndex()] = InetSocketAddress.createUnresolved(inetAddr.getHostString(), inetAddr.getPort());
            }
        }

        private int getCurrentSocketAddressIndex() {
            return (this.nextSocketAddressIndex + this.socketAddresses.length - 1) % this.socketAddresses.length;
        }

        private boolean shouldReconnect() {
            return (this.ioSession == null || !this.ioSession.isConnected()) && this.isTimeForReconnect() && this.fixSession.isEnabled() && this.fixSession.isSessionTime();
        }

        private long computeNextRetryConnectDelay() {
            int index = this.connectionFailureCount - 1;
            if (index < 0) {
                index = 0;
            }
            long millis = index >= this.reconnectIntervalInMillis.length ? this.reconnectIntervalInMillis[this.reconnectIntervalInMillis.length - 1] : this.reconnectIntervalInMillis[index];
            return millis;
        }

        private boolean isTimeForReconnect() {
            return SystemTime.currentTimeMillis() - this.lastReconnectAttemptTime >= this.computeNextRetryConnectDelay();
        }

        public synchronized int getConnectionFailureCount() {
            return this.connectionFailureCount;
        }

        public synchronized long getLastReconnectAttemptTime() {
            return this.lastReconnectAttemptTime;
        }

        public synchronized long getLastConnectTime() {
            return this.lastConnectTime;
        }

        public Session getFixSession() {
            return this.fixSession;
        }

        private void resetIoConnector() {
            if (this.ioSession != null && Boolean.TRUE.equals(this.ioSession.getAttribute("QFJ_RESET_IO_CONNECTOR"))) {
                try {
                    this.setupIoConnector();
                    log.info("[" + this.fixSession.getSessionID() + "] - reset IoConnector");
                    if (this.connectFuture != null) {
                        this.connectFuture.cancel();
                    }
                    this.connectFuture = null;
                    this.ioSession = null;
                }
                catch (Throwable e) {
                    log.error("[" + this.fixSession.getSessionID() + "] - Exception during resetIoConnector call", e);
                }
            }
        }
    }
}

