/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.rabbitmq.RabbitMQEndpoint;
import org.apache.camel.impl.DefaultConsumer;

public class RabbitMQConsumer
extends DefaultConsumer {
    ExecutorService executor;
    Connection conn;
    Channel channel;
    private int closeTimeout = 30000;
    private final RabbitMQEndpoint endpoint;

    public RabbitMQConsumer(RabbitMQEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        this.executor = this.endpoint.createExecutor();
        this.log.debug("Using executor {}", (Object)this.executor);
        this.conn = this.endpoint.connect(this.executor);
        this.log.debug("Using conn {}", (Object)this.conn);
        this.channel = this.conn.createChannel();
        this.log.debug("Using channel {}", (Object)this.channel);
        this.channel.exchangeDeclare(this.endpoint.getExchangeName(), this.endpoint.getExchangeType(), this.endpoint.isDurable(), this.endpoint.isAutoDelete(), new HashMap<String, Object>());
        this.channel.queueDeclare(this.endpoint.getQueue(), this.endpoint.isDurable(), false, this.endpoint.isAutoDelete(), null);
        this.channel.queueBind(this.endpoint.getQueue(), this.endpoint.getExchangeName(), this.endpoint.getRoutingKey() == null ? "" : this.endpoint.getRoutingKey());
        this.channel.basicConsume(this.endpoint.getQueue(), this.endpoint.isAutoAck(), new RabbitConsumer(this, this.channel));
    }

    protected void doStop() throws Exception {
        if (this.channel != null) {
            this.log.debug("Closing channel: {}", (Object)this.channel);
            this.channel.close();
            this.channel = null;
        }
        if (this.conn != null) {
            this.log.debug("Closing connection: {} with timeout: {} ms.", (Object)this.conn, (Object)this.closeTimeout);
            this.conn.close(this.closeTimeout);
            this.conn = null;
        }
        if (this.executor != null) {
            if (this.endpoint != null && this.endpoint.getCamelContext() != null) {
                this.endpoint.getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
            this.executor = null;
        }
    }

    class RabbitConsumer
    extends com.rabbitmq.client.DefaultConsumer {
        private final RabbitMQConsumer consumer;
        private final Channel channel;

        public RabbitConsumer(RabbitMQConsumer consumer, Channel channel) {
            super(channel);
            this.consumer = consumer;
            this.channel = channel;
        }

        @Override
        public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
            Exchange exchange = this.consumer.endpoint.createRabbitExchange(envelope, properties, body);
            this.mergeAmqpProperties(exchange, properties);
            RabbitMQConsumer.this.log.trace("Created exchange [exchange={}]", (Object)exchange);
            try {
                this.consumer.getProcessor().process(exchange);
                long deliveryTag = envelope.getDeliveryTag();
                if (!this.consumer.endpoint.isAutoAck()) {
                    RabbitMQConsumer.this.log.trace("Acknowledging receipt [delivery_tag={}]", (Object)deliveryTag);
                    this.channel.basicAck(deliveryTag, false);
                }
            }
            catch (Exception e) {
                RabbitMQConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)e);
            }
        }

        private void mergeAmqpProperties(Exchange exchange, AMQP.BasicProperties properties) {
            if (properties.getType() != null) {
                exchange.getIn().setHeader("rabbitmq.TYPE", (Object)properties.getType());
            }
            if (properties.getAppId() != null) {
                exchange.getIn().setHeader("rabbitmq.APP_ID", (Object)properties.getAppId());
            }
            if (properties.getClusterId() != null) {
                exchange.getIn().setHeader("rabbitmq.CLUSTERID", (Object)properties.getClusterId());
            }
            if (properties.getContentEncoding() != null) {
                exchange.getIn().setHeader("rabbitmq.CONTENT_ENCODING", (Object)properties.getContentEncoding());
            }
            if (properties.getContentType() != null) {
                exchange.getIn().setHeader("rabbitmq.CONTENT_TYPE", (Object)properties.getContentType());
            }
            if (properties.getCorrelationId() != null) {
                exchange.getIn().setHeader("rabbitmq.CORRELATIONID", (Object)properties.getCorrelationId());
            }
            if (properties.getExpiration() != null) {
                exchange.getIn().setHeader("rabbitmq.EXPIRATION", (Object)properties.getExpiration());
            }
            if (properties.getMessageId() != null) {
                exchange.getIn().setHeader("rabbitmq.MESSAGE_ID", (Object)properties.getMessageId());
            }
            if (properties.getPriority() != null) {
                exchange.getIn().setHeader("rabbitmq.PRIORITY", (Object)properties.getPriority());
            }
            if (properties.getReplyTo() != null) {
                exchange.getIn().setHeader("rabbitmq.REPLY_TO", (Object)properties.getReplyTo());
            }
            if (properties.getTimestamp() != null) {
                exchange.getIn().setHeader("rabbitmq.TIMESTAMP", (Object)properties.getTimestamp());
            }
            if (properties.getUserId() != null) {
                exchange.getIn().setHeader("rabbitmq.USERID", (Object)properties.getUserId());
            }
        }
    }
}

