/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.LongString;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.rabbitmq.RabbitMQComponent;
import org.apache.camel.component.rabbitmq.RabbitMQConsumer;
import org.apache.camel.component.rabbitmq.RabbitMQProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultMessage;

public class RabbitMQEndpoint
extends DefaultEndpoint {
    private String username;
    private String password;
    private String vhost;
    private String hostname;
    private int threadPoolSize = 10;
    private int portNumber;
    private boolean autoAck = true;
    private boolean autoDelete = true;
    private boolean durable = true;
    private boolean bridgeEndpoint;
    private String queue = String.valueOf(UUID.randomUUID().toString().hashCode());
    private String exchangeName;
    private String exchangeType = "direct";
    private String routingKey;
    private Address[] addresses;

    public RabbitMQEndpoint() {
    }

    public RabbitMQEndpoint(String endpointUri, RabbitMQComponent component) throws URISyntaxException {
        super(endpointUri, (Component)component);
    }

    public Exchange createRabbitExchange(Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
        DefaultExchange exchange = new DefaultExchange(this.getCamelContext(), this.getExchangePattern());
        DefaultMessage message = new DefaultMessage();
        exchange.setIn((Message)message);
        message.setHeader("rabbitmq.ROUTING_KEY", (Object)envelope.getRoutingKey());
        message.setHeader("rabbitmq.EXCHANGE_NAME", (Object)envelope.getExchange());
        message.setHeader("rabbitmq.DELIVERY_TAG", (Object)envelope.getDeliveryTag());
        Map<String, Object> headers = properties.getHeaders();
        if (headers != null) {
            for (Map.Entry<String, Object> entry : headers.entrySet()) {
                if (entry.getValue() instanceof LongString) {
                    message.setHeader(entry.getKey(), (Object)entry.getValue().toString());
                    continue;
                }
                message.setHeader(entry.getKey(), entry.getValue());
            }
        }
        message.setBody((Object)body);
        return exchange;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        RabbitMQConsumer consumer = new RabbitMQConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Connection connect(ExecutorService executor) throws IOException {
        ConnectionFactory factory = new ConnectionFactory();
        factory.setUsername(this.getUsername());
        factory.setPassword(this.getPassword());
        if (this.getVhost() == null) {
            factory.setVirtualHost("/");
        } else {
            factory.setVirtualHost(this.getVhost());
        }
        factory.setHost(this.getHostname());
        factory.setPort(this.getPortNumber());
        if (this.getAddresses() == null) {
            return factory.newConnection(executor);
        }
        return factory.newConnection(executor, this.getAddresses());
    }

    public Producer createProducer() throws Exception {
        return new RabbitMQProducer(this);
    }

    public boolean isSingleton() {
        return true;
    }

    protected ExecutorService createExecutor() {
        if (this.getCamelContext() != null) {
            return this.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "RabbitMQConsumer", this.getThreadPoolSize());
        }
        return Executors.newFixedThreadPool(this.getThreadPoolSize());
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getVhost() {
        return this.vhost;
    }

    public void setVhost(String vhost) {
        this.vhost = vhost;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public boolean isAutoAck() {
        return this.autoAck;
    }

    public void setAutoAck(boolean autoAck) {
        this.autoAck = autoAck;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public void setAutoDelete(boolean autoDelete) {
        this.autoDelete = autoDelete;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public void setExchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
    }

    public String getExchangeType() {
        return this.exchangeType;
    }

    public void setExchangeType(String exchangeType) {
        this.exchangeType = exchangeType;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public void setBridgeEndpoint(boolean bridgeEndpoint) {
        this.bridgeEndpoint = bridgeEndpoint;
    }

    public boolean isBridgeEndpoint() {
        return this.bridgeEndpoint;
    }

    public void setAddresses(String addresses) {
        Address[] addressArray = Address.parseAddresses(addresses);
        if (addressArray.length > 0) {
            this.addresses = addressArray;
        }
    }

    public Address[] getAddresses() {
        return this.addresses;
    }
}

